/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import kcl.waterloo.graphics.GJAbstractGraphContainer;
import kcl.waterloo.graphics.GJBasicPanel;
import kcl.waterloo.graphics.GJGraph;
import kcl.waterloo.graphics.GJGraphContainer;
import kcl.waterloo.graphics.GJGridInterface;
import kcl.waterloo.swing.GCFrame;
import kcl.waterloo.swing.GCGrid;
import kcl.waterloo.swing.GCGridContainerInterface;
import kcl.waterloo.swing.GCGridElement;
import kcl.waterloo.swing.GCInfoBar;

public class GCGridContainer
extends GJBasicPanel
implements GCGridContainerInterface,
GJGridInterface,
ContainerListener {
    private GCGrid grid = new GCGrid();
    private GCInfoBar infoBar = new GCInfoBar();

    public GCGridContainer() {
        super(true);
        this.setBackground(Color.WHITE);
        this.setLayout(new BorderLayout());
        super.add((Component)this.grid, "Center");
        this.grid.addContainerListener(this);
        this.infoBar = new GCInfoBar();
        super.add((Component)this.infoBar, "South");
        this.setPreferredSize(new Dimension(500, 500));
    }

    public GCFrame createFrame() {
        GCFrame f = new GCFrame();
        f.setGraphicsContainer(this);
        return f;
    }

    @Override
    public Component add(Component comp) {
        if (comp instanceof GJGraphContainer) {
            return this.grid.add(comp);
        }
        return super.add(comp);
    }

    @Override
    public Component add(Component comp, double row, double column) {
        return this.grid.add(comp, row, column, 100.0, 100.0);
    }

    @Override
    public Component add(Component comp, double row, double column, double width, double height) {
        return this.grid.add(comp, row, column, width, height);
    }

    @Override
    public Component add(Component comp, double row, double column, double width, double height, int tab) throws UnsupportedOperationException {
        if (tab == 0) {
            return this.grid.add(comp, row, column, width, height);
        }
        throw new UnsupportedOperationException("GCGridContainer does not support tab indices>0");
    }

    @Override
    public Component getComponentAt(int tab) {
        if (tab == 0) {
            return this.grid;
        }
        return null;
    }

    public GCGrid getGrid() {
        return this.grid;
    }

    public void setGrid(GCGrid grid) {
        this.remove(grid);
        super.add(grid);
        this.grid = grid;
    }

    @Override
    public GCInfoBar getInfoBar() {
        return this.infoBar;
    }

    public void setInfoBar(GCInfoBar bar) {
        this.remove(this.infoBar);
        super.add(bar);
        this.infoBar = bar;
    }

    @Override
    public Container getSelected() {
        return this;
    }

    @Override
    public JLabel getGridIndicator() {
        return this.getInfoBar().getCenterright();
    }

    @Override
    public JLabel getMousePositionIndicator() {
        return this.getInfoBar().getRight();
    }

    @Override
    public double[] getLocation(Component c) {
        GCGridElement el;
        if (SwingUtilities.isDescendingFrom(c, this) && (el = c instanceof GCGridElement ? (GCGridElement)c : (GCGridElement)SwingUtilities.getAncestorOfClass(GCGridElement.class, c)) != null) {
            return new double[]{el.getProperties().getRow(), el.getProperties().getColumn()};
        }
        return new double[]{-1.0, -1.0};
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        if (e.getChild() instanceof GCGridElement) {
            for (int k = 0; k < ((GCGridElement)e.getChild()).getComponentCount(); ++k) {
                GJGraph gr;
                Component c;
                if (!(((GCGridElement)e.getChild()).getComponent(k) instanceof GJAbstractGraphContainer) || !((c = ((GCGridElement)e.getChild()).getComponent(k)) instanceof GJAbstractGraphContainer) || (gr = (GJGraph)((GJAbstractGraphContainer)c).getView()) == null) continue;
                gr.setGridInterface(this);
            }
        }
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        if (e.getChild() instanceof GCGridElement) {
            for (int k = 0; k < ((GCGridElement)e.getChild()).getComponentCount(); ++k) {
                GJGraph gr;
                Component c;
                if (!(((GCGridElement)e.getChild()).getComponent(k) instanceof GJAbstractGraphContainer) || !((c = ((GCGridElement)e.getChild()).getComponent(k)) instanceof GJAbstractGraphContainer) || (gr = (GJGraph)((GJAbstractGraphContainer)c).getView()) == null) continue;
                gr.setGridInterface(null);
            }
        }
    }

    public void addTab(String s, Component c) {
        throw new UnsupportedOperationException("GCGridContainer does not support tab indices>0");
    }
}

