/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import kcl.waterloo.actions.ActionManager;
import kcl.waterloo.graphics.GJBasicPanel;
import kcl.waterloo.swing.GCGlassLayer;
import kcl.waterloo.swing.GCGridContainer;
import kcl.waterloo.swing.GCGridElement;
import kcl.waterloo.swing.GCTabbedGridContainer;
import kcl.waterloo.swing.layout.SpringGridLayout;

public final class GCGrid
extends GJBasicPanel {
    SpringGridLayout gridLayout = new SpringGridLayout();
    private GCGlassLayer glassLayer = new GCGlassLayer();

    public GCGrid() {
        this.setLayout(this.gridLayout);
        super.add(this.glassLayer);
        this.setBackground(Color.WHITE);
        this.setBackgroundPainted(true);
        this.setOpaque(true);
        this.getGlassLayer().setOpaque(false);
    }

    public JMenu getGridMenu() {
        JMenu gridMenu = new JMenu("Grid");
        JMenuItem saveMenu = new JMenuItem("Save All");
        JMenuItem exportMenu = new JMenuItem("Export Grid");
        JMenuItem copyMenu = new JMenuItem("Copy Grid");
        saveMenu.setActionCommand("Save Graph");
        exportMenu.setActionCommand("Save Graph As");
        copyMenu.setActionCommand("Copy");
        GridMenuAction action = new GridMenuAction(this);
        saveMenu.addActionListener(action);
        exportMenu.addActionListener(action);
        copyMenu.addActionListener(action);
        gridMenu.add(saveMenu);
        gridMenu.add(exportMenu);
        gridMenu.add(copyMenu);
        return gridMenu;
    }

    @Override
    public SpringGridLayout getLayout() {
        return this.gridLayout;
    }

    @Override
    public Component add(Component c) {
        if (c instanceof GCGridElement) {
            return super.add(c);
        }
        return this.add(c, 0.0, 0.0, 1.0, 1.0);
    }

    public Component add(Component c, double row, double column) {
        return this.add(c, row, column, 1.0, 1.0);
    }

    public Component add(Component c, double row, double column, double width, double height) {
        if (c instanceof GCGridElement) {
            return super.add(c);
        }
        GCGridElement el = new GCGridElement(c);
        el.getProperties().setRow(row);
        el.getProperties().setColumn(column);
        el.getProperties().setColumnWidth(width);
        el.getProperties().setRowHeight(height);
        return super.add(el);
    }

    public ArrayList<GCGridElement> getElementsAt(double row, double column) {
        ArrayList<GCGridElement> arr = this.getElements();
        ArrayList<GCGridElement> arr2 = new ArrayList<GCGridElement>();
        for (GCGridElement el : arr) {
            if (el.getProperties().getRow() != row || el.getProperties().getColumn() != column) continue;
            arr2.add(el);
        }
        return arr2;
    }

    public GCGlassLayer getGlassLayer() {
        return this.glassLayer;
    }

    public void setGlassLayer(GCGlassLayer gl) {
        this.glassLayer = gl;
    }

    public double[] getDimensions() {
        double columnCount = 0.0;
        double rowCount = 0.0;
        for (int k = 0; k < this.getComponentCount(); ++k) {
            if (!(this.getComponent(k) instanceof GCGridElement)) continue;
            GCGridElement el = (GCGridElement)this.getComponent(k);
            rowCount = Math.max(el.getProperties().getRow() + el.getProperties().getRowHeight(), rowCount);
            columnCount = Math.max(el.getProperties().getColumn() + el.getProperties().getColumnWidth(), columnCount);
        }
        return new double[]{rowCount, columnCount};
    }

    public ArrayList<GCGridElement> getElements() {
        ArrayList<GCGridElement> arr = new ArrayList<GCGridElement>();
        for (int k = 0; k < this.getComponentCount(); ++k) {
            if (!(this.getComponent(k) instanceof GCGridElement)) continue;
            arr.add((GCGridElement)this.getComponent(k));
        }
        return arr;
    }

    @Override
    public void revalidate() {
        for (int k = 0; k < this.getComponentCount(); ++k) {
            GCGridElement el;
            if (!(this.getComponent(k) instanceof GCGridElement) || (el = (GCGridElement)this.getComponent(k)).getProperties().getZOrder() <= 0) continue;
            this.setComponentZOrder(el, el.getProperties().getZOrder());
        }
        super.validate();
    }

    public static class GridMenuAction
    implements ActionListener {
        final JComponent target;

        public GridMenuAction(JComponent target) {
            this.target = target;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Container c2;
            JComponent c = this.target;
            if (e.getActionCommand().equals("Copy")) {
                c2 = SwingUtilities.getAncestorOfClass(GCTabbedGridContainer.class, c);
                if (c2 == null) {
                    c2 = SwingUtilities.getAncestorOfClass(GCGridContainer.class, c);
                }
            } else {
                c2 = SwingUtilities.getAncestorOfClass(GCTabbedGridContainer.class, c);
                if (c2 == null) {
                    c2 = SwingUtilities.getAncestorOfClass(GCGridContainer.class, c);
                }
            }
            if (c2 != null) {
                e.setSource(c2);
            }
            ActionManager.processAction(e, (Component)e.getSource());
        }
    }
}

