/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kcl.waterloo.actions.ActionManager;
import kcl.waterloo.logging.CommonLogger;
import kcl.waterloo.swing.FrameManager;
import kcl.waterloo.swing.GCFrameInterface;
import kcl.waterloo.swing.GCGridContainer;
import kcl.waterloo.swing.GCGridContainerInterface;
import kcl.waterloo.swing.GCTabbedGridContainer;
import kcl.waterloo.swing.MenuFactory;

public class GCFrame
extends JFrame
implements GCFrameInterface,
ChangeListener {
    private GCGridContainerInterface graphicsContainer = new GCGridContainer();
    private static final CommonLogger logger = new CommonLogger(GCFrame.class);

    public GCFrame() {
        this("");
        this.setContentPane((Container)((Object)this.graphicsContainer));
    }

    public GCFrame(String titleText) {
        int frameCount = FrameManager.getLowestAvailable();
        this.setTitle("Frame " + frameCount + ": " + titleText);
        this.setName("Frame" + frameCount);
        this.init(frameCount);
        this.setSize(500, 500);
        this.setBackground(Color.WHITE);
        this.setVisible(true);
        this.setDefaultCloseOperation(2);
    }

    public GCFrame(String titleText, int xsize, int ysize, boolean isshown) {
        int frameCount = FrameManager.getLowestAvailable();
        this.setTitle("Frame " + frameCount + ": " + titleText);
        this.setName("Frame" + frameCount);
        this.init(frameCount);
        this.setSize(xsize, ysize);
        this.setBackground(Color.WHITE);
        this.setVisible(isshown);
        this.setDefaultCloseOperation(2);
    }

    private void init(int frameCount) {
        this.graphicsContainer = new GCGridContainer();
        this.setContentPane((Container)((Object)this.graphicsContainer));
        FrameManager.getList().put(Double.valueOf(frameCount), this);
        this.setJMenuBar(MenuFactory.createMenu(this));
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(FrameManager.getInstance());
    }

    public GCGridContainerInterface getGraphicsContainer() {
        return this.graphicsContainer;
    }

    public final void setGraphicsContainer(GCGridContainerInterface c) {
        this.setContentPane((Container)((Object)c));
        this.graphicsContainer = c;
    }

    @Override
    public Component add(Component c) {
        return this.add(c, 0.0, 0.0, 0);
    }

    public final Component add(Component c, double row, double column, int tab) throws UnsupportedOperationException {
        return this.add(c, row, column, 1.0, 1.0, tab);
    }

    public final Component add(Component c, double row, double column, double width, double height, int tab) throws UnsupportedOperationException {
        GCGridContainerInterface contents = this.getGraphicsContainer();
        if (contents instanceof GCTabbedGridContainer) {
            GCGridContainerInterface thisTab = (GCGridContainerInterface)((Object)contents.getComponentAt(tab));
            return thisTab.add(c, row, column, width, height);
        }
        if (contents instanceof GCGridContainer && tab == 0) {
            return contents.add(c, row, column, width, height);
        }
        logger.error("Target does not implement the GCGridContainerInterface");
        return null;
    }

    public void makeTabbed(String title) {
        if (this.getGraphicsContainer() instanceof GCGridContainer) {
            Component contents = (Component)((Object)this.getGraphicsContainer());
            GCTabbedGridContainer tabbedPanel = new GCTabbedGridContainer();
            tabbedPanel.addChangeListener(this);
            this.setContentPane(tabbedPanel);
            this.setGraphicsContainer(tabbedPanel);
            tabbedPanel.insertTab(title, null, contents, "", 0);
        }
    }

    public Component addTab(String s, Component c) throws UnsupportedOperationException {
        if (this.graphicsContainer instanceof JTabbedPane) {
            ((JTabbedPane)((Object)this.getGraphicsContainer())).addTab(s, c);
            return c;
        }
        logger.error("Target does not support tabs");
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.toFront();
        ActionManager.processAction(ae, (Component)((Object)this.getGraphicsContainer()));
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
    }
}

