/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.serviceproviders;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kcl.waterloo.actions.ActionManager;
import kcl.waterloo.graphics.GJGraphInterface;
import kcl.waterloo.gui.BasePanel;
import kcl.waterloo.gui.LogoPanel;
import kcl.waterloo.serviceproviders.EditorFrame;
import kcl.waterloo.serviceproviders.GJGraphEditor;
import kcl.waterloo.serviceproviders.ToolBar;
import org.jdesktop.swingx.VerticalLayout;

public class GUIFactory {
    public static void graphEditor(final GJGraphInterface gr) {
        if (gr.fetchEditor() == null) {
            gr.setEditor(new GJGraphEditor(gr));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditorFrame frame = new EditorFrame(gr, "GraphEditor");
                frame.setDefaultCloseOperation(2);
                frame.addWindowListener(frame);
                frame.setResizable(true);
                frame.setLayout(new VerticalLayout());
                JComponent panel = new LogoPanel();
                panel.setPreferredSize(new Dimension(580, 70));
                frame.add(panel);
                panel = new ToolBar((Component)((Object)gr));
                panel.setPreferredSize(new Dimension(580, 25));
                frame.add(panel);
                GUIFactory.installActions((ToolBar)panel);
                panel = (JComponent)((Object)gr.fetchEditor());
                panel.setPreferredSize(new Dimension(580, 540));
                frame.add(panel);
                panel = new BasePanel();
                panel.setPreferredSize(new Dimension(580, 15));
                frame.add(panel);
                frame.setLocationByPlatform(true);
                frame.setVisible(true);
                frame.pack();
            }
        });
    }

    private static void installActions(ToolBar bar) {
        bar.getOpenButton().addActionListener(LocalActionListener.getInstance());
        bar.getSaveButton().addActionListener(LocalActionListener.getInstance());
        bar.getSaveAsButton().addActionListener(LocalActionListener.getInstance());
        bar.getDeployButton().addActionListener(LocalActionListener.getInstance());
        bar.getCopyButton().addActionListener(LocalActionListener.getInstance());
        bar.getCopyAsImageButton().addActionListener(LocalActionListener.getInstance());
        bar.getPrintButton().addActionListener(LocalActionListener.getInstance());
        bar.getDefaultsButton().addActionListener(LocalActionListener.getInstance());
        bar.getStartRecording().addActionListener(LocalActionListener.getInstance());
        bar.getPauseRecording().addActionListener(LocalActionListener.getInstance());
        bar.getStopRecording().addActionListener(LocalActionListener.getInstance());
        bar.getSaveRecording().addActionListener(LocalActionListener.getInstance());
    }

    static class LocalActionListener
    implements ActionListener {
        static LocalActionListener instance = new LocalActionListener();

        private LocalActionListener() {
        }

        static LocalActionListener getInstance() {
            return instance;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            EditorFrame editor = (EditorFrame)((JComponent)ae.getSource()).getTopLevelAncestor();
            ActionManager.processAction(ae, editor.getGraph().getGraphContainer());
        }
    }
}

