/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.serviceproviders;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import kcl.waterloo.graphics.GJAbstractGraph;
import kcl.waterloo.graphics.GJAbstractGraphContainer;
import kcl.waterloo.graphics.transforms.GJDataTransformInterface;
import kcl.waterloo.graphics.transforms.Services;
import kcl.waterloo.serviceproviders.GJEditorInterface;
import kcl.waterloo.widget.GJColorComboBox;
import kcl.waterloo.widget.GJDial;
import org.jdesktop.swingx.painter.effects.AreaEffect;
import org.jdesktop.swingx.painter.effects.NeonBorderEffect;
import org.jdesktop.swingx.painter.effects.ShadowPathEffect;

public class BindingManager
implements ActionListener,
ChangeListener,
FocusListener {
    static final String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    static final LinkedHashMap<String, GJDataTransformInterface> transformList = Services.getAvailable();
    private static final NumberFormat nf = NumberFormat.getInstance();
    private final FontControl fontControl = new FontControl();
    ArrayList<JComponent> componentList;
    GJEditorInterface editor = null;
    GJAbstractGraphContainer graphContainer = null;

    public BindingManager(GJEditorInterface gui) {
        this.editor = gui;
        this.graphContainer = this.editor.getGraphContainer();
        this.componentList = this.getComponentsAsList((JComponent)((Object)gui));
        this.componentList = this.getRequiredFromList(this.componentList);
        this.init();
        this.addListeners();
    }

    final void init() {
        int idx = this.editor.getSelectedTab();
        for (JComponent o : this.componentList) {
            this.initContainer(o, fonts);
        }
        for (int k = 0; k < this.editor.getTabbedPane().getTabCount(); ++k) {
            this.editor.setSelectedTab(k);
            Component c = this.editor.getTabbedPane().getSelectedComponent();
            for (JComponent o : this.componentList) {
                if (!SwingUtilities.isDescendingFrom(o, c)) continue;
                this.initTabContents(o);
            }
        }
        this.editor.setSelectedTab(idx);
    }

    private void addListeners() {
        this.addAsActionListener(this.componentList);
        for (JComponent thisComponent : this.componentList) {
            thisComponent.addFocusListener(this);
        }
    }

    final void addAsActionListener(ArrayList<JComponent> list) {
        for (JComponent thisComponent : list) {
            Method meth = null;
            try {
                meth = thisComponent.getClass().getMethod("addActionListener", ActionListener.class);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException e) {
                try {
                    meth = thisComponent.getClass().getMethod("addChangeListener", ChangeListener.class);
                }
                catch (SecurityException securityException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (meth == null) continue;
            try {
                meth.invoke((Object)thisComponent, this);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
    }

    final ArrayList<JComponent> getComponentsAsList(JComponent obj) {
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        list.add(obj);
        for (int k = 0; k < obj.getComponentCount(); ++k) {
            try {
                JComponent thisComponent = (JComponent)obj.getComponent(k);
                if (thisComponent.getComponentCount() > 0) {
                    list.addAll(this.getComponentsAsList(thisComponent));
                    continue;
                }
                list.add(thisComponent);
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return list;
    }

    final ArrayList<JComponent> getRequiredFromList(ArrayList<JComponent> list) {
        ArrayList<JComponent> newlist = new ArrayList<JComponent>();
        for (JComponent thisComponent : list) {
            if (thisComponent.getName() == null || thisComponent.getName().isEmpty() || thisComponent.getName().charAt(0) != '$') continue;
            newlist.add(thisComponent);
        }
        return newlist;
    }

    ArrayList<JComponent> getComponentList() {
        return this.componentList;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        try {
            this.eventHandler((JComponent)arg0.getSource());
            this.graphContainer.revalidate();
            this.graphContainer.repaint();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        try {
            this.eventHandler((JComponent)ce.getSource());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.graphContainer.revalidate();
        this.graphContainer.repaint();
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        try {
            this.eventHandler((JComponent)arg0.getSource());
            this.graphContainer.revalidate();
            this.graphContainer.repaint();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    final void initContainer(JComponent o, String[] fonts) {
        if (this.graphContainer != null) {
            if (o.getName().equals("$Title")) {
                JTextField thisComponent = (JTextField)o;
                thisComponent.setText(this.graphContainer.getTitleText());
            } else if (o.getName().equals("$SubTitle")) {
                JTextField thisComponent = (JTextField)o;
                thisComponent.setText(this.graphContainer.getSubTitleText());
            } else if (o.getName().equals("$Rotation")) {
                JComboBox thisComponent = (JComboBox)o;
                thisComponent.setSelectedItem(this.graphContainer.getRotation() * 180.0 / Math.PI);
            } else if (o.getName().equals("$rotateDial")) {
                GJDial thisComponent = (GJDial)o;
                thisComponent.setValue((int)(this.graphContainer.getRotation() * 180.0 / Math.PI));
            } else if (o.getName().equals("$Zoom")) {
                JComboBox thisComponent = (JComboBox)o;
                thisComponent.setSelectedItem(this.graphContainer.getZoom() * 100.0);
            } else if (o.getName().equals("$zoomDial")) {
                GJDial thisComponent = (GJDial)o;
                thisComponent.setValue((int)(this.graphContainer.getZoom() * 100.0));
            } else if (o.getName().equals("$Font")) {
                JComboBox thisComponent = (JComboBox)o;
                if (thisComponent.getItemCount() == 0) {
                    for (String font : fonts) {
                        thisComponent.addItem(font);
                    }
                    this.fontControl.font = thisComponent;
                }
                thisComponent.setSelectedItem(this.graphContainer.getFont().getFamily());
            } else if (o.getName().equals("$FontSize")) {
                JComboBox thisComponent = (JComboBox)o;
                if (thisComponent.getItemCount() == 0) {
                    for (int k = 2; k < 32; k += 2) {
                        thisComponent.addItem(new Integer(k).toString());
                    }
                    this.fontControl.size = thisComponent;
                }
                int sz = this.graphContainer.getFont().getSize();
                thisComponent.setSelectedItem(new Integer(sz).toString());
            } else if (o.getName().equals("$Bold")) {
                JToggleButton thisComponent = (JToggleButton)o;
                if (this.fontControl.bold == null) {
                    this.fontControl.bold = thisComponent;
                }
                thisComponent.setSelected(this.graphContainer.getFont().isBold());
            } else if (o.getName().equals("$Italic")) {
                JToggleButton thisComponent = (JToggleButton)o;
                if (this.fontControl.italic == null) {
                    this.fontControl.italic = thisComponent;
                }
                thisComponent.setSelected(this.graphContainer.getFont().isItalic());
            } else if (o.getName().equals("$AspectRatio")) {
                JComboBox thisComponent = (JComboBox)o;
                double aspectRatio = this.graphContainer.getAspectRatio();
                if (aspectRatio <= 0.0) {
                    thisComponent.setSelectedIndex(0);
                } else {
                    thisComponent.setSelectedItem(Double.valueOf(aspectRatio).toString());
                }
            } else if (o.getName().equals("$ContainerForeground")) {
                GJColorComboBox thisComponent = (GJColorComboBox)o;
                thisComponent.setSelectedColor(this.graphContainer.getForeground());
            } else if (o.getName().equals("$ContainerBackgroundPainted")) {
                JCheckBox thisComponent = (JCheckBox)o;
                thisComponent.setSelected(this.graphContainer.isBackgroundPainted());
            } else if (o.getName().equals("$ContainerBackground")) {
                GJColorComboBox thisComponent = (GJColorComboBox)o;
                thisComponent.setSelectedColor(this.graphContainer.getBackground());
            } else if (o.getName().equals("$Shadow")) {
                JCheckBox thisComponent = (JCheckBox)o;
                thisComponent.setSelected(this.graphContainer.getEffect() instanceof ShadowPathEffect);
            } else if (o.getName().equals("$Frame")) {
                JCheckBox thisComponent = (JCheckBox)o;
                thisComponent.setSelected(this.graphContainer.getEffect() instanceof NeonBorderEffect);
            }
        }
    }

    final void initTabContents(JComponent o) {
        if (o.getName().equals("$AxisRangeLeft")) {
            JTextField thisComponent = (JTextField)o;
            Double val = this.editor.getLayerForTab().getXLeft();
            if (!val.isNaN() && !val.isInfinite()) {
                thisComponent.setText(nf.format(val));
            }
        } else if (o.getName().equals("$AxisRangeRight")) {
            JTextField thisComponent = (JTextField)o;
            Double val = this.editor.getLayerForTab().getXRight();
            if (!val.isNaN() && !val.isInfinite()) {
                thisComponent.setText(nf.format(val));
            }
        } else if (o.getName().equals("$AxisRangeBottom")) {
            JTextField thisComponent = (JTextField)o;
            Double val = this.editor.getLayerForTab().getYBottom();
            if (!val.isNaN() && !val.isInfinite()) {
                thisComponent.setText(nf.format(val));
            }
        } else if (o.getName().equals("$AxisRangeTop")) {
            JTextField thisComponent = (JTextField)o;
            Double val = this.editor.getLayerForTab().getYTop();
            if (!val.isNaN() && !val.isInfinite()) {
                thisComponent.setText(nf.format(val));
            }
        } else if (o.getName().equals("$Left")) {
            JToggleButton thisComponent = (JToggleButton)o;
            thisComponent.setSelected(this.editor.getLayerForTab().isLeftAxisPainted());
        } else if (o.getName().equals("$Right")) {
            JToggleButton thisComponent = (JToggleButton)o;
            thisComponent.setSelected(this.editor.getLayerForTab().isRightAxisPainted());
        } else if (o.getName().equals("$Top")) {
            JToggleButton thisComponent = (JToggleButton)o;
            thisComponent.setSelected(this.editor.getLayerForTab().isTopAxisPainted());
        } else if (o.getName().equals("$Bottom")) {
            JToggleButton thisComponent = (JToggleButton)o;
            thisComponent.setSelected(this.editor.getLayerForTab().isBottomAxisPainted());
        } else if (o.getName().equals("$XAxisLabel")) {
            JTextField thisComponent = (JTextField)o;
            thisComponent.setText(this.editor.getLayerForTab().getXLabel());
        } else if (o.getName().equals("$YAxisLabel")) {
            JTextField thisComponent = (JTextField)o;
            thisComponent.setText(this.editor.getLayerForTab().getYLabel());
        } else if (o.getName().equals("$XReverse")) {
            JCheckBox thisComponent = (JCheckBox)o;
            thisComponent.setSelected(this.editor.getLayerForTab().isXReversed());
        } else if (o.getName().equals("$YReverse")) {
            JCheckBox thisComponent = (JCheckBox)o;
            thisComponent.setSelected(this.editor.getLayerForTab().isYReversed());
        } else if (o.getName().equals("$XTransform")) {
            JComboBox thisComponent = (JComboBox)o;
            if (thisComponent.getItemCount() == 0) {
                for (String item : transformList.keySet()) {
                    thisComponent.addItem(item);
                }
            }
            thisComponent.setSelectedItem(this.editor.getLayerForTab().getXTransform().getName());
        } else if (o.getName().equals("$YTransform")) {
            JComboBox thisComponent = (JComboBox)o;
            if (thisComponent.getItemCount() == 0) {
                for (String item : transformList.keySet()) {
                    thisComponent.addItem(item);
                }
            }
            thisComponent.setSelectedItem(this.editor.getLayerForTab().getYTransform().getName());
        } else if (o.getName().equals("$Left")) {
            JToggleButton thisComponent = (JToggleButton)o;
            thisComponent.setSelected(this.editor.getLayerForTab().isLeftAxisPainted());
        } else if (o.getName().equals("$Right")) {
            JToggleButton thisComponent = (JToggleButton)o;
            thisComponent.setSelected(this.editor.getLayerForTab().isRightAxisPainted());
        } else if (o.getName().equals("$Top")) {
            JToggleButton thisComponent = (JToggleButton)o;
            thisComponent.setSelected(this.editor.getLayerForTab().isTopAxisPainted());
        } else if (o.getName().equals("$Bottom")) {
            JToggleButton thisComponent = (JToggleButton)o;
            thisComponent.setSelected(this.editor.getLayerForTab().isBottomAxisPainted());
        } else if (o.getName().equals("$LeftLabels")) {
            JToggleButton thisComponent = (JToggleButton)o;
            thisComponent.setSelected(this.editor.getLayerForTab().isLeftAxisLabelled());
        } else if (o.getName().equals("$RightLabels")) {
            JToggleButton thisComponent = (JToggleButton)o;
            thisComponent.setSelected(this.editor.getLayerForTab().isRightAxisLabelled());
        } else if (o.getName().equals("$TopLabels")) {
            JToggleButton thisComponent = (JToggleButton)o;
            thisComponent.setSelected(this.editor.getLayerForTab().isTopAxisLabelled());
        } else if (o.getName().equals("$BottomLabels")) {
            JToggleButton thisComponent = (JToggleButton)o;
            thisComponent.setSelected(this.editor.getLayerForTab().isBottomAxisLabelled());
        } else if (o.getName().equals("$MajorGrid")) {
            JToggleButton thisComponent = (JToggleButton)o;
            thisComponent.setSelected(this.editor.getLayerForTab().isMajorGridPainted());
        } else if (o.getName().equals("$MinorGrid")) {
            JToggleButton thisComponent = (JToggleButton)o;
            thisComponent.setSelected(this.editor.getLayerForTab().isMinorGridPainted());
        } else if (o.getName().equals("$InnerAxis")) {
            JCheckBox thisComponent = (JCheckBox)o;
            thisComponent.setSelected(this.editor.getLayerForTab().isInnerAxisPainted());
        } else if (o.getName().equals("$InnerAxisLabels")) {
            JCheckBox thisComponent = (JCheckBox)o;
            thisComponent.setSelected(this.editor.getLayerForTab().isInnerAxisLabelled());
        } else if (o.getName().equals("$XDiv")) {
            JSpinner thisComponent = (JSpinner)o;
            thisComponent.setValue(this.editor.getLayerForTab().getMinorCountXHint());
        } else if (o.getName().equals("$YDiv")) {
            JSpinner thisComponent = (JSpinner)o;
            thisComponent.setValue(this.editor.getLayerForTab().getMinorCountYHint());
        } else if (o.getName().equals("$Alpha")) {
            JComboBox thisComponent = (JComboBox)o;
            thisComponent.setSelectedItem(Float.valueOf(((GJAbstractGraph)this.editor.getLayerForTab()).getAlpha()).toString());
        } else if (o.getName().equals("$GridColor")) {
            GJColorComboBox thisComponent = (GJColorComboBox)o;
            thisComponent.setSelectedColor(this.editor.getLayerForTab().getMajorGridColor());
        } else if (o.getName().equals("$AxisColor")) {
            GJColorComboBox thisComponent = (GJColorComboBox)o;
            thisComponent.setSelectedColor(this.editor.getLayerForTab().getAxisColor());
        } else if (o.getName().equals("$Polar")) {
            JCheckBox thisComponent = (JCheckBox)o;
            thisComponent.setSelected(this.editor.getLayerForTab().isPolar());
        } else if (o.getName().equals("$BackgroundPainted")) {
            JCheckBox thisComponent = (JCheckBox)o;
            thisComponent.setSelected(((GJAbstractGraph)this.editor.getLayerForTab()).isBackgroundPainted());
        }
    }

    private void eventHandler(final JComponent o) throws ParseException {
        String name;
        JComponent thisComponent;
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        BindingManager.this.eventHandler(o);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            });
            return;
        }
        if (o.getName().equals("$AxisRangeLeft")) {
            thisComponent = (JTextField)o;
            Double val = nf.parse(((JTextComponent)thisComponent).getText()).doubleValue();
            if (!val.isNaN() && !val.isInfinite()) {
                this.editor.getLayerForTab().setXLeft(val);
            }
        } else if (o.getName().equals("$AxisRangeRight")) {
            thisComponent = (JTextField)o;
            Double val = nf.parse(((JTextComponent)thisComponent).getText()).doubleValue();
            if (!val.isNaN() && !val.isInfinite()) {
                this.editor.getLayerForTab().setXRight(val);
            }
        } else if (o.getName().equals("$AxisRangeBottom")) {
            thisComponent = (JTextField)o;
            Double val = nf.parse(((JTextComponent)thisComponent).getText()).doubleValue();
            if (!val.isNaN() && !val.isInfinite()) {
                this.editor.getLayerForTab().setYBottom(val);
            }
        } else if (o.getName().equals("$AxisRangeTop")) {
            thisComponent = (JTextField)o;
            Double val = nf.parse(((JTextComponent)thisComponent).getText()).doubleValue();
            if (!val.isNaN() && !val.isInfinite()) {
                this.editor.getLayerForTab().setYTop(val);
            }
        } else if (o.getName().equals("$Left")) {
            thisComponent = (JToggleButton)o;
            this.editor.getLayerForTab().setLeftAxisPainted(((AbstractButton)thisComponent).isSelected());
        } else if (o.getName().equals("$Right")) {
            thisComponent = (JToggleButton)o;
            this.editor.getLayerForTab().setRightAxisPainted(((AbstractButton)thisComponent).isSelected());
        } else if (o.getName().equals("$Top")) {
            thisComponent = (JToggleButton)o;
            this.editor.getLayerForTab().setTopAxisPainted(((AbstractButton)thisComponent).isSelected());
        } else if (o.getName().equals("$Bottom")) {
            thisComponent = (JToggleButton)o;
            this.editor.getLayerForTab().setBottomAxisPainted(((AbstractButton)thisComponent).isSelected());
        } else if (o.getName().equals("$LeftLabels")) {
            thisComponent = (JToggleButton)o;
            this.editor.getLayerForTab().setLeftAxisLabelled(((AbstractButton)thisComponent).isSelected());
        } else if (o.getName().equals("$RightLabels")) {
            thisComponent = (JToggleButton)o;
            this.editor.getLayerForTab().setRightAxisLabelled(((AbstractButton)thisComponent).isSelected());
        } else if (o.getName().equals("$TopLabels")) {
            thisComponent = (JToggleButton)o;
            this.editor.getLayerForTab().setTopAxisLabelled(((AbstractButton)thisComponent).isSelected());
        } else if (o.getName().equals("$BottomLabels")) {
            thisComponent = (JToggleButton)o;
            this.editor.getLayerForTab().setBottomAxisLabelled(((AbstractButton)thisComponent).isSelected());
        } else if (o.getName().equals("$XAxisLabel")) {
            thisComponent = (JTextField)o;
            this.editor.getLayerForTab().setXLabel(((JTextComponent)thisComponent).getText());
        } else if (o.getName().equals("$YAxisLabel")) {
            thisComponent = (JTextField)o;
            this.editor.getLayerForTab().setYLabel(((JTextComponent)thisComponent).getText());
        } else if (o.getName().equals("$XReverse")) {
            thisComponent = (JCheckBox)o;
            this.editor.getLayerForTab().setReverseX(((AbstractButton)thisComponent).isSelected());
        } else if (o.getName().equals("$YReverse")) {
            thisComponent = (JCheckBox)o;
            this.editor.getLayerForTab().setReverseY(((AbstractButton)thisComponent).isSelected());
        } else if (o.getName().equals("$XTransform")) {
            thisComponent = (JComboBox)o;
            name = (String)((JComboBox)thisComponent).getSelectedItem();
            GJDataTransformInterface tr = Services.getInstanceForName(name);
            if (this.editor.getLayerForTab().getXTransform().getName().equals(name)) {
                return;
            }
            double l = this.editor.getLayerForTab().getXTransform().getInverse(this.editor.getLayerForTab().getXLeft());
            double r = this.editor.getLayerForTab().getXTransform().getInverse(this.editor.getLayerForTab().getXRight());
            l = tr.getData(l);
            r = tr.getData(r);
            if (Double.isNaN(l) || Double.isInfinite(l)) {
                l = 0.0;
            }
            if (Double.isNaN(r) || Double.isInfinite(r)) {
                r = 0.0;
            }
            Rectangle2D bounds = this.editor.getLayerForTab().getAxesBounds();
            this.editor.getLayerForTab().setAxesBounds(new Rectangle2D.Double(r >= l ? l : r, bounds.getY(), r >= l ? r - l : l - r, bounds.getHeight()));
            this.editor.getLayerForTab().setXTransform(tr);
        } else if (o.getName().equals("$YTransform")) {
            thisComponent = (JComboBox)o;
            name = (String)((JComboBox)thisComponent).getSelectedItem();
            GJDataTransformInterface tr = Services.getInstanceForName(name);
            if (this.editor.getLayerForTab().getYTransform().getName().equals(name)) {
                return;
            }
            double t = this.editor.getLayerForTab().getYTransform().getInverse(this.editor.getLayerForTab().getYTop());
            double b = this.editor.getLayerForTab().getYTransform().getInverse(this.editor.getLayerForTab().getYBottom());
            t = tr.getData(t);
            b = tr.getData(b);
            if (Double.isNaN(t) || Double.isInfinite(t)) {
                t = 0.0;
            }
            if (Double.isNaN(b) || Double.isInfinite(b)) {
                b = 0.0;
            }
            Rectangle2D bounds = this.editor.getLayerForTab().getAxesBounds();
            this.editor.getLayerForTab().setAxesBounds(new Rectangle2D.Double(bounds.getX(), t >= b ? b : t, bounds.getWidth(), t >= b ? t - b : b - t));
            this.editor.getLayerForTab().setYTransform(tr);
        } else if (o.getName().equals("$MajorGrid")) {
            thisComponent = (JToggleButton)o;
            this.editor.getLayerForTab().setMajorGridPainted(((AbstractButton)thisComponent).isSelected());
        } else if (o.getName().equals("$MinorGrid")) {
            thisComponent = (JToggleButton)o;
            this.editor.getLayerForTab().setMinorGridPainted(((AbstractButton)thisComponent).isSelected());
        } else if (o.getName().equals("$InnerAxis")) {
            thisComponent = (JCheckBox)o;
            this.editor.getLayerForTab().setInnerAxisPainted(((AbstractButton)thisComponent).isSelected());
        } else if (o.getName().equals("$InnerAxisLabels")) {
            thisComponent = (JCheckBox)o;
            this.editor.getLayerForTab().setInnerAxisLabelled(((AbstractButton)thisComponent).isSelected());
        } else if (o.getName().equals("$XDiv")) {
            thisComponent = (JSpinner)o;
            this.editor.getLayerForTab().setMinorCountXHint(((Number)((JSpinner)thisComponent).getValue()).intValue());
        } else if (o.getName().equals("$YDiv")) {
            thisComponent = (JSpinner)o;
            this.editor.getLayerForTab().setMinorCountYHint(((Number)((JSpinner)thisComponent).getValue()).intValue());
        } else if (o.getName().equals("$Alpha")) {
            thisComponent = (JComboBox)o;
            ((GJAbstractGraph)this.editor.getLayerForTab()).setAlpha(Float.valueOf((String)((JComboBox)thisComponent).getSelectedItem()).floatValue());
        } else if (o.getName().equals("$BackgroundPainted")) {
            thisComponent = (JCheckBox)o;
            this.editor.getLayerForTab().setBackgroundPainted(((AbstractButton)thisComponent).isSelected());
        } else if (o.getName().equals("$Background")) {
            thisComponent = (GJColorComboBox)o;
            ((GJAbstractGraph)this.editor.getLayerForTab()).setBackground(((GJColorComboBox)thisComponent).getSelectedColor());
        } else if (o.getName().equals("$GridColor")) {
            thisComponent = (GJColorComboBox)o;
            this.editor.getLayerForTab().setMajorGridColor(((GJColorComboBox)thisComponent).getSelectedColor());
            this.editor.getLayerForTab().setMinorGridColor(((GJColorComboBox)thisComponent).getSelectedColor());
        } else if (o.getName().equals("$AxisColor")) {
            thisComponent = (GJColorComboBox)o;
            this.editor.getLayerForTab().setAxisColor(((GJColorComboBox)thisComponent).getSelectedColor());
        } else if (o.getName().equals("$Polar")) {
            thisComponent = (JCheckBox)o;
            GJAbstractGraph gr = (GJAbstractGraph)this.editor.getLayerForTab();
            gr.setPolar(((AbstractButton)thisComponent).isSelected());
            if (((AbstractButton)thisComponent).isSelected()) {
                if (gr.getGraphContainer() != null) {
                    gr.getGraphContainer().setAspectRatio(1.0);
                }
                gr.setInnerAxisLabelled(true);
                gr.setTopAxisPainted(false);
                gr.setBottomAxisPainted(false);
                gr.setLeftAxisPainted(false);
                gr.setRightAxisPainted(false);
            } else {
                gr.setInnerAxisLabelled(false);
                gr.setBottomAxisPainted(true);
                gr.setLeftAxisPainted(true);
            }
        }
        if (this.graphContainer != null) {
            ShadowPathEffect effect;
            if (o.getName().equals("$Title")) {
                thisComponent = (JTextField)o;
                this.graphContainer.setTitleText(((JTextComponent)thisComponent).getText());
            } else if (o.getName().equals("$SubTitle")) {
                thisComponent = (JTextField)o;
                this.graphContainer.setSubTitleText(((JTextComponent)thisComponent).getText());
            } else if (o.getName().equals("$Rotation")) {
                thisComponent = (JComboBox)o;
                this.graphContainer.setRotation(new Double(((JComboBox)thisComponent).getSelectedItem().toString()) * Math.PI / 180.0);
            } else if (o.getName().equals("$rotateDial")) {
                thisComponent = (GJDial)o;
                this.graphContainer.setRotation((double)((GJDial)thisComponent).getValue() * Math.PI / 180.0);
            } else if (o.getName().equals("$Zoom")) {
                thisComponent = (JComboBox)o;
                this.graphContainer.setZoom(new Double(((JComboBox)thisComponent).getSelectedItem().toString()) / 100.0);
            } else if (o.getName().equals("$zoomDial")) {
                thisComponent = (GJDial)o;
                this.graphContainer.setZoom((double)((GJDial)thisComponent).getValue() / 100.0);
            } else if (o.getName().equals("$AspectRatio")) {
                thisComponent = (JComboBox)o;
                String s = ((JComboBox)thisComponent).getSelectedItem().toString();
                if (s.matches("Auto")) {
                    this.graphContainer.setAspectRatio(0.0);
                } else {
                    this.graphContainer.setAspectRatio(new Double(((JComboBox)thisComponent).getSelectedItem().toString()));
                }
            } else if (o.getName().equals("$Font") || o.getName().equals("$FontSize") || o.getName().equals("$Bold") || o.getName().equals("$Italic")) {
                int Style2 = 0;
                if (this.fontControl.bold.isSelected()) {
                    ++Style2;
                }
                if (this.fontControl.italic.isSelected()) {
                    Style2 += 2;
                }
                Font font = new Font((String)this.fontControl.font.getSelectedItem(), Style2, new Integer(this.fontControl.size.getSelectedItem().toString()));
                this.graphContainer.setFont(font, true);
            } else if (o.getName().equals("$ContainerForeground")) {
                thisComponent = (GJColorComboBox)o;
                this.graphContainer.setForeground(((GJColorComboBox)thisComponent).getSelectedColor(), true);
            } else if (o.getName().equals("$ContainerBackgroundPainted")) {
                thisComponent = (JCheckBox)o;
                this.graphContainer.setBackgroundPainted(((AbstractButton)thisComponent).isSelected());
            } else if (o.getName().equals("$ContainerBackground")) {
                thisComponent = (GJColorComboBox)o;
                this.graphContainer.setBackground(((GJColorComboBox)thisComponent).getSelectedColor());
            } else if (o.getName().equals("$Shadow")) {
                thisComponent = (JCheckBox)o;
                if (((AbstractButton)thisComponent).isSelected()) {
                    this.editor.getContainerOptionsPanel().getFrameEffect().setSelected(false);
                    effect = new ShadowPathEffect();
                    this.graphContainer.setEffect((AreaEffect)effect);
                } else {
                    this.graphContainer.setEffect(null);
                }
            } else if (o.getName().equals("$Frame")) {
                thisComponent = (JCheckBox)o;
                if (((AbstractButton)thisComponent).isSelected()) {
                    this.editor.getContainerOptionsPanel().getShadowEffect().setSelected(false);
                    effect = new NeonBorderEffect();
                    effect.setEdgeColor(Color.DARK_GRAY);
                    this.graphContainer.setEffect((AreaEffect)effect);
                } else {
                    this.graphContainer.setEffect(null);
                }
            }
        }
    }

    private static class FontControl {
        public JComboBox font = null;
        public JComboBox size = null;
        public JToggleButton bold = null;
        public JToggleButton italic = null;

        private FontControl() {
        }
    }
}

