/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.math;

public class fp {
    private fp() {
    }

    public static double[] split(double val) {
        double factor = Math.scalb(1.0f, 27) + 1.0f;
        double c = val * factor;
        double x = c - (c - val);
        return new double[]{x, val - x};
    }

    public static double[] twoProduct(double a, double b) {
        double x = a * b;
        double[] as = fp.split(a);
        double[] bs = fp.split(b);
        return new double[]{x, as[1] * bs[1] - (x - as[0] * bs[0] - as[1] * bs[0] - as[0] * bs[1])};
    }

    public static double[] twoSum(double a, double b) {
        double x = a + b;
        double z = x - a;
        return new double[]{x, a - (x - z) + (b - z)};
    }

    public static double sum(double[] in) {
        double sum = 0.0;
        double y = 0.0;
        for (int k = 0; k < in.length; ++k) {
            double x = sum + in[k];
            double z = x - sum;
            y += sum - (x - z) + (in[k] - z);
            sum = x;
        }
        return sum + y;
    }

    public static double sum(double[] in, int idx0, int idx1) {
        double sum = 0.0;
        double y = 0.0;
        for (int k = idx0; k <= idx1; ++k) {
            double x = sum + in[k];
            double z = x - sum;
            y += sum - (x - z) + (in[k] - z);
            sum = x;
        }
        return sum + y;
    }

    public static double[] cusum(double[] in) {
        double[] s = new double[in.length];
        double sum = 0.0;
        double y = 0.0;
        for (int k = 0; k < in.length; ++k) {
            double x = sum + in[k];
            double z = x - sum;
            sum = x;
            s[k] = sum + (y += sum - (x - z) + (in[k] - z));
        }
        return s;
    }

    public static double[] cusumi(double[] in) {
        double sum = 0.0;
        double y = 0.0;
        for (int k = 0; k < in.length; ++k) {
            double x = sum + in[k];
            double z = x - sum;
            sum = x;
            in[k] = sum + (y += sum - (x - z) + (in[k] - z));
        }
        return in;
    }

    public static double dot(double[] a, double[] b) {
        fp.assertSameLength(a, b);
        double s = 0.0;
        double[] p = fp.twoProduct(a[0], b[0]);
        for (int k = 1; k < a.length; ++k) {
            double[] h = fp.twoProduct(a[k], b[k]);
            p = fp.twoSum(p[0], h[0]);
            s += p[1] + h[1];
        }
        return p[0] + s;
    }

    public static boolean tolEquals(double a, double b, double tol) {
        return a == b || a <= b + tol || a >= b - tol;
    }

    private static void assertSameLength(double[] X, double[] Y) {
        if (X.length != Y.length) {
            throw new ArrayIndexOutOfBoundsException("Vectors must be the same length: not " + X.length + " and " + Y.length);
        }
    }
}

