/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.marker;

import java.awt.FontMetrics;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Formatter;
import kcl.waterloo.graphics.GJGraphInterface;
import kcl.waterloo.graphics.data.GJXYSeries;
import kcl.waterloo.marker.GJPathSegmentInfo;
import kcl.waterloo.math.ArrayMath;
import kcl.waterloo.math.ArrayUtils;

public class ShapeUtils {
    private ShapeUtils() {
    }

    public static ArrayList<GJPathSegmentInfo> getSegments(Shape p) {
        ArrayList<GJPathSegmentInfo> segments = new ArrayList<GJPathSegmentInfo>();
        double[] d = new double[6];
        PathIterator it = p.getPathIterator(null);
        while (!it.isDone()) {
            int type = it.currentSegment(d);
            segments.add(new GJPathSegmentInfo(type, d));
            it.next();
        }
        return segments;
    }

    public static GJXYSeries getXY(Shape s) {
        ArrayList<Double> x = new ArrayList<Double>();
        ArrayList<Double> y = new ArrayList<Double>();
        ArrayList<GJPathSegmentInfo> segments = new ArrayList<GJPathSegmentInfo>();
        double[] d = new double[6];
        PathIterator it = s.getPathIterator(null);
        while (!it.isDone()) {
            int type = it.currentSegment(d);
            segments.add(new GJPathSegmentInfo(type, d));
            it.next();
        }
        for (GJPathSegmentInfo segment : segments) {
            switch (segment.getType()) {
                case 0: 
                case 1: {
                    x.add(segment.getData()[0]);
                    y.add(segment.getData()[1]);
                    break;
                }
                case 2: {
                    x.add(segment.getData()[0]);
                    x.add(segment.getData()[2]);
                    y.add(segment.getData()[1]);
                    y.add(segment.getData()[3]);
                    break;
                }
                case 3: {
                    x.add(segment.getData()[0]);
                    x.add(segment.getData()[2]);
                    x.add(segment.getData()[4]);
                    y.add(segment.getData()[1]);
                    y.add(segment.getData()[3]);
                    y.add(segment.getData()[5]);
                    break;
                }
            }
        }
        return new GJXYSeries(x, y);
    }

    public static double[] getX(Shape s) {
        ArrayList<Double> arr = new ArrayList<Double>();
        ArrayList<GJPathSegmentInfo> segments = new ArrayList<GJPathSegmentInfo>();
        double[] d = new double[6];
        PathIterator it = s.getPathIterator(null);
        while (!it.isDone()) {
            int type = it.currentSegment(d);
            segments.add(new GJPathSegmentInfo(type, d));
            it.next();
        }
        for (GJPathSegmentInfo segment : segments) {
            switch (segment.getType()) {
                case 0: 
                case 1: {
                    arr.add(segment.getData()[0]);
                    break;
                }
                case 2: {
                    arr.add(segment.getData()[0]);
                    arr.add(segment.getData()[2]);
                    break;
                }
                case 3: {
                    arr.add(segment.getData()[0]);
                    arr.add(segment.getData()[2]);
                    arr.add(segment.getData()[4]);
                    break;
                }
            }
        }
        return ArrayUtils.asDouble(arr);
    }

    public static GJXYSeries getFlattenedXY(Shape s) {
        return ShapeUtils.getFlattenedXY(s, Math.min(s.getBounds2D().getWidth() / 1000.0, s.getBounds2D().getHeight() / 1000.0));
    }

    public static GJXYSeries getFlattenedXY(Shape s, double flatness) {
        FlatteningPathIterator f = new FlatteningPathIterator(s.getPathIterator(null), flatness);
        ArrayList<Double> x = new ArrayList<Double>();
        ArrayList<Double> y = new ArrayList<Double>();
        ArrayList<GJPathSegmentInfo> segments = new ArrayList<GJPathSegmentInfo>();
        double[] d = new double[6];
        FlatteningPathIterator it = f;
        while (!it.isDone()) {
            int type = it.currentSegment(d);
            segments.add(new GJPathSegmentInfo(type, d));
            it.next();
        }
        for (GJPathSegmentInfo segment : segments) {
            switch (segment.getType()) {
                case 0: 
                case 1: {
                    x.add(segment.getData()[0]);
                    y.add(segment.getData()[1]);
                    break;
                }
                case 4: {
                    break;
                }
            }
        }
        return new GJXYSeries(x, y);
    }

    public static double[] getFlattenedX(Shape s) {
        return ShapeUtils.getFlattenedX(s, Math.min(s.getBounds2D().getWidth() / 1000.0, s.getBounds2D().getHeight() / 1000.0));
    }

    public static double[] getFlattenedX(Shape s, double flatness) {
        FlatteningPathIterator f = new FlatteningPathIterator(s.getPathIterator(null), flatness);
        ArrayList<Double> arr = new ArrayList<Double>();
        ArrayList<GJPathSegmentInfo> segments = new ArrayList<GJPathSegmentInfo>();
        double[] d = new double[6];
        FlatteningPathIterator it = f;
        while (!it.isDone()) {
            int type = it.currentSegment(d);
            segments.add(new GJPathSegmentInfo(type, d));
            it.next();
        }
        for (GJPathSegmentInfo segment : segments) {
            switch (segment.getType()) {
                case 0: 
                case 1: {
                    arr.add(segment.getData()[0]);
                    break;
                }
                case 4: {
                    break;
                }
            }
        }
        return ArrayUtils.asDouble(arr);
    }

    public static double[] getY(Shape s) {
        ArrayList<Double> arr = new ArrayList<Double>();
        ArrayList<GJPathSegmentInfo> segments = new ArrayList<GJPathSegmentInfo>();
        double[] d = new double[6];
        PathIterator it = s.getPathIterator(null);
        while (!it.isDone()) {
            int type = it.currentSegment(d);
            segments.add(new GJPathSegmentInfo(type, d));
            it.next();
        }
        for (GJPathSegmentInfo segment : segments) {
            switch (segment.getType()) {
                case 0: 
                case 1: {
                    arr.add(segment.getData()[1]);
                    break;
                }
                case 2: {
                    arr.add(segment.getData()[1]);
                    arr.add(segment.getData()[3]);
                    break;
                }
                case 3: {
                    arr.add(segment.getData()[1]);
                    arr.add(segment.getData()[3]);
                    arr.add(segment.getData()[5]);
                    break;
                }
            }
        }
        return ArrayUtils.asDouble(arr);
    }

    public static double[] getFlattenedY(Shape s) {
        return ShapeUtils.getFlattenedY(s, Math.min(s.getBounds2D().getWidth() / 1000.0, s.getBounds2D().getHeight() / 1000.0));
    }

    public static double[] getFlattenedY(Shape s, double flatness) {
        FlatteningPathIterator f = new FlatteningPathIterator(s.getPathIterator(null), flatness);
        ArrayList<Double> arr = new ArrayList<Double>();
        ArrayList<GJPathSegmentInfo> segments = new ArrayList<GJPathSegmentInfo>();
        double[] d = new double[6];
        FlatteningPathIterator it = f;
        while (!it.isDone()) {
            int type = it.currentSegment(d);
            segments.add(new GJPathSegmentInfo(type, d));
            it.next();
        }
        for (GJPathSegmentInfo segment : segments) {
            switch (segment.getType()) {
                case 0: 
                case 1: {
                    arr.add(segment.getData()[1]);
                    break;
                }
                case 4: {
                    break;
                }
            }
        }
        return ArrayUtils.asDouble(arr);
    }

    public static Path2D getFromZeroX(GJGraphInterface gr, Shape p) {
        return ShapeUtils.getFromX(gr, p, 0.0);
    }

    public static Path2D getFromX(GJGraphInterface gr, Shape p, double y) {
        Path2D.Double path = new Path2D.Double();
        double[] d = new double[6];
        PathIterator it = p.getPathIterator(null);
        it.currentSegment(d);
        ((Path2D)path).moveTo(d[0], gr.yPositionToPixel(y));
        path.append(p, true);
        while (!it.isDone()) {
            it.currentSegment(d);
            it.next();
        }
        ((Path2D)path).lineTo(d[0], gr.yPositionToPixel(y));
        return path;
    }

    public static Path2D getFromZeroY(GJGraphInterface gr, Shape p, double x) {
        return ShapeUtils.getFromY(gr, p, x);
    }

    public static Path2D getFromY(GJGraphInterface gr, Shape p, double x) {
        Path2D.Double path = new Path2D.Double();
        double[] d = new double[6];
        PathIterator it = p.getPathIterator(null);
        it.currentSegment(d);
        ((Path2D)path).moveTo(gr.xPositionToPixel(x), d[1]);
        path.append(p, true);
        while (!it.isDone()) {
            it.currentSegment(d);
            it.next();
        }
        ((Path2D)path).lineTo(gr.xPositionToPixel(x), d[1]);
        return path;
    }

    public static double getArea(Shape s) {
        Area area = new Area(s);
        if (area.isEmpty()) {
            return 0.0;
        }
        double[] dX = ArrayMath.diff(ShapeUtils.getFlattenedX(area));
        double[] y1 = ShapeUtils.getFlattenedY(area);
        double[] y2 = new double[y1.length - 1];
        double[] y3 = new double[y1.length - 1];
        System.arraycopy(y1, 0, y2, 0, y1.length - 1);
        System.arraycopy(y1, 1, y3, 0, y1.length - 1);
        ArrayMath.addi(y2, y3);
        ArrayMath.divi(y2, 2.0);
        ArrayMath.muli(y2, dX);
        return Math.abs(ArrayMath.sum(y2));
    }

    public static Point2D.Double getCentroid(Shape s) {
        double[] x = ShapeUtils.getFlattenedX(s);
        double[] y = ShapeUtils.getFlattenedY(s);
        int n = ShapeUtils.isClosed(s) ? x.length - 2 : x.length - 1;
        double sx = ArrayMath.sum(x, 0, n);
        double sy = ArrayMath.sum(y, 0, n);
        return new Point2D.Double(sx / (double)n, sy / (double)n);
    }

    public static boolean contains(Shape s1, Shape s2) {
        Area area1 = new Area(s1);
        Area area2 = new Area(s2);
        area2.subtract(area1);
        return area2.isEmpty();
    }

    public static boolean intersects(Shape s1, Shape s2) {
        Area area1 = new Area(s1);
        Area area2 = new Area(s2);
        area2.intersect(area1);
        return !area2.isEmpty();
    }

    public static double sumdX(Shape s) {
        double[] x = ShapeUtils.getX(s);
        return ArrayMath.sum(ArrayMath.diff(x));
    }

    public static boolean isClosed(Shape s) {
        return ShapeUtils.sumdX(s) == 0.0;
    }

    public static String toString(Shape s) {
        StringBuilder str = new StringBuilder();
        Formatter f = new Formatter(str);
        ArrayList<GJPathSegmentInfo> segments = new ArrayList<GJPathSegmentInfo>();
        double[] d = new double[6];
        PathIterator it = s.getPathIterator(null);
        while (!it.isDone()) {
            int type = it.currentSegment(d);
            segments.add(new GJPathSegmentInfo(type, d));
            it.next();
        }
        f.format("%s [%x]\n", s.getClass().toString(), s.hashCode());
        for (GJPathSegmentInfo segment : segments) {
            switch (segment.getType()) {
                case 0: {
                    f.format("moveTo:\t%10.4f\t%10.4f\n", segment.getData()[0], segment.getData()[1]);
                    break;
                }
                case 1: {
                    f.format("lineTo:\t%10.4f\t%10.4f\n", segment.getData()[0], segment.getData()[1]);
                    break;
                }
                case 2: {
                    f.format("quadTo:\t%10.4f\t%10.4f\t%10.4f\t%10.4f\n", segment.getData()[0], segment.getData()[1], segment.getData()[2], segment.getData()[3]);
                    break;
                }
                case 3: {
                    f.format("curveTo:\t%10.4f\t%10.4f\t%10.4f\t%10.4f\t%10.4f\t%10.4f\n", segment.getData()[0], segment.getData()[1], segment.getData()[2], segment.getData()[3], segment.getData()[4], segment.getData()[5]);
                    break;
                }
                case 4: {
                    f.format("closePath\n", new Object[0]);
                }
            }
        }
        return f.toString();
    }

    public static double[] getXYOnArc(Ellipse2D arc0, Ellipse2D arc1, double theta) {
        double x1 = arc0.getCenterX();
        double y1 = arc0.getCenterY();
        double x2 = x1 + Math.cos(theta) * arc1.getHeight();
        double y2 = y1 + Math.sin(theta) * arc1.getWidth();
        double horzAngle = (Math.atan2(y2 - y1, x2 - x1) + Math.PI * 2) % (Math.PI * 2);
        double xc = arc1.getCenterX();
        double yc = arc1.getCenterY();
        double r1 = arc1.getWidth() / 2.0 - arc1.getWidth() / 30.0;
        double r2 = arc1.getHeight() / 2.0 - arc1.getHeight() / 30.0;
        double cot = Math.cos(0.0);
        double sit = Math.sin(0.0);
        double xl = xc + r1 * Math.cos(horzAngle) * cot - r2 * Math.sin(horzAngle) * sit;
        double yl = yc + r1 * Math.cos(horzAngle) * sit + r2 * Math.sin(horzAngle) * cot;
        return new double[]{xl, yl};
    }

    public static double[] getStringLocationToArc(double[] xy, double theta, String s, FontMetrics metrics) {
        if (theta == 0.0) {
            xy[1] = xy[1] + (double)metrics.getAscent() / 2.0;
        } else if (Math.abs(theta) == 1.5707963267948966) {
            xy[0] = xy[0] - (double)metrics.stringWidth(s) / 2.0;
        } else if (Math.abs(theta) == Math.PI) {
            xy[1] = xy[1] + (double)metrics.getAscent() / 2.0;
        } else if (Math.abs(theta) == 4.71238898038469) {
            xy[0] = xy[0] - (double)metrics.stringWidth(s) / 2.0;
            xy[1] = xy[1] + (double)metrics.getAscent();
        } else if (!(Math.abs(theta) < 1.5707963267948966)) {
            if (Math.abs(theta) < Math.PI) {
                xy[0] = xy[0] - (double)metrics.stringWidth(s);
            } else if (Math.abs(theta) < 4.71238898038469) {
                xy[0] = xy[0] - (double)metrics.stringWidth(s);
                xy[1] = xy[1] + (double)metrics.getAscent() / 2.0;
            } else if (Math.abs(theta) > 4.71238898038469) {
                xy[1] = xy[1] + (double)metrics.getAscent() / 2.0;
            }
        }
        return xy;
    }
}

