/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics.transforms;

import java.text.NumberFormat;
import java.util.ArrayList;
import kcl.waterloo.graphics.GJUtilities;
import kcl.waterloo.graphics.transforms.GJAbstractDataTransform;

public final class LogTransform
extends GJAbstractDataTransform {
    private static final LogTransform Instance = new LogTransform();
    private static final long serialVersionUID = 1L;
    private static NumberFormat nf = NumberFormat.getInstance();
    public static final ArrayList<Double> minorGrid = LogTransform.minorGridMaker();
    public static final ArrayList<Double> majorGrid = LogTransform.majorGridMaker();

    private LogTransform() {
    }

    public static LogTransform getInstance() {
        return Instance;
    }

    @Override
    public String getName() {
        return "ln";
    }

    @Override
    public final double getData(double val) {
        val = Math.log(val);
        return val;
    }

    @Override
    public final double[] getData(double[] arr) {
        for (int k = 0; k < arr.length; ++k) {
            arr[k] = Math.log(arr[k]);
        }
        return arr;
    }

    @Override
    public final double getInverse(double val) {
        return Math.pow(Math.E, val);
    }

    @Override
    public final String getTickLabel(double val) {
        return "e" + GJUtilities.getSuperscripts(nf.format(val));
    }

    @Override
    public ArrayList<Double> getAxisTickPositions(double start, double stop, double inc) {
        return majorGrid;
    }

    private static ArrayList<Double> majorGridMaker() {
        ArrayList<Double> pos = new ArrayList<Double>();
        for (double s = -35.0; s <= 35.0; s += 1.0) {
            pos.add(s);
        }
        return pos;
    }

    @Override
    public ArrayList<Double> getMinorGridPositions(double start, double stop, double inc, int n) {
        return minorGrid;
    }

    private static ArrayList<Double> minorGridMaker() {
        return new ArrayList<Double>();
    }
}

