/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics.transforms;

import java.util.ArrayList;
import kcl.waterloo.graphics.GJUtilities;
import kcl.waterloo.graphics.transforms.GJAbstractDataTransform;

public final class Log10Transform
extends GJAbstractDataTransform {
    private static final Log10Transform Instance = new Log10Transform();
    private static final long serialVersionUID = 1L;
    private static final ArrayList<Double> minorGrid = Log10Transform.minorGridMaker();
    private static ArrayList<Double> majorGrid = Log10Transform.majorGridMaker();

    private Log10Transform() {
    }

    public static Log10Transform getInstance() {
        return Instance;
    }

    @Override
    public String getName() {
        return "log10";
    }

    @Override
    public final double getData(double val) {
        return Math.log10(val);
    }

    @Override
    public final double[] getData(double[] arr) {
        for (int k = 0; k < arr.length; ++k) {
            arr[k] = Math.log10(arr[k]);
        }
        return arr;
    }

    @Override
    public final double getInverse(double val) {
        return Math.pow(10.0, val);
    }

    @Override
    public final String getTickLabel(double val) {
        if (val == 0.0) {
            val = 0.0;
        }
        return "10" + GJUtilities.getSuperscripts(this.nf.format(val));
    }

    @Override
    public ArrayList<Double> getAxisTickPositions(double start, double stop, double inc) {
        int k;
        if (stop - start < 10.0) {
            majorGrid = inc < 1.0 ? Log10Transform.majorGridMaker(inc * 2.0) : Log10Transform.majorGridMaker();
        }
        start = Math.pow(10.0, start);
        stop = Math.pow(10.0, stop);
        if (start <= 0.0) {
            start = 1.0E-14;
        }
        int idx0 = 0;
        int idx1 = majorGrid.size() - 1;
        for (k = 1; k < majorGrid.size() - 1; ++k) {
            if (!(Math.pow(10.0, majorGrid.get(k)) > start)) continue;
            idx0 = k - 1;
            break;
        }
        for (k = 1; k < majorGrid.size() - 3; ++k) {
            if (!(Math.pow(10.0, majorGrid.get(k)) > stop)) continue;
            idx1 = k + 2;
            break;
        }
        return new ArrayList<Double>(majorGrid.subList(idx0, idx1));
    }

    private static ArrayList<Double> majorGridMaker() {
        return Log10Transform.majorGridMaker(1.0);
    }

    private static ArrayList<Double> majorGridMaker(double inc) {
        ArrayList<Double> pos = new ArrayList<Double>();
        for (double s = -15.0; s <= 15.0; s += inc) {
            pos.add(s);
        }
        return pos;
    }

    @Override
    public ArrayList<Double> getMinorGridPositions(double start, double stop, double inc, int n) {
        return minorGrid;
    }

    private static ArrayList<Double> minorGridMaker() {
        ArrayList<Double> pos = new ArrayList<Double>();
        for (double s = 1.0E-16; s < 1.0E16; s *= 10.0) {
            for (double s2 = 2.0; s2 <= 9.0; s2 += 1.0) {
                pos.add(Math.log10(s * s2));
            }
        }
        return pos;
    }
}

