/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics.plots2D;

import java.awt.AlphaComposite;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import kcl.waterloo.defaults.Colors;
import kcl.waterloo.graphics.plots2D.GJPlotInterface;
import kcl.waterloo.marker.GJPathSegmentInfo;
import kcl.waterloo.marker.ShapeUtils;
import kcl.waterloo.plotmodel2D.GJFillableInterface;

public class GJFill
implements GJFillableInterface<Shape, Paint> {
    private GJPlotInterface parentPlot = null;
    private ORIENTATION orientation = ORIENTATION.VERTICAL;
    private double reference = Double.NaN;
    private Area arbitraryArea = null;
    private MODE mode = MODE.INTERSECT;
    private Paint areaPaint = Colors.getColor("AREAFILL");
    private AlphaComposite fillComposite = null;

    public GJFill() {
    }

    public GJFill(GJPlotInterface p) {
        this.parentPlot = p;
    }

    public GJFill(GJPlotInterface p, double ref) {
        this.parentPlot = p;
        this.reference = ref;
    }

    public GJFill(GJPlotInterface p, double ref, ORIENTATION or) {
        this.parentPlot = p;
        this.reference = ref;
        this.orientation = or;
    }

    @Override
    public Shape getFillable() {
        Area area0 = new Area();
        double refValue = this.reference;
        switch (this.orientation) {
            case VERTICAL: {
                if (refValue == Double.NEGATIVE_INFINITY) {
                    refValue = this.parentPlot.getParentGraph().getYMax();
                } else if (refValue == Double.POSITIVE_INFINITY) {
                    refValue = this.parentPlot.getParentGraph().getYMin();
                }
                for (GJPlotInterface plot : this.parentPlot.getNode()) {
                    for (Shape s : plot.getScreenDataArray()) {
                        area0.add(new Area(ShapeUtils.getFromX(this.parentPlot.getParentGraph(), s, refValue)));
                    }
                }
                break;
            }
            case HORIZONTAL: {
                if (refValue == Double.NEGATIVE_INFINITY) {
                    refValue = this.parentPlot.getParentGraph().getXMax();
                } else if (refValue == Double.POSITIVE_INFINITY) {
                    refValue = this.parentPlot.getParentGraph().getXMin();
                }
                for (GJPlotInterface plot : this.parentPlot.getNode()) {
                    for (Shape s : plot.getScreenDataArray()) {
                        area0.add(new Area(ShapeUtils.getFromY(this.parentPlot.getParentGraph(), s, refValue)));
                    }
                }
                break;
            }
        }
        return area0;
    }

    @Override
    public Paint getAreaPaint() {
        return this.areaPaint;
    }

    @Override
    public void setAreaPaint(Paint paint) {
        this.areaPaint = paint;
    }

    public GJPlotInterface getParentPlot() {
        return this.parentPlot;
    }

    public void setParentPlot(GJPlotInterface parentPlot) {
        this.parentPlot = parentPlot;
    }

    public double getReference() {
        return this.reference;
    }

    public void setReference(double reference) {
        this.reference = reference;
    }

    public ORIENTATION getOrientation() {
        return this.orientation;
    }

    public void setOrientation(ORIENTATION orientation) {
        this.orientation = orientation;
    }

    public Area getArbitraryArea() {
        return this.arbitraryArea;
    }

    public void setArbitraryArea(Area arbitraryArea) {
        this.arbitraryArea = arbitraryArea;
    }

    public final ArrayList<GJPathSegmentInfo> getSegments() {
        if (this.arbitraryArea != null) {
            ArrayList<GJPathSegmentInfo> segments = new ArrayList<GJPathSegmentInfo>();
            double[] d = new double[6];
            PathIterator it = this.arbitraryArea.getPathIterator(null);
            while (!it.isDone()) {
                int type = it.currentSegment(d);
                segments.add(new GJPathSegmentInfo(type, d));
                it.next();
            }
            return segments;
        }
        return null;
    }

    public final void setSegments(ArrayList<GJPathSegmentInfo> arr) {
        Path2D.Double path = new Path2D.Double();
        for (GJPathSegmentInfo segment : arr) {
            switch (segment.getType()) {
                case 0: {
                    ((Path2D)path).moveTo(segment.getData()[0], segment.getData()[1]);
                    break;
                }
                case 1: {
                    ((Path2D)path).lineTo(segment.getData()[0], segment.getData()[1]);
                    break;
                }
                case 2: {
                    ((Path2D)path).quadTo(segment.getData()[0], segment.getData()[1], segment.getData()[2], segment.getData()[3]);
                    break;
                }
                case 3: {
                    ((Path2D)path).curveTo(segment.getData()[0], segment.getData()[1], segment.getData()[2], segment.getData()[3], segment.getData()[4], segment.getData()[5]);
                    break;
                }
                case 4: {
                    path.closePath();
                }
            }
        }
        this.arbitraryArea = new Area(path);
    }

    public MODE getMode() {
        return this.mode;
    }

    public void setMode(MODE mode) {
        this.mode = mode;
    }

    public Area getPixelArea() {
        if (this.arbitraryArea != null) {
            double scx = this.parentPlot.getParentGraph().xPositionToPixel(1.0) - this.parentPlot.getParentGraph().xPositionToPixel(0.0);
            double scy = this.parentPlot.getParentGraph().yPositionToPixel(0.0) - this.parentPlot.getParentGraph().yPositionToPixel(1.0);
            AffineTransform af = AffineTransform.getScaleInstance(scx, -scy);
            Area area = (Area)this.arbitraryArea.clone();
            area.transform(af);
            area.transform(AffineTransform.getTranslateInstance(this.parentPlot.getParentGraph().xPositionToPixel(0.0), this.parentPlot.getParentGraph().yPositionToPixel(0.0)));
            if (!this.getOrientation().equals((Object)ORIENTATION.ARBITRARY)) {
                if (this.getMode().equals((Object)MODE.SET)) {
                    return area;
                }
            } else {
                double ymin = this.parentPlot.getParentGraph().getYMin();
                ArrayList<GJPlotInterface> p2 = this.parentPlot.getNode();
                Area area0 = new Area();
                for (GJPlotInterface plot : p2) {
                    for (Shape s : plot.getScreenDataArray()) {
                        area0.add(new Area(ShapeUtils.getFromX(this.parentPlot.getParentGraph(), s, ymin)));
                    }
                }
                switch (this.getMode()) {
                    case INTERSECT: {
                        area0.intersect(area);
                        break;
                    }
                    case ADD: {
                        area0.add(area);
                        break;
                    }
                    case SUBTRACT: {
                        area0.subtract(area);
                        break;
                    }
                    case XOR: {
                        area0.exclusiveOr(area);
                    }
                }
                return area0;
            }
        }
        return null;
    }

    @Override
    public AlphaComposite getFillComposite() {
        return this.fillComposite;
    }

    @Override
    public void setFillComposite(AlphaComposite composite) {
        this.fillComposite = composite;
    }

    @Override
    public float getFillAlpha() {
        if (this.fillComposite != null) {
            return this.fillComposite.getAlpha();
        }
        return 1.0f;
    }

    @Override
    public void setFillAlpha(float alpha) {
        this.fillComposite = this.fillComposite != null ? this.fillComposite.derive(alpha) : AlphaComposite.getInstance(3, alpha);
    }

    public static enum MODE {
        SET,
        ADD,
        SUBTRACT,
        INTERSECT,
        XOR;

    }

    public static enum ORIENTATION {
        HORIZONTAL,
        VERTICAL,
        ARBITRARY;

    }
}

