/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics.plots2D;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.util.Formatter;
import kcl.waterloo.graphics.plots2D.GJAbstractPlot;
import kcl.waterloo.graphics.plots2D.GJPlotInterface;
import kcl.waterloo.graphics.plots2D.GJTransformUpdateInterface;
import kcl.waterloo.graphics.plots2D.contour.Contour;
import kcl.waterloo.graphics.plots2D.contour.ContourExtra;

public class GJContour
extends GJAbstractPlot
implements GJTransformUpdateInterface {
    private boolean labelled = false;
    private Font labelFont = null;
    private boolean fillClipping = true;
    private boolean filled = true;

    public GJContour() {
    }

    public GJContour(GJAbstractPlot p) {
        super(p);
    }

    public static GJPlotInterface createInstance() {
        GJPlotInterface p = GJAbstractPlot.createInstance(new GJContour());
        p.setXData(new double[]{0.0});
        p.setYData(new double[]{0.0});
        return p;
    }

    @Override
    public void paintPlot(Graphics2D g) {
        Path2D p;
        super.paintPlot(g);
        this.getScreenDataArray().clear();
        ContourExtra extra = (ContourExtra)this.getDataModel().getExtraObject();
        if (extra == null || extra.size() == 0 || extra.getCompounds().size() == 0) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        double scx = this.getParentGraph().xPositionToPixel(1.0) - this.getParentGraph().xPositionToPixel(0.0);
        double scy = this.getParentGraph().yPositionToPixel(0.0) - this.getParentGraph().yPositionToPixel(1.0);
        if (Double.isInfinite(scx) || Double.isNaN(scx)) {
            scx = 1.0;
        }
        if (Double.isInfinite(scy) || Double.isNaN(scy)) {
            scy = 1.0;
        }
        AffineTransform af1 = AffineTransform.getScaleInstance(scx, -scy);
        AffineTransform af2 = new AffineTransform();
        double xt = this.getParentGraph().xPositionToPixel(0.0);
        double yt = this.getParentGraph().yPositionToPixel(0.0);
        af2.setToTranslation(xt, yt);
        if (this.isFilled()) {
            this.doFill(g2, extra, af1, af2);
        }
        for (Double thisLevel : extra.keySet()) {
            p = extra.getCompound(thisLevel);
            if (extra.getZeroStroke() != null && Math.abs(thisLevel) <= (double)Math.ulp(1.0f)) {
                g2.setStroke(extra.getZeroStroke());
            } else {
                g2.setStroke(this.getEdgeStroke().get(extra.getColorIndex(thisLevel)));
            }
            if (extra.getPositiveLineColor() != null && thisLevel >= 0.0) {
                g2.setPaint(extra.getPositiveLineColor());
            } else if (extra.getNegativeLineColor() != null && thisLevel < 0.0) {
                g2.setPaint(extra.getNegativeLineColor());
            } else {
                g2.setPaint(this.getEdgeColor().get(extra.getColorIndex(thisLevel)));
            }
            p.transform(af1);
            p.transform(af2);
            g2.draw(p);
            this.getScreenDataArray().add(p);
        }
        if (this.isLabelled()) {
            g2.setFont(this.labelFont);
            for (ContourExtra.SortedContour c : extra.sort()) {
                p = new Path2D.Double();
                Contour contour = c.getContour();
                String str = String.format("%4.2f", contour.getLevel());
                GlyphVector glyph = g2.getFont().createGlyphVector(g2.getFontRenderContext(), str);
                float glyphX = (float)(scx * contour.getLabel().getX() - (double)g2.getFontMetrics().stringWidth(str) / 2.0);
                float glyphY = (float)(-scy * contour.getLabel().getY());
                if (Double.isNaN(glyphX) || Double.isNaN(glyphY)) continue;
                Shape s = glyph.getOutline(glyphX, glyphY);
                double theta = contour.getTheta();
                if (Math.abs(theta) > 1.5707963267948966) {
                    theta += Math.PI;
                }
                p.append(s, false);
                p.transform(AffineTransform.getRotateInstance(theta, s.getBounds2D().getCenterX(), s.getBounds2D().getCenterY()));
                p.transform(af2);
                if (contour.getLabel().getBackground() != null) {
                    g2.setPaint(contour.getLabel().getBackground());
                    Path2D.Double p2 = new Path2D.Double();
                    Rectangle2D r = s.getBounds2D();
                    p2.append(new Rectangle2D.Double(r.getX() - 1.0, r.getY() - 1.0, r.getWidth() + 2.0, r.getHeight() + 2.0), false);
                    ((Path2D)p2).transform(AffineTransform.getRotateInstance(theta, s.getBounds2D().getCenterX(), s.getBounds2D().getCenterY()));
                    ((Path2D)p2).transform(af2);
                    g2.fill(p2);
                }
                g2.setPaint(contour.getLabel().getForeground());
                g2.fill(p);
            }
        }
    }

    private void doFill(Graphics2D g2, ContourExtra extra, AffineTransform af1, AffineTransform af2) {
        Area commonPath;
        Shape clip = g2.getClip();
        if (this.fillClipping && clip != null && !(commonPath = extra.getCommonPath()).isEmpty()) {
            commonPath.transform(af1);
            commonPath.transform(af2);
            commonPath.intersect(new Area(clip));
            g2.setClip(commonPath);
        }
        for (ContourExtra.SortedContour sortedContour : extra.sort()) {
            Area p = sortedContour.getFillArea();
            p.transform(af1);
            p.transform(af2);
            g2.setPaint(this.getFill().get(sortedContour.getColorIndex()));
            g2.fill(p);
        }
        g2.setClip(clip);
    }

    @Override
    public boolean isMultiplexible() {
        return false;
    }

    @Override
    public String stringSupplement() {
        Formatter f = new Formatter();
        ContourExtra extra = (ContourExtra)this.getDataModel().getExtraObject();
        f.format("%n%15s%10s%20s%20s%18s%18s%20s%n", "Level", "Count", "Data Points", "Closed", "Edge Color", "Fill Color", "Color Index");
        int i = 0;
        for (Double thisLevel : extra.getLevelData().keySet()) {
            f.format("%4d:%10.3f", i, (double)thisLevel);
            f.format("%10s", extra.getLevelData().get(thisLevel).size());
            String str = "[";
            for (int k = 0; k < extra.getLevelData().get(thisLevel).size(); ++k) {
                str = str.concat(String.format("%d", extra.getLevelData().get(thisLevel).get(k).size()));
                if (k == 4 && extra.getLevelData().get(thisLevel).size() >= 5) {
                    str = str.concat("...");
                    break;
                }
                if (k >= extra.getLevelData().get(thisLevel).size() - 1) continue;
                str = str.concat("+");
            }
            str = str.concat("]");
            f.format("\t%-18s", str);
            str = "[";
            int n = 0;
            for (Contour c : extra.getLevel(thisLevel)) {
                str = str.concat(String.format("%s", c.isClosed() ? "T" : "F"));
                if (n == 4 && extra.getLevel(thisLevel).size() >= 5) {
                    str = str.concat("...");
                    break;
                }
                if (n < extra.getLevel(thisLevel).size() - 1) {
                    str = str.concat("+");
                }
                ++n;
            }
            str = str.concat("]");
            f.format("\t%-10s", str);
            f.format("%18s", this.getEdgeColor().get(i).toString().replaceAll("java.awt.Color", ""));
            f.format(" _|-> %12s", this.getFill().get(i).toString().replaceAll("java.awt.Color", ""));
            f.format("\t%-10d", extra.getColorIndex(thisLevel));
            f.format("%n", new Object[0]);
            ++i;
        }
        return f.toString();
    }

    public boolean isLabelled() {
        return this.labelled;
    }

    public void setLabelled(boolean labelled) {
        this.labelled = labelled;
    }

    public boolean isFillClipping() {
        return this.fillClipping;
    }

    public void setFillClipping(boolean fillClipping) {
        this.fillClipping = fillClipping;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("extraObject") || e.getPropertyName().equals("parentGraph") || e.getPropertyName().equals("dataBuffer")) {
            this.transformUpdate();
        }
    }

    @Override
    public final boolean transformUpdate() {
        if (this.getParentGraph() != null) {
            ((ContourExtra)this.getDataModel().getExtraObject()).generateContours(this);
            ((Component)((Object)this.getParentGraph())).repaint();
            if (this.labelFont == null) {
                this.labelFont = ((Component)((Object)this.getParentGraph())).getFont().deriveFont(10.0f);
            }
        }
        return true;
    }

    public boolean isFilled() {
        return this.filled;
    }

    public void setFilled(boolean filled) {
        this.filled = filled;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font labelFont) {
        this.labelFont = labelFont;
    }
}

