/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics.plots2D;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import kcl.waterloo.graphics.plots2D.BarExtra;
import kcl.waterloo.graphics.plots2D.GJAbstractPlot;
import kcl.waterloo.graphics.plots2D.GJPlotInterface;
import kcl.waterloo.math.ArrayMath;

public abstract class GJBox
extends GJAbstractPlot {
    public GJBox() {
    }

    public GJBox(GJAbstractPlot p) {
        super(p);
    }

    public final ArrayList<Shape> createBoxes(double[] x, double[] y) {
        ArrayList<Shape> array = new ArrayList<Shape>();
        double[] right = new double[x.length];
        double[] upper = new double[x.length];
        double[] left = new double[x.length];
        double[] lower = new double[x.length];
        BarExtra extra = (BarExtra)this.getDataModel().getExtraObject();
        if (extra == null) {
            return null;
        }
        double baseValue = extra.getBaseValue();
        switch (extra.getOrientation()) {
            case HORIZONTAL: {
                left = ArrayMath.min(y, baseValue);
                right = ArrayMath.max(y, baseValue);
                break;
            }
            default: {
                lower = ArrayMath.min(y, baseValue);
                upper = ArrayMath.max(y, baseValue);
            }
        }
        double[] dXl = new double[x.length];
        double[] dXr = new double[x.length];
        switch (extra.getMode()) {
            case HIST: {
                int k;
                dXl[0] = 0.5;
                dXr[0] = (x[1] - x[0]) / 2.0;
                for (k = 1; k < x.length - 1; ++k) {
                    dXl[k] = (x[k] - x[k - 1]) / 2.0;
                    dXr[k] = (x[k + 1] - x[k]) / 2.0;
                }
                dXl[x.length - 1] = dXr[x.length - 2];
                dXr[x.length - 1] = 0.5;
                break;
            }
            case HISTC: {
                int k;
                dXl[0] = 0.0;
                dXr[0] = x[1] - x[0];
                for (k = 1; k < x.length - 1; ++k) {
                    dXl[k] = 0.0;
                    dXr[k] = x[k + 1] - x[k];
                }
                dXl[x.length - 1] = 0.0;
                dXr[x.length - 1] = 1.0;
                break;
            }
            default: {
                ArrayMath.filli(dXl, extra.getBarWidth() / 2.0);
                ArrayMath.filli(dXr, extra.getBarWidth() / 2.0);
            }
        }
        int N = this.getMultiplexLength();
        if (N > 1 && ((BarExtra)this.getDataModel().getExtraObject()).getMode() == BarExtra.MODE.STACKED) {
            double[] posLimit = new double[x.length / N + 1];
            double[] negLimit = new double[x.length / N + 1];
            ArrayMath.filli(posLimit, 0.0);
            ArrayMath.filli(negLimit, 0.0);
            for (int idx = 0; idx < x.length; ++idx) {
                int ref = (int)Math.floor((double)idx / (double)N);
                switch (extra.getOrientation()) {
                    case HORIZONTAL: {
                        if (y[idx] >= 0.0) {
                            int n = idx;
                            left[n] = left[n] + posLimit[ref];
                            int n2 = idx;
                            right[n2] = right[n2] + posLimit[ref];
                            break;
                        }
                        int n = idx;
                        left[n] = left[n] + negLimit[ref];
                        int n3 = idx;
                        right[n3] = right[n3] + negLimit[ref];
                        break;
                    }
                    case VERTICAL: {
                        if (y[idx] >= 0.0) {
                            int n = idx;
                            lower[n] = lower[n] + posLimit[ref];
                            int n4 = idx;
                            upper[n4] = upper[n4] + posLimit[ref];
                            break;
                        }
                        int n = idx;
                        lower[n] = lower[n] + negLimit[ref];
                        int n5 = idx;
                        upper[n5] = upper[n5] + negLimit[ref];
                    }
                }
                if (y[idx] >= 0.0) {
                    int n = ref;
                    posLimit[n] = posLimit[n] + y[idx];
                    continue;
                }
                int n = ref;
                negLimit[n] = negLimit[n] + y[idx];
            }
        }
        switch (extra.getOrientation()) {
            case HORIZONTAL: {
                left = this.getParentGraph().xPositionToPixeli(this.getParentGraph().getXTransform().getData(left));
                right = this.getParentGraph().xPositionToPixeli(this.getParentGraph().getXTransform().getData(right));
                if (N > 1 && ((BarExtra)this.getDataModel().getExtraObject()).getMode() == BarExtra.MODE.STACKED) {
                    for (int k = 0; k < x.length; ++k) {
                        int ref = (int)Math.floor((double)k / (double)N) * N;
                        lower[k] = this.getParentGraph().yPositionToPixel(this.getParentGraph().getYTransform().getData(x[ref] - dXl[k]));
                        upper[k] = this.getParentGraph().yPositionToPixel(this.getParentGraph().getYTransform().getData(x[ref] + dXr[k]));
                    }
                    break;
                }
                lower = this.getParentGraph().yPositionToPixeli(this.getParentGraph().getYTransform().getData(ArrayMath.sub(x, dXl)));
                upper = this.getParentGraph().yPositionToPixeli(this.getParentGraph().getYTransform().getData(ArrayMath.add(x, dXr)));
                break;
            }
            default: {
                lower = this.getParentGraph().yPositionToPixeli(this.getParentGraph().getYTransform().getData(lower));
                upper = this.getParentGraph().yPositionToPixeli(this.getParentGraph().getYTransform().getData(upper));
                if (N > 1 && ((BarExtra)this.getDataModel().getExtraObject()).getMode() == BarExtra.MODE.STACKED) {
                    for (int k = 0; k < x.length; ++k) {
                        int ref = (int)Math.floor((double)k / (double)N) * N;
                        left[k] = this.getParentGraph().xPositionToPixel(this.getParentGraph().getXTransform().getData(x[ref] - dXl[k]));
                        right[k] = this.getParentGraph().xPositionToPixel(this.getParentGraph().getXTransform().getData(x[ref] + dXr[k]));
                    }
                    break;
                }
                left = this.getParentGraph().xPositionToPixeli(this.getParentGraph().getXTransform().getData(ArrayMath.sub(x, dXl)));
                right = this.getParentGraph().xPositionToPixeli(this.getParentGraph().getXTransform().getData(ArrayMath.add(x, dXr)));
            }
        }
        for (int i = 0; i < x.length; ++i) {
            if (Double.isNaN(left[i]) || Double.isNaN(right[i]) || Double.isNaN(upper[i]) || Double.isNaN(lower[i])) {
                array.add(null);
                continue;
            }
            array.add(new Rectangle2D.Double(left[i], upper[i], right[i] - left[i], lower[i] - upper[i]));
        }
        return array;
    }

    @Override
    public final Rectangle2D getDataRange() {
        if (this.getXDataValues() != null && this.getYDataValues() != null) {
            double[] y;
            double[] x;
            if (((BarExtra)this.getDataModel().getExtraObject()).getOrientation() == BarExtra.ORIENTATION.VERTICAL) {
                x = ArrayMath.minmax(this.getXDataValues());
                y = ArrayMath.minmax(this.getYDataValues());
            } else {
                y = ArrayMath.minmax(this.getXDataValues());
                x = ArrayMath.minmax(this.getYDataValues());
            }
            Rectangle2D r = new Rectangle2D.Double(x[0], y[0], x[1] - x[0], y[1] - y[0]);
            for (GJPlotInterface p : this.getPlotList()) {
                Rectangle2D r2 = (Rectangle2D)p.getDataRange();
                r = ((Rectangle2D)r).createUnion(r2);
            }
            return r;
        }
        return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    }
}

