/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics.plots2D;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Shape;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Map;
import kcl.waterloo.effects.GJEffectorInterface;
import kcl.waterloo.graphics.GJGraphInterface;
import kcl.waterloo.graphics.data.GJDataVectorInterface;
import kcl.waterloo.graphics.plots2D.GJPlotInterface;
import kcl.waterloo.graphics.transforms.GJDataTransformInterface;
import kcl.waterloo.graphics.transforms.NOPTransform;
import kcl.waterloo.marker.GJMarker;
import kcl.waterloo.math.ArrayMath;
import kcl.waterloo.observable.GJAbstractObservable;
import kcl.waterloo.plotmodel2D.GJCyclicArrayList;
import kcl.waterloo.plotmodel2D.GJDataModel;
import kcl.waterloo.plotmodel2D.GJScreenDataInterface;
import kcl.waterloo.plotmodel2D.GJVisualModel;

public abstract class GJAbstractPlotModelImpl
extends GJAbstractObservable
implements GJPlotInterface,
GJEffectorInterface,
GJScreenDataInterface<Shape> {
    private GJVisualModel visualModel = new GJVisualModel();
    private GJDataModel dataModel = new GJDataModel();
    private GJGraphInterface parentGraph = null;
    private ArrayList<String> name = new ArrayList();
    private final ArrayList<GJPlotInterface> plotList = new ArrayList();
    public ArrayList<Shape> screenDataArray = new ArrayList(20);

    GJAbstractPlotModelImpl() {
    }

    @Override
    public final GJGraphInterface getParentGraph() {
        GJAbstractPlotModelImpl topPlot = (GJAbstractPlotModelImpl)this.getTopPlot();
        return topPlot.parentGraph;
    }

    protected void initNewInstance() {
        if (this.parentGraph != null) {
            this.parentGraph.remove(this);
            this.parentGraph = null;
        }
    }

    @Override
    public final void setParentGraph(GJGraphInterface gr) {
        GJGraphInterface old = this.getParentGraph();
        if (this.getParentGraph() == null || this.getParentGraph() == gr) {
            if (this.isTopPlot()) {
                this.parentGraph = gr;
                if (!this.parentGraph.getPlots().contains(this)) {
                    this.parentGraph.add(this, false);
                }
            } else {
                this.copyToOtherGraph(gr);
            }
        } else if (this.isTopPlot()) {
            this.parentGraph.remove(this);
            this.parentGraph = gr;
            if (gr != null) {
                gr.add(this);
            }
        } else {
            this.copyToOtherGraph(gr);
        }
        this.getPCS().firePropertyChange("parent", old, this.parentGraph);
    }

    private void copyToOtherGraph(GJGraphInterface gr) {
        if (this.getDataModel().getXData() == null) {
            this.setXData(this.getXData());
        }
        if (this.getDataModel().getYData() == null) {
            this.setYData(this.getYData());
        }
        this.getParentPlot().getPlotList().remove(this);
        this.setParentPlot(null);
        this.parentGraph = gr;
        gr.add(this);
    }

    @Override
    public final void setData(GJDataVectorInterface o1, GJDataVectorInterface o2) {
        this.setXData(o1);
        this.setYData(o2);
    }

    @Override
    public final void setXData(GJDataVectorInterface<?> o) {
        GJDataVectorInterface<?> old = this.getDataModel().getXData();
        this.getDataModel().setXData(o);
        this.getPCS().firePropertyChange("XData", old, this.getDataModel().getXData());
    }

    @Override
    public final void setYData(GJDataVectorInterface<?> o) {
        GJDataVectorInterface<?> old = this.getDataModel().getYData();
        this.getDataModel().setYData(o);
        this.getPCS().firePropertyChange("YData", old, this.getDataModel().getYData());
    }

    @Override
    public final void setXData(double[] x) {
        this.getDataModel().getXData().setDataBufferData(x);
    }

    @Override
    public final void setYData(double[] y) {
        this.getDataModel().getYData().setDataBufferData(y);
    }

    @Override
    public final void setXData(AbstractList<? extends Number> x) {
        this.getDataModel().getXData().setDataBufferData(x);
    }

    @Override
    public final void setXData(Object mx) {
        if (mx == null) {
            this.getDataModel().setXData(null);
        } else if (mx instanceof Map) {
            this.getDataModel().getXData().setDataBufferData((Map)mx);
        }
    }

    @Override
    public final void setXData(int[] x) {
        this.getDataModel().getXData().setDataBufferData(x);
    }

    @Override
    public final void setYData(int[] y) {
        this.getDataModel().getYData().setDataBufferData(y);
    }

    @Override
    public final void setYData(AbstractList<? extends Number> y) {
        this.getDataModel().getYData().setDataBufferData(y);
    }

    @Override
    public final void setYData(Object my) {
        if (my == null) {
            this.getDataModel().setXData(null);
        } else if (my instanceof Map) {
            this.getDataModel().getYData().setDataBufferData((Map)my);
        }
    }

    @Override
    public final double[] getXDataValues() {
        if (this.getDataModel().getXData() == null || this.getDataModel().getXData().getDimension() == 0) {
            if (!this.isTopPlot()) {
                return this.getTopPlot().getXDataValues();
            }
            return null;
        }
        return this.getDataModel().getXData().getDataValues(this.getParentGraph().getXTransform());
    }

    @Override
    public final GJDataVectorInterface<?> getXData() {
        if (this.getDataModel().getXData() == null) {
            if (!this.isTopPlot()) {
                return this.getParentPlot().getXData();
            }
            return null;
        }
        return this.getDataModel().getXData();
    }

    @Override
    public final double[] getYDataValues() {
        if (this.getDataModel().getYData() == null || this.getDataModel().getYData().getDimension() == 0) {
            if (!this.isTopPlot()) {
                return this.getParentPlot().getYDataValues();
            }
            return null;
        }
        return this.getDataModel().getYData().getDataValues(this.getParentGraph().getYTransform());
    }

    @Override
    public final GJDataVectorInterface<?> getYData() {
        if (this.getDataModel().getYData() == null) {
            if (!this.isTopPlot()) {
                return this.getParentPlot().getYData();
            }
            return null;
        }
        return this.getDataModel().getYData();
    }

    @Override
    public final void setExtraData0(double[] val) {
        double[] old = this.getDataModel().getExtraData0();
        this.getDataModel().setExtraData0(val);
        this.getPCS().firePropertyChange("extraData0", old, this.getDataModel().getExtraData0());
    }

    @Override
    public final void setExtraData1(double[] val) {
        double[] old = this.getDataModel().getExtraData1();
        this.getDataModel().setExtraData1(val);
        this.getPCS().firePropertyChange("extraData1", old, this.getDataModel().getExtraData1());
    }

    @Override
    public final void setExtraData2(double[] val) {
        double[] old = this.getDataModel().getExtraData2();
        this.getDataModel().setExtraData2(val);
        this.getPCS().firePropertyChange("extraData2", old, this.getDataModel().getExtraData2());
    }

    @Override
    public final void setExtraData3(double[] val) {
        double[] old = this.getDataModel().getExtraData3();
        this.getDataModel().setExtraData3(val);
        this.getPCS().firePropertyChange("extraData3", old, this.getDataModel().getExtraData3());
    }

    @Override
    public final boolean isMultiplexed() {
        return this.isMultiplexible() && this.getMultiplexLength() > 1;
    }

    @Override
    public final int getMultiplexLength() {
        int[] N = new int[]{1, 1, 1, 1, 1, 1};
        if (this.getVisualModel().getMarkerArray() != null) {
            N[0] = this.getVisualModel().getMarkerArray().size();
        }
        if (this.getVisualModel().getEdgeStroke() != null) {
            N[1] = this.getVisualModel().getEdgeStroke().size();
        }
        if (this.getVisualModel().getEdgeColor() != null) {
            N[2] = this.getVisualModel().getEdgeColor().size();
        }
        if (this.getVisualModel().getLineColor() != null) {
            N[3] = this.getVisualModel().getLineColor().size();
        }
        if (this.getVisualModel().getLineStroke() != null) {
            N[4] = this.getVisualModel().getLineStroke().size();
        }
        if (this.getVisualModel().getFill() != null) {
            N[5] = this.getVisualModel().getFill().size();
        }
        int[] n = ArrayMath.minmax(N);
        return n[1];
    }

    @Override
    public final GJDataTransformInterface getXTransform() {
        if (this.getParentGraph() == null) {
            return NOPTransform.getInstance();
        }
        return this.getParentGraph().getXTransform();
    }

    @Override
    public final GJDataTransformInterface getYTransform() {
        if (this.getParentGraph() == null) {
            return NOPTransform.getInstance();
        }
        return this.getParentGraph().getYTransform();
    }

    @Override
    public final void setAlpha(float val) {
        this.getVisualModel().setAlpha(val);
        if (this.getPlotList() != null) {
            for (GJPlotInterface p : this.getPlotList()) {
                p.setAlpha(val);
            }
        }
    }

    @Override
    public final synchronized ArrayList<Shape> getScreenDataArray() {
        return this.screenDataArray;
    }

    @Override
    public final ArrayList<Shape> getScreenDataArrayAsCopy() {
        return new ArrayList<Shape>(this.getScreenDataArray());
    }

    @Override
    public final synchronized void setScreenDataArray(ArrayList<Shape> ScreenDataArray) {
        this.screenDataArray = ScreenDataArray;
    }

    @Override
    public final float getAlpha() {
        return this.getVisualModel().getAlpha();
    }

    @Override
    public final void setCompositeMode(int val) {
        this.getVisualModel().setCompositeMode(val);
    }

    @Override
    public final int getCompositeMode() {
        return this.getVisualModel().getCompositeMode();
    }

    @Override
    public final void setLineColor(GJCyclicArrayList<Paint> p) {
        this.getVisualModel().setLineColor(new GJCyclicArrayList<GJCyclicArrayList<Paint>>(p));
    }

    @Override
    public final void setLineStroke(BasicStroke s) {
        this.getVisualModel().setLineStroke(new GJCyclicArrayList<BasicStroke>(s));
    }

    @Override
    public final void setLineStroke(int i, BasicStroke s) {
        this.getVisualModel().setLineStroke(i, s);
    }

    @Override
    public final void setLineStroke(BasicStroke[] s) {
        this.getVisualModel().setLineStroke(new GJCyclicArrayList<BasicStroke>(s));
    }

    @Override
    public final void setLineStroke(GJCyclicArrayList<BasicStroke> s) {
        this.getVisualModel().setLineStroke(new GJCyclicArrayList<GJCyclicArrayList<BasicStroke>>(s));
    }

    @Override
    public final void setLineStroke(ArrayList<BasicStroke> s) {
        this.getVisualModel().setLineStroke(new GJCyclicArrayList<ArrayList<BasicStroke>>(s));
    }

    @Override
    public final GJCyclicArrayList<BasicStroke> getLineStroke() {
        return this.getVisualModel().getLineStroke();
    }

    @Override
    public final GJCyclicArrayList<Paint> getLineColor() {
        return this.getVisualModel().getLineColor();
    }

    @Override
    public final void setEdgeStroke(BasicStroke[] s) {
        this.getVisualModel().setEdgeStroke(new GJCyclicArrayList<BasicStroke>(s));
    }

    @Override
    public final void setEdgeStroke(BasicStroke s) {
        this.getVisualModel().setEdgeStroke(new GJCyclicArrayList<BasicStroke>(s));
    }

    @Override
    public final void setEdgeStroke(int index, BasicStroke s) {
        this.getVisualModel().getEdgeStroke().set(index, s);
    }

    @Override
    public final GJCyclicArrayList<BasicStroke> getEdgeStroke() {
        return this.getVisualModel().getEdgeStroke();
    }

    @Override
    public final void setEdgeColor(ArrayList<Paint> p) {
        this.getVisualModel().setEdgeColor(new GJCyclicArrayList<ArrayList<Paint>>(p));
    }

    @Override
    public final void setEdgeColor(Paint[] p) {
        this.getVisualModel().setEdgeColor(new GJCyclicArrayList<Paint>(p));
    }

    @Override
    public final void setEdgeColor(Paint p) {
        this.getVisualModel().setEdgeColor(new GJCyclicArrayList<Paint>(p));
    }

    @Override
    public final void setEdgeColor(int i, Paint p) {
        this.getVisualModel().setEdgeColor(i, p);
    }

    @Override
    public final GJCyclicArrayList<Paint> getEdgeColor() {
        return this.getVisualModel().getEdgeColor();
    }

    @Override
    public final void setFill(ArrayList<Paint> p) {
        this.getVisualModel().setFill(new GJCyclicArrayList<ArrayList<Paint>>(p));
    }

    @Override
    public final void setFill(Paint[] f) {
        this.getVisualModel().setFill(new GJCyclicArrayList<Paint>(f));
    }

    @Override
    public final void setFill(Paint f) {
        this.getVisualModel().setFill(new GJCyclicArrayList<Paint>(f));
    }

    @Override
    public final void setFill(int i, Paint f) {
        this.getVisualModel().setFill(i, f);
    }

    @Override
    public final GJCyclicArrayList<Paint> getFill() {
        return this.getVisualModel().getFill();
    }

    @Override
    public final GJMarker getMarker(int i) {
        return (GJMarker)this.getVisualModel().getMarkerArray().get(i);
    }

    @Override
    public final GJCyclicArrayList<GJMarker> getMarkerArray() {
        return this.getVisualModel().getMarkerArray();
    }

    @Override
    public final void setMarkerArray(GJCyclicArrayList<GJMarker> arr) {
        this.getVisualModel().setMarkerArray(arr);
    }

    @Override
    public final void setMarkerArray(GJMarker m) {
        this.getVisualModel().setMarkerArray(new GJCyclicArrayList<GJMarker>(m));
    }

    @Override
    public final void setMarker(int i, GJMarker s) {
        this.getVisualModel().getMarkerArray().set(i, s);
    }

    @Override
    public final void setMarker(GJMarker s) {
        this.getVisualModel().setMarker(s);
    }

    @Override
    public final void setLineColor(int i, Paint p) {
        this.getVisualModel().getLineColor().set(i, p);
    }

    @Override
    public final void setLineColor(Paint p) {
        this.getVisualModel().setLineColor(new GJCyclicArrayList<Paint>(p));
    }

    @Override
    public final void setLineColor(Paint[] p) {
        this.getVisualModel().setLineColor(new GJCyclicArrayList<Paint>(p));
    }

    @Override
    public final synchronized GJVisualModel getVisualModel() {
        return this.visualModel;
    }

    @Override
    public final synchronized void setVisualModel(GJVisualModel visualModel) {
        this.visualModel = visualModel;
    }

    @Override
    public final void setMarkerArray(GJMarker[] m) {
        this.getVisualModel().setMarkerArray((T[])m);
    }

    @Override
    public final GJCyclicArrayList<Dimension> getDynamicMarkerSize() {
        return this.getVisualModel().getDynamicMarkerSize();
    }

    @Override
    public final void setDynamicMarkerSize(GJCyclicArrayList<Dimension> DynamicMarkerSize) {
        this.getVisualModel().setDynamicMarkerSize(DynamicMarkerSize);
    }

    @Override
    public final void setEdgeColor(GJCyclicArrayList<Paint> EdgeColor) {
        this.getVisualModel().setEdgeColor(EdgeColor);
    }

    @Override
    public final void setEdgeStroke(GJCyclicArrayList<BasicStroke> EdgeStroke) {
        this.getVisualModel().setEdgeStroke(EdgeStroke);
    }

    @Override
    public final void setEdgeStroke(ArrayList<BasicStroke> EdgeStroke) {
        this.getVisualModel().setEdgeStroke(EdgeStroke);
    }

    @Override
    public final void setFill(GJCyclicArrayList<Paint> Fill) {
        this.getVisualModel().setFill(Fill);
    }

    @Override
    public final Object getRenderHintState() {
        return this.getVisualModel().getRenderHintState();
    }

    @Override
    public final void setRenderHintState(Object renderHintState) {
        this.getVisualModel().setRenderHintState(renderHintState);
    }

    @Override
    public final Object getTextHintState() {
        return this.getVisualModel().getTextHintState();
    }

    @Override
    public final void setTextHintState(Object setTextHintState) {
        this.getVisualModel().setTextHintState(setTextHintState);
    }

    @Override
    public final GJDataModel getDataModel() {
        return this.dataModel;
    }

    @Override
    public final void setDataModel(GJDataModel dataModel) {
        this.dataModel = dataModel;
    }

    @Override
    public ArrayList<String> getName() {
        return this.name;
    }

    @Override
    public void setName(ArrayList<String> name) {
        this.name = name;
    }

    public void setName(String name) {
        this.name.clear();
        this.name.add(name);
    }

    @Override
    public final void setPlotList(ArrayList<GJPlotInterface> plotList) {
        ArrayList<GJPlotInterface> old = new ArrayList<GJPlotInterface>(this.plotList);
        this.plotList.clear();
        this.plotList.addAll(plotList);
        this.getPCS().firePropertyChange("plotList", old, plotList);
    }

    @Override
    public final ArrayList<GJPlotInterface> getPlotList() {
        return this.plotList;
    }
}

