/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import kcl.waterloo.graphics.GJAbstractGraphContainer;
import kcl.waterloo.graphics.GJAxisPanel;
import kcl.waterloo.graphics.GJGraphInterface;
import kcl.waterloo.swing.layout.GraphUnitLayout;

public class GraphContainerLayout
extends GraphUnitLayout {
    @Override
    public final void layoutContainer(Container parent) {
        GJAbstractGraphContainer container = (GJAbstractGraphContainer)parent;
        if (container.getView() != null) {
            this.revalidateAdded(container);
            this.revalidateExtra(container);
        }
        try {
            super.layoutContainer(parent);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (container.getAspectRatio() != 0.0 && ((Component)((Object)container.getView())).getWidth() > 0) {
            Rectangle r = ((Component)((Object)container.getView())).getBounds();
            double requiredHeight = r.getWidth() / container.getAspectRatio();
            double requiredWidth = requiredHeight * container.getAspectRatio();
            if (requiredHeight > r.getHeight() || requiredWidth > r.getWidth()) {
                requiredWidth = r.getHeight() * container.getAspectRatio();
                requiredHeight = requiredWidth / container.getAspectRatio();
            }
            this.putConstraint("South", (Component)((Object)container.getView()), (int)requiredHeight, "North", (Component)((Object)container.getView()));
            this.putConstraint("East", (Component)((Object)container.getView()), (int)requiredWidth, "West", (Component)((Object)container.getView()));
            this.putConstraint("West", (Component)((Object)container.getView()), -((int)(requiredWidth / 2.0)), "HorizontalCenter", (Component)container);
            this.putConstraint("North", (Component)((Object)container.getView()), -((int)(requiredHeight / 2.0)), "VerticalCenter", (Component)container);
            super.layoutContainer(parent);
        }
    }

    private void revalidateAdded(GJAbstractGraphContainer container) {
        for (Component c : this.getComponentMap().keySet()) {
            this.revalidateComponent(c, container);
        }
    }

    private void revalidateComponent(Component c, GJAbstractGraphContainer container) {
        if (c.getParent() == null) {
            container.add(c, 0);
        }
        super.revalidateComponent(c, container, container.getView(), true);
    }

    private void revalidateExtra(GJAbstractGraphContainer container) {
        GJGraphInterface View2 = container.getView();
        if (container.getComponentCount() == 0) {
            return;
        }
        double topMargin = 0.0;
        double leftMargin = 0.0;
        double bottomMargin = 0.0;
        double rightMargin = 0.0;
        ArrayList Layers = View2.getLayers();
        int space = GJAxisPanel.getInterAxisSpace();
        for (GJGraphInterface layer : Layers) {
            if (layer.isTopAxisPainted() && layer.getTopAxisPanel() != null) {
                layer.getTopAxisPanel().setOffset((int)topMargin);
                layer.getTopAxisPanel().revalidate();
                topMargin = topMargin + (double)layer.getTopAxisPanel().getExtent() + (double)space;
            }
            if (layer.isLeftAxisPainted() && layer.getLeftAxisPanel() != null) {
                layer.getLeftAxisPanel().setOffset((int)leftMargin);
                layer.getLeftAxisPanel().revalidate();
                leftMargin = leftMargin + (double)layer.getLeftAxisPanel().getExtent() + (double)space;
            }
            if (layer.isBottomAxisPainted() && layer.getBottomAxisPanel() != null) {
                layer.getBottomAxisPanel().setOffset((int)bottomMargin);
                layer.getBottomAxisPanel().revalidate();
                bottomMargin = bottomMargin + (double)layer.getBottomAxisPanel().getExtent() + (double)space;
            }
            if (!layer.isRightAxisPainted() || layer.getRightAxisPanel() == null) continue;
            layer.getRightAxisPanel().setOffset((int)rightMargin);
            layer.getRightAxisPanel().revalidate();
            rightMargin = rightMargin + (double)layer.getRightAxisPanel().getExtent() + (double)space;
        }
        int minMargin = GJAxisPanel.getMinimumMargin();
        Insets summedInsets = new Insets((int)Math.max((double)minMargin, topMargin), (int)Math.max((double)minMargin, leftMargin), (int)Math.max((double)minMargin, bottomMargin), (int)Math.max((double)minMargin, rightMargin));
        this.putConstraint("West", (Component)((Object)View2), summedInsets.left, "West", (Component)container);
        this.putConstraint("North", (Component)((Object)View2), summedInsets.top, "North", (Component)container);
        this.putConstraint("East", (Component)((Object)View2), -summedInsets.right, "East", (Component)container);
        this.putConstraint("South", (Component)((Object)View2), -summedInsets.bottom, "South", (Component)container);
        JComponent featurePane = container.getFeaturePane();
        if (featurePane != null) {
            this.putConstraint("West", (Component)featurePane, 0, "West", (Component)((Object)View2));
            this.putConstraint("North", (Component)featurePane, 0, "North", (Component)((Object)View2));
            this.putConstraint("East", (Component)featurePane, 0, "East", (Component)((Object)View2));
            this.putConstraint("South", (Component)featurePane, 0, "South", (Component)((Object)View2));
        }
        JFormattedTextField title = container.getTitle();
        this.putConstraint("North", (Component)title, 2, "North", (Component)container);
        this.putConstraint("HorizontalCenter", (Component)title, 0, "HorizontalCenter", (Component)((Object)container.getView()));
        if (title != null) {
            this.putConstraint("North", (Component)container.getSubTitle(), 2, "South", (Component)title);
            this.putConstraint("HorizontalCenter", (Component)container.getSubTitle(), 0, "HorizontalCenter", (Component)((Object)container.getView()));
        } else {
            this.putConstraint("North", (Component)container.getSubTitle(), 10, "North", (Component)container);
            this.putConstraint("HorizontalCenter", (Component)container.getSubTitle(), 0, "HorizontalCenter", (Component)((Object)container.getView()));
        }
    }
}

