/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import kcl.waterloo.defaults.Colors;
import kcl.waterloo.graphics.GJAbstractGraph;
import kcl.waterloo.graphics.GJBasicPanel;
import kcl.waterloo.graphics.GJCustomGraphLayoutInterface;
import kcl.waterloo.graphics.images.Images;
import kcl.waterloo.math.ArrayMath;

public class GJRoi
extends GJBasicPanel
implements GJCustomGraphLayoutInterface,
MouseListener,
MouseMotionListener,
ComponentListener,
PropertyChangeListener {
    private JLabel panelNW = new JLabel(Images.getIcon("arrow_corner.png"));
    private JLabel panelNE = new JLabel(Images.getIcon("arrow_corner.png"));
    private JLabel panelSW = new JLabel(Images.getIcon("arrow_corner.png"));
    private JLabel panelSE = new JLabel(Images.getIcon("arrow_corner.png"));
    private JLabel panelS = new JLabel(Images.getIcon("arrow_updown.png"));
    private JLabel panelN = new JLabel(Images.getIcon("arrow_updown.png"));
    private JLabel panelE = new JLabel(Images.getIcon("arrow_leftright.png"));
    private JLabel panelW = new JLabel(Images.getIcon("arrow_leftright.png"));
    private static int sz = 10;
    private Point2D dragStart = null;
    private final Rectangle2D.Double pixelRectangle = new Rectangle2D.Double();
    private final Rectangle2D.Double axesRectangle = new Rectangle2D.Double();
    protected int minSiz = sz * 3;

    public GJRoi() {
        super(new SpringLayout());
        this.setBorder(new LineBorder(Colors.getColor("DARKGREEN"), 2, true));
        this.setBackgroundPainted(true);
        this.setBackground(new Color(0.0f, 1.0f, 0.0f, 0.4f));
        SpringLayout layout = (SpringLayout)this.getLayout();
        this.add(this.panelNW);
        this.add(this.panelNE);
        this.add(this.panelSW);
        this.add(this.panelSE);
        this.add(this.panelN);
        this.add(this.panelS);
        this.add(this.panelE);
        this.add(this.panelW);
        layout.putConstraint("East", (Component)this.panelNE, 0, "East", (Component)this);
        layout.putConstraint("West", (Component)this.panelNE, -sz, "East", (Component)this);
        layout.putConstraint("North", (Component)this.panelNE, 0, "North", (Component)this);
        layout.putConstraint("South", (Component)this.panelNE, sz, "North", (Component)this);
        layout.putConstraint("East", (Component)this.panelSE, 0, "East", (Component)this);
        layout.putConstraint("West", (Component)this.panelSE, -sz, "East", (Component)this);
        layout.putConstraint("South", (Component)this.panelSE, 0, "South", (Component)this);
        layout.putConstraint("North", (Component)this.panelSE, -sz, "South", (Component)this);
        layout.putConstraint("West", (Component)this.panelNW, 0, "West", (Component)this);
        layout.putConstraint("East", (Component)this.panelNW, sz, "West", (Component)this);
        layout.putConstraint("North", (Component)this.panelNW, 0, "North", (Component)this);
        layout.putConstraint("South", (Component)this.panelNW, sz, "North", (Component)this);
        layout.putConstraint("West", (Component)this.panelSW, 0, "West", (Component)this);
        layout.putConstraint("East", (Component)this.panelSW, sz, "West", (Component)this);
        layout.putConstraint("South", (Component)this.panelSW, 0, "South", (Component)this);
        layout.putConstraint("North", (Component)this.panelSW, -sz, "South", (Component)this);
        layout.putConstraint("HorizontalCenter", (Component)this.panelN, 0, "HorizontalCenter", (Component)this);
        layout.putConstraint("North", (Component)this.panelN, 0, "North", (Component)this);
        layout.putConstraint("South", (Component)this.panelN, sz, "North", (Component)this);
        layout.putConstraint("HorizontalCenter", (Component)this.panelS, 0, "HorizontalCenter", (Component)this);
        layout.putConstraint("North", (Component)this.panelS, -sz, "South", (Component)this);
        layout.putConstraint("South", (Component)this.panelS, 0, "South", (Component)this);
        layout.putConstraint("VerticalCenter", (Component)this.panelW, 0, "VerticalCenter", (Component)this);
        layout.putConstraint("East", (Component)this.panelW, sz, "West", (Component)this);
        layout.putConstraint("West", (Component)this.panelW, 0, "West", (Component)this);
        layout.putConstraint("VerticalCenter", (Component)this.panelE, 0, "VerticalCenter", (Component)this);
        layout.putConstraint("East", (Component)this.panelE, 0, "East", (Component)this);
        layout.putConstraint("West", (Component)this.panelE, -sz, "East", (Component)this);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.panelNE.setCursor(Cursor.getPredefinedCursor(7));
        this.panelNW.setCursor(Cursor.getPredefinedCursor(6));
        this.panelSE.setCursor(Cursor.getPredefinedCursor(5));
        this.panelSW.setCursor(Cursor.getPredefinedCursor(4));
        this.panelS.setCursor(Cursor.getPredefinedCursor(9));
        this.panelN.setCursor(Cursor.getPredefinedCursor(8));
        this.panelE.setCursor(Cursor.getPredefinedCursor(11));
        this.panelW.setCursor(Cursor.getPredefinedCursor(10));
        this.addMouseListener(this);
        this.panelNW.addMouseListener(this);
        this.panelNE.addMouseListener(this);
        this.panelSW.addMouseListener(this);
        this.panelSE.addMouseListener(this);
        this.panelS.addMouseListener(this);
        this.panelE.addMouseListener(this);
        this.panelN.addMouseListener(this);
        this.panelW.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.panelNW.addMouseMotionListener(this);
        this.panelNE.addMouseMotionListener(this);
        this.panelSW.addMouseMotionListener(this);
        this.panelSE.addMouseMotionListener(this);
        this.panelS.addMouseMotionListener(this);
        this.panelE.addMouseMotionListener(this);
        this.panelN.addMouseMotionListener(this);
        this.panelW.addMouseMotionListener(this);
    }

    public GJRoi(Rectangle2D.Double r) {
        this();
        this.axesRectangle.setRect(r);
    }

    public static GJRoi createInstance(GJAbstractGraph gr) {
        Rectangle2D r = gr.getAxesBounds();
        return GJRoi.createInstance(gr, new Rectangle2D.Double(r.getCenterX() - 0.1 * r.getWidth(), r.getCenterY() + 0.1 * r.getHeight(), 0.2 * r.getWidth(), 0.2 * r.getHeight()));
    }

    public static GJRoi createInstance(final GJAbstractGraph gr, final Rectangle2D.Double r) {
        final GJRoi roi = new GJRoi();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                gr.add(roi);
                roi.setAxesRectangle(r);
                gr.addComponentListener(roi);
                gr.addPropertyChangeListener(roi);
                gr.revalidate();
                gr.repaint();
            }
        });
        return roi;
    }

    public final Rectangle2D.Double getAxesRectangle() {
        if (this.getParent() != null) {
            this.axesRectangle.setRect(((GJAbstractGraph)this.getParent()).transformPixelToPosition(this.pixelRectangle));
        }
        return (Rectangle2D.Double)this.axesRectangle.clone();
    }

    public final void setAxesRectangle(Rectangle2D.Double axesRectangle) {
        this.axesRectangle.setRect(axesRectangle);
        if (this.getParent() != null) {
            this.setPixelRectangle(((GJAbstractGraph)this.getParent()).transformPositionToPixel(axesRectangle));
        }
    }

    public final Rectangle2D.Double getPixelRectangle() {
        return (Rectangle2D.Double)this.pixelRectangle.clone();
    }

    public final void setPixelRectangle(Rectangle2D.Double pixelRectangle) {
        this.pixelRectangle.setRect(pixelRectangle);
        if (this.getParent() != null) {
            this.axesRectangle.setRect(((GJAbstractGraph)this.getParent()).transformPixelToPosition(pixelRectangle));
            this.getParent().revalidate();
        }
    }

    private void reposition(MouseEvent e, double dX, double dY) {
        if (this.getParent() != null) {
            if (((GJAbstractGraph)this.getParent()).getGraphContainer().getRotation() != 0.0 || ((GJAbstractGraph)this.getParent()).getGraphContainer().getZoom() != 1.0) {
                return;
            }
            Rectangle2D.Double r = this.pixelRectangle;
            if (e == null || e.getSource().equals(this)) {
                r.setRect(r.getX() + dX, r.getY() + dY, r.getWidth(), r.getHeight());
            } else if (e.getSource().equals(this.panelNE)) {
                r.setRect(r.getX(), r.getY() + dY, r.getWidth() + dX, r.getHeight() - dY);
            } else if (e.getSource().equals(this.panelNW)) {
                r.setRect(r.getX() + dX, r.getY() + dY, r.getWidth() - dX, r.getHeight() - dY);
            } else if (e.getSource().equals(this.panelSE)) {
                r.setRect(r.getX(), r.getY(), r.getWidth() + dX, r.getHeight() + dY);
            } else if (e.getSource().equals(this.panelSW)) {
                r.setRect(r.getX() + dX, r.getY(), r.getWidth() - dX, r.getHeight() + dY);
            } else if (e.getSource().equals(this.panelN)) {
                r.setRect(r.getX(), r.getY() + dY, r.getWidth(), r.getHeight() - dY);
            } else if (e.getSource().equals(this.panelS)) {
                r.setRect(r.getX(), r.getY(), r.getWidth(), r.getHeight() + dY);
            } else if (e.getSource().equals(this.panelE)) {
                r.setRect(r.getX(), r.getY(), r.getWidth() + dX, r.getHeight());
            } else if (e.getSource().equals(this.panelW)) {
                r.setRect(r.getX() + dX, r.getY(), r.getWidth() - dX, r.getHeight());
            }
            r.setRect(r.x, r.y, Math.max(r.width, (double)this.minSiz), Math.max(r.height, (double)this.minSiz));
            this.axesRectangle.setRect(((GJAbstractGraph)this.getParent()).transformPixelToPosition(this.pixelRectangle));
        }
    }

    @Override
    public final void setConstraints() {
        if (this.getParent() != null) {
            SpringLayout layout = (SpringLayout)this.getParent().getLayout();
            Rectangle2D.Double r = this.pixelRectangle;
            layout.putConstraint("West", (Component)this, (int)((RectangularShape)r).getX(), "West", (Component)this.getParent());
            layout.putConstraint("North", (Component)this, (int)((RectangularShape)r).getY(), "North", (Component)this.getParent());
            layout.putConstraint("East", (Component)this, (int)(((RectangularShape)r).getX() + ((RectangularShape)r).getWidth()), "West", (Component)this.getParent());
            layout.putConstraint("South", (Component)this, (int)(((RectangularShape)r).getY() + ((RectangularShape)r).getHeight()), "North", (Component)this.getParent());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        e = SwingUtilities.convertMouseEvent((Component)e.getSource(), e, this.getParent());
        this.dragStart = e.getPoint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public final void mouseDragged(MouseEvent e) {
        if (this.getParent() != null && this.dragStart != null) {
            MouseEvent e2 = SwingUtilities.convertMouseEvent((Component)e.getSource(), e, this.getParent());
            double dX = (double)e2.getX() - this.dragStart.getX();
            double dY = (double)e2.getY() - this.dragStart.getY();
            this.reposition(e, dX, dY);
            this.getParent().revalidate();
            this.dragStart = e2.getPoint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.getParent() != null) {
            this.setPixelRectangle(((GJAbstractGraph)this.getParent()).transformPositionToPixel(this.axesRectangle));
            this.getParent().repaint();
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.componentResized(e);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof GJAbstractGraph) {
            GJAbstractGraph gr = (GJAbstractGraph)evt.getSource();
            if (evt.getPropertyName().equals("XTransform") || evt.getPropertyName().equals("YTransform") || evt.getPropertyName().equals("axesBounds")) {
                Rectangle2D.Double old = this.pixelRectangle;
                this.pixelRectangle.setRect(gr.transformPositionToPixel(this.axesRectangle));
                if (ArrayMath.any(ArrayMath.isNaN(new double[]{this.pixelRectangle.x, this.pixelRectangle.y, this.pixelRectangle.width, this.pixelRectangle.height}))) {
                    this.setPixelRectangle(old);
                    this.setVisible(false);
                } else {
                    this.setVisible(true);
                    gr.revalidate();
                }
            }
        }
    }

    public void removeIcons() {
        this.panelNE.setIcon(null);
        this.panelNW.setIcon(null);
        this.panelSW.setIcon(null);
        this.panelSE.setIcon(null);
        this.panelN.setIcon(null);
        this.panelS.setIcon(null);
        this.panelE.setIcon(null);
        this.panelW.setIcon(null);
        this.panelNE.setText(" ");
        this.panelNW.setText(" ");
        this.panelSW.setText(" ");
        this.panelSE.setText(" ");
        this.panelN.setText(" ");
        this.panelS.setText(" ");
        this.panelE.setText(" ");
        this.panelW.setText(" ");
    }
}

