/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.common.deploy;

import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Map;

public abstract class AbstractDeployableGraphics2D
extends Graphics2D {
    protected Graphics2D parentGraphics;
    protected ArrayList<Formatter> pictures = new ArrayList();
    private int actionDelay = 5000;
    protected ArrayList<Integer> latency = new ArrayList();
    private boolean alsoPaintToSource = true;
    protected long startTime = System.currentTimeMillis();

    protected AbstractDeployableGraphics2D(Graphics2D g) {
        this.parentGraphics = g;
        this.latency.add(0, 0);
    }

    public boolean isAlsoPaintToSource() {
        return this.alsoPaintToSource;
    }

    public void setAlsoPaintToSource(boolean alsoPaintToSource) {
        this.alsoPaintToSource = alsoPaintToSource;
    }

    public int getActionDelay() {
        return this.actionDelay;
    }

    public void setActionDelay(int actionDelay) {
        this.actionDelay = Math.max(actionDelay, 1);
    }

    public abstract void append(Component var1, int var2);

    public abstract void append(Component var1);

    public String getCode() {
        return this.pictures.get(0).toString();
    }

    public void write(File f) throws IOException {
        FileOutputStream fout = null;
        OutputStreamWriter out = null;
        try {
            fout = new FileOutputStream(f);
            out = new OutputStreamWriter((OutputStream)fout, "UTF-8");
            out.write(this.getCode());
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (fout != null) {
                fout.close();
            }
        }
    }

    public void write(String f) throws IOException {
        this.write(new File(f));
    }

    public abstract void setPaintObject(Object var1);

    public abstract void addComment(String var1);

    public abstract void prependCode(String var1);

    public abstract void addCode(String var1);

    public abstract void appendCode(String var1);

    public abstract boolean copyImage(Image var1, int var2, int var3, int var4, int var5, int var6, int var7, Color var8, ImageObserver var9);

    @Override
    public final void draw3DRect(int x, int y, int width, int height, boolean raised) {
        this.parentGraphics.draw3DRect(x, y, width, height, raised);
    }

    @Override
    public final void fill3DRect(int x, int y, int width, int height, boolean raised) {
        this.parentGraphics.fill3DRect(x, y, width, height, raised);
    }

    @Override
    public final void setTransform(AffineTransform Tx) {
        this.parentGraphics.setTransform(Tx);
    }

    @Override
    public AffineTransform getTransform() {
        return this.parentGraphics.getTransform();
    }

    @Override
    public Stroke getStroke() {
        return this.parentGraphics.getStroke();
    }

    @Override
    public void clip(Shape s) {
        this.parentGraphics.clip(s);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.parentGraphics.getFontRenderContext();
    }

    @Override
    public Color getColor() {
        return this.parentGraphics.getColor();
    }

    @Override
    public void setColor(Color c) {
        this.parentGraphics.setColor(c);
    }

    @Override
    public void setPaintMode() {
        this.parentGraphics.setPaintMode();
    }

    @Override
    public final Font getFont() {
        return this.parentGraphics.getFont();
    }

    @Override
    public void setFont(Font font) {
        this.parentGraphics.setFont(font);
    }

    @Override
    public Rectangle getClipBounds() {
        return this.parentGraphics.getClipBounds();
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.parentGraphics.clipRect(x, y, width, height);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.parentGraphics.setClip(x, y, width, height);
    }

    @Override
    public Shape getClip() {
        return this.parentGraphics.getClip();
    }

    @Override
    public void setClip(Shape clip) {
        this.parentGraphics.setClip(clip);
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return this.parentGraphics.hit(rect, s, onStroke);
    }

    @Override
    public void setComposite(Composite comp) {
        this.parentGraphics.setComposite(comp);
    }

    @Override
    public void setPaint(Paint paint) {
        this.parentGraphics.setPaint(paint);
    }

    @Override
    public void setStroke(Stroke s) {
        this.parentGraphics.setStroke(s);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.parentGraphics.setRenderingHint(hintKey, hintValue);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.parentGraphics.getRenderingHint(hintKey);
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.parentGraphics.setRenderingHints(hints);
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.parentGraphics.addRenderingHints(hints);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.parentGraphics.getRenderingHints();
    }

    @Override
    public void setXORMode(Color c1) {
        this.parentGraphics.setXORMode(c1);
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return this.parentGraphics.getFontMetrics(f);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.parentGraphics.copyArea(x, y, width, height, dx, dy);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.parentGraphics.getDeviceConfiguration();
    }

    @Override
    public void translate(int x, int y) {
        this.parentGraphics.translate(x, y);
    }

    @Override
    public void translate(double tx, double ty) {
        this.parentGraphics.translate(tx, ty);
    }

    @Override
    public void rotate(double theta) {
        this.parentGraphics.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.parentGraphics.rotate(theta, x, y);
    }

    @Override
    public void scale(double sx, double sy) {
        this.parentGraphics.scale(sx, sy);
    }

    @Override
    public void shear(double shx, double shy) {
        this.parentGraphics.shear(shx, shy);
    }

    @Override
    public void transform(AffineTransform Tx) {
        this.parentGraphics.transform(Tx);
    }

    @Override
    public Paint getPaint() {
        return this.parentGraphics.getPaint();
    }

    @Override
    public Composite getComposite() {
        return this.parentGraphics.getComposite();
    }

    @Override
    public void setBackground(Color color) {
        this.parentGraphics.setBackground(color);
    }

    @Override
    public Color getBackground() {
        return this.parentGraphics.getBackground();
    }

    @Override
    public void draw(Shape s) {
        if (this.alsoPaintToSource) {
            this.parentGraphics.draw(s);
        }
    }

    @Override
    public void drawString(String str, int x, int y) {
        if (this.alsoPaintToSource) {
            this.parentGraphics.drawString(str, x, y);
        }
    }

    @Override
    public void drawString(String str, float x, float y) {
        if (this.alsoPaintToSource) {
            this.parentGraphics.drawString(str, x, y);
        }
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        if (this.alsoPaintToSource) {
            this.parentGraphics.drawString(iterator, x, y);
        }
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        if (this.alsoPaintToSource) {
            this.parentGraphics.drawString(iterator, x, y);
        }
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        if (this.alsoPaintToSource) {
            this.parentGraphics.drawGlyphVector(g, x, y);
        }
    }

    @Override
    public void fill(Shape s) {
        if (this.alsoPaintToSource) {
            this.parentGraphics.fill(s);
        }
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.alsoPaintToSource) {
            this.parentGraphics.drawLine(x1, y1, x2, y2);
        }
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        if (this.alsoPaintToSource) {
            this.parentGraphics.fillRect(x, y, width, height);
        }
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        if (this.alsoPaintToSource) {
            this.parentGraphics.fillRect(x, y, width, height);
        }
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        if (this.alsoPaintToSource) {
            this.parentGraphics.clearRect(x, y, width, height);
        }
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.alsoPaintToSource) {
            this.parentGraphics.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
        }
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.alsoPaintToSource) {
            this.parentGraphics.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
        }
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        if (this.alsoPaintToSource) {
            this.parentGraphics.drawOval(x, y, width, height);
        }
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        if (this.alsoPaintToSource) {
            this.parentGraphics.fillOval(x, y, width, height);
        }
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.alsoPaintToSource) {
            this.parentGraphics.drawArc(x, y, width, height, startAngle, arcAngle);
        }
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.alsoPaintToSource) {
            this.parentGraphics.fillArc(x, y, width, height, startAngle, arcAngle);
        }
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        if (this.alsoPaintToSource) {
            this.parentGraphics.drawPolyline(xPoints, yPoints, nPoints);
        }
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        if (this.alsoPaintToSource) {
            this.parentGraphics.drawPolyline(xPoints, yPoints, nPoints);
        }
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        if (this.alsoPaintToSource) {
            this.parentGraphics.fillPolygon(xPoints, yPoints, nPoints);
        }
    }

    @Override
    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
        if (this.alsoPaintToSource) {
            this.parentGraphics.drawBytes(data, offset, length, x, y);
        }
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.drawImage(img, x, y, img.getWidth(observer), img.getHeight(observer), observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.parentGraphics.drawImage(img, x, y, width, height, null);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.drawImage(img, x, y, img.getWidth(observer), img.getHeight(observer), bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return this.parentGraphics.drawImage(img, x, y, width, height, bgcolor, null);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return this.parentGraphics.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, null);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return this.parentGraphics.drawImage(img, xform, null);
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        this.parentGraphics.drawImage(img, op, x, y);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        this.parentGraphics.drawRenderedImage(img, xform);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.parentGraphics.drawRenderableImage(img, xform);
    }

    @Override
    public void dispose() {
        this.parentGraphics.dispose();
    }

    protected static class GJPathSegmentInfo {
        private int type = -1;
        private double[] data = new double[6];

        public GJPathSegmentInfo() {
            this.type = 7;
        }

        public GJPathSegmentInfo(int t, double[] d) {
            this.type = t;
            this.setData(d);
        }

        public final int getType() {
            return this.type;
        }

        public final void setType(int t) {
            this.type = t;
        }

        public final double[] getData() {
            return (double[])this.data.clone();
        }

        public final void setData(double[] d) {
            this.data = (double[])d.clone();
        }
    }
}

