/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.actions;

import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import kcl.waterloo.actions.ActionServices;
import kcl.waterloo.common.deploy.GJSequencerInterface;
import kcl.waterloo.defaults.GJDefaults;
import kcl.waterloo.deploy.gif.GJGifSequencer;
import kcl.waterloo.graphics.GJAbstractGraph;
import kcl.waterloo.graphics.GJAbstractGraphContainer;
import kcl.waterloo.graphics.GJBasicPanel;
import kcl.waterloo.graphics.GJGraphContainer;
import kcl.waterloo.graphics.GJGraphInterface;
import kcl.waterloo.gui.file.AnimationFileChooser;
import kcl.waterloo.serviceproviders.ToolBar;
import kcl.waterloo.swing.GCFrame;
import kcl.waterloo.swing.GCGridContainerInterface;
import kcl.waterloo.xml.FileWrapper;

public class ActionManager {
    private static final LinkedHashMap<Component, Timer> timerLookup = new LinkedHashMap();
    private static final LinkedHashMap<Component, GJSequencerInterface> sequencerLookup = new LinkedHashMap();

    private ActionManager() {
    }

    public static SwingWorker<?, ?> processAction(ActionEvent ae, final Component thisComponent) {
        String command = ae.getActionCommand();
        ToolBar toolBar = null;
        if (ae.getSource() instanceof JButton) {
            toolBar = (ToolBar)((JButton)ae.getSource()).getParent().getParent();
        }
        if (command.matches("Open Graph")) {
            SwingWorker<FileWrapper, Void> worker = new SwingWorker<FileWrapper, Void>(){

                @Override
                protected FileWrapper doInBackground() throws Exception {
                    return ActionServices.open();
                }

                @Override
                public void done() {
                    Object o;
                    try {
                        o = ((FileWrapper)this.get()).getContents();
                    }
                    catch (InterruptedException ex) {
                        return;
                    }
                    catch (ExecutionException ex) {
                        return;
                    }
                    if (o instanceof GJAbstractGraphContainer) {
                        GCFrame f = new GCFrame();
                        f.add((GJAbstractGraphContainer)o);
                    } else if (o instanceof GJAbstractGraph) {
                        GJGraphContainer gr = ((GJGraphInterface)o).getGraphContainer() != null ? (GJGraphContainer)((GJAbstractGraph)o).getGraphContainer() : GJGraphContainer.createInstance((GJAbstractGraph)o);
                        GCFrame f = new GCFrame();
                        f.add(gr);
                    } else if (o instanceof GCGridContainerInterface) {
                        GCFrame f = new GCFrame();
                        f.setContentPane((Container)o);
                    } else if (o instanceof ArrayList) {
                        for (Object o2 : (ArrayList)o) {
                            if (!(o2 instanceof GJAbstractGraphContainer)) continue;
                            GCFrame f = new GCFrame();
                            f.add((GJAbstractGraphContainer)o2);
                        }
                    }
                }
            };
            worker.execute();
            return worker;
        }
        if (command.matches("Save Graph")) {
            SwingWorker<FileWrapper, Void> worker = new SwingWorker<FileWrapper, Void>(){

                @Override
                protected FileWrapper doInBackground() throws Exception {
                    return ActionServices.save(thisComponent);
                }
            };
            worker.execute();
            return worker;
        }
        if (command.matches("Save Graph As") || command.contains("Save As")) {
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    ActionServices.saveAs(thisComponent);
                    return null;
                }
            };
            worker.execute();
            return worker;
        }
        if (command.matches("Deploy")) {
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    ActionServices.deployAs(thisComponent);
                    return null;
                }
            };
            worker.execute();
            return worker;
        }
        if (command.matches("Copy")) {
            if (thisComponent instanceof GJBasicPanel) {
                SwingWorker<SwingWorker<Boolean, Void>, Void> worker = new SwingWorker<SwingWorker<Boolean, Void>, Void>(){

                    @Override
                    protected SwingWorker<Boolean, Void> doInBackground() throws Exception {
                        return ActionServices.copyGraphics((GJBasicPanel)thisComponent);
                    }
                };
                worker.execute();
                return worker;
            }
        } else if (command.matches("Copy As Image")) {
            if (thisComponent instanceof GJBasicPanel) {
                SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        ActionServices.copyAsImage((GJBasicPanel)thisComponent);
                        return null;
                    }
                };
                worker.execute();
                return worker;
            }
        } else if (command.matches("Print Graph")) {
            if (thisComponent instanceof GJBasicPanel) {
                SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        ((GJBasicPanel)thisComponent).print();
                        return null;
                    }
                };
                worker.execute();
                return worker;
            }
        } else if (command.matches("Edit Defaults")) {
            if (thisComponent instanceof GJBasicPanel) {
                GJDefaults.editDefaults();
            }
        } else if (command.matches("Start Recording")) {
            if (toolBar != null) {
                if (timerLookup.containsKey(thisComponent)) {
                    timerLookup.get(thisComponent).start();
                    toolBar.getStartRecording().setSelected(true);
                } else {
                    String interval = (String)toolBar.getRecordInterval().getSelectedItem();
                    interval = interval.replaceFirst("ms", "");
                    double ninterval = Double.valueOf(interval);
                    try {
                        GJGifSequencer sequencer = GJGifSequencer.createInstance(thisComponent, (int)ninterval, true);
                        Timer timer = new Timer((int)ninterval, sequencer);
                        timer.start();
                        timerLookup.put(thisComponent, timer);
                        sequencerLookup.put(thisComponent, sequencer);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    toolBar.getStartRecording().setSelected(true);
                }
            }
        } else if (command.matches("Pause Recording")) {
            if (toolBar != null && timerLookup.containsKey(thisComponent)) {
                if (timerLookup.get(thisComponent).isRunning()) {
                    timerLookup.get(thisComponent).stop();
                    toolBar.getPauseRecording().setSelected(true);
                } else {
                    timerLookup.get(thisComponent).start();
                    toolBar.getPauseRecording().setSelected(false);
                }
            }
        } else if (command.matches("Stop Recording")) {
            if (toolBar != null) {
                if (timerLookup.containsKey(thisComponent)) {
                    timerLookup.get(thisComponent).stop();
                    timerLookup.remove(thisComponent);
                    toolBar.getStartRecording().setSelected(false);
                }
                if (sequencerLookup.containsKey(thisComponent) && !((GJGifSequencer)sequencerLookup.get(thisComponent)).isMemoryCached()) {
                    try {
                        ((GJGifSequencer)sequencerLookup.get(thisComponent)).close();
                        sequencerLookup.remove(thisComponent);
                        toolBar.getSaveRecording().setSelected(false);
                    }
                    catch (IOException interval) {
                        // empty catch block
                    }
                }
                toolBar.getPauseRecording().setSelected(false);
                toolBar.getStopRecording().setSelected(false);
            }
        } else if (command.matches("Save Recording")) {
            if (toolBar != null && sequencerLookup.containsKey(thisComponent)) {
                if (((GJGifSequencer)sequencerLookup.get(thisComponent)).isMemoryCached()) {
                    String filename;
                    if (ActionServices.isUseChooser()) {
                        AnimationFileChooser chooser = AnimationFileChooser.getInstance();
                        int val = chooser.showOpenDialog(null);
                        if (val != 0) {
                            return null;
                        }
                        filename = chooser.getSelectedFile().getPath();
                    } else {
                        FileDialog chooser = new FileDialog((Frame)null, "Save GIF", 1);
                        chooser.setFilenameFilter(new GIFSaveFilter());
                        chooser.setVisible(true);
                        filename = chooser.getFile();
                        if (filename != null && !filename.isEmpty()) {
                            if (!filename.toLowerCase().endsWith(".gif")) {
                                filename = filename.concat(".gif");
                            }
                            filename = new File(chooser.getDirectory(), filename).getPath();
                        }
                    }
                    try {
                        ((GJGifSequencer)sequencerLookup.get(thisComponent)).close(filename);
                        sequencerLookup.remove(thisComponent);
                    }
                    catch (IOException chooser) {
                        // empty catch block
                    }
                }
                ((JButton)ae.getSource()).setSelected(false);
            }
        } else {
            ((JButton)ae.getSource()).setSelected(true);
            FileDialog chooser = new FileDialog((Frame)null, "Save GIF", 1);
            chooser.setFilenameFilter(new GIFSaveFilter());
            chooser.setVisible(true);
            String filename = chooser.getFile();
            if (filename != null && !filename.isEmpty()) {
                if (!filename.toLowerCase().endsWith(".gif")) {
                    filename = filename.concat(".gif");
                }
                String interval = (String)((ToolBar)((JButton)ae.getSource()).getParent().getParent()).getRecordInterval().getSelectedItem();
                interval = interval.replaceFirst("ms", "");
                double ninterval = Double.valueOf(interval);
                try {
                    GJGifSequencer sequencer = GJGifSequencer.createInstance(filename, thisComponent, (int)ninterval, true);
                    Timer timer = new Timer((int)ninterval, sequencer);
                    timer.start();
                    timerLookup.put(thisComponent, timer);
                    sequencerLookup.put(thisComponent, sequencer);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private static class GIFSaveFilter
    implements FilenameFilter {
        private GIFSaveFilter() {
        }

        @Override
        public boolean accept(File f, String s) {
            String extension = ActionServices.getExtension(s);
            if (extension != null) {
                return extension.equals("gif");
            }
            return false;
        }
    }
}

