/*
 * Decompiled with CFR 0.152.
 */
package hephysics.vec;

import hephysics.vec.Hep3Matrix;
import hephysics.vec.HepLorentzVector;
import hephysics.vec.VecOp;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

public class Hep3Vector
implements Serializable {
    static final long serialVersionUID = -52454965658870098L;
    protected double x;
    protected double y;
    protected double z;

    public Hep3Vector() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Hep3Vector(double dx, double dy, double dz) {
        this.x = dx;
        this.y = dy;
        this.z = dz;
    }

    double skp(Hep3Vector momentum) {
        return this.x * momentum.x() + this.y * momentum.y() + this.z * momentum.z();
    }

    public double abs() {
        return Math.sqrt(this.skp(this));
    }

    public Hep3Vector copy(Hep3Vector p) {
        return new Hep3Vector(p.x(), p.y(), p.z());
    }

    public double cosTheta() {
        double ptot = this.mag();
        return ptot == 0.0 ? 1.0 : this.z / ptot;
    }

    public double phi() {
        return this.x == 0.0 && this.y == 0.0 ? 0.0 : Math.atan2(this.y, this.x);
    }

    public Hep3Vector unit(Hep3Vector v) {
        double mag = v.mag();
        if (mag != 0.0) {
            return this.mult(1.0 / mag, v);
        }
        return new Hep3Vector(0.0, 0.0, 0.0);
    }

    public Hep3Vector neg(Hep3Vector v) {
        return new Hep3Vector(-v.x(), -v.y(), -v.z());
    }

    public Hep3Vector add(Hep3Vector v, Hep3Vector w) {
        return new Hep3Vector(v.x() + w.x(), v.y() + w.y(), v.z() + w.z());
    }

    public void add(Hep3Vector v) {
        this.setX(v.x() + this.x);
        this.setY(v.y() + this.y);
        this.setZ(v.z() + this.z);
    }

    public void sub(Hep3Vector v) {
        this.setX(this.x - v.x());
        this.setY(this.y - v.y());
        this.setZ(this.z - v.z());
    }

    public Hep3Vector sub(Hep3Vector v, Hep3Vector w) {
        return new Hep3Vector(v.x() - w.x(), v.y() - w.y(), v.z() - w.z());
    }

    public Hep3Vector mult(double scalar, Hep3Vector v) {
        return new Hep3Vector(scalar * v.x(), scalar * v.y(), scalar * v.z());
    }

    public void mult(double scalar) {
        this.setX(this.x * scalar);
        this.setY(this.y * scalar);
        this.setZ(this.z * scalar);
    }

    public Hep3Vector centerOfMass(List<Hep3Vector> vecSet) {
        boolean empty = true;
        boolean threeVecSet = false;
        Hep3Vector cmVec = new Hep3Vector();
        Iterator<Hep3Vector> i = vecSet.iterator();
        while (i.hasNext()) {
            if (empty) {
                empty = false;
                Hep3Vector e = i.next();
                if (e instanceof Hep3Vector) {
                    threeVecSet = true;
                    cmVec = e;
                    continue;
                }
                throw new RuntimeException("Element is not a 3- or 4-vector");
            }
            if (!threeVecSet) continue;
            try {
                cmVec = this.add(cmVec, i.next());
            }
            catch (ClassCastException ex) {
                throw new RuntimeException("Element of 3Vec enumeration is not a 3Vec object.");
            }
        }
        if (!empty) {
            return cmVec;
        }
        throw new RuntimeException("CM:vector set is empty.");
    }

    public Hep3Vector cross(Hep3Vector v, Hep3Vector w) {
        double u1 = v.y() * w.z() - v.z() * w.y();
        double u2 = v.z() * w.x() - v.x() * w.z();
        double u3 = v.x() * w.y() - v.y() * w.x();
        return new Hep3Vector(u1, u2, u3);
    }

    public double dot(Hep3Vector v, Hep3Vector w) {
        return v.x() * w.x() + v.y() * w.y() + v.z() * w.z();
    }

    public double perp() {
        return Math.sqrt(this.perp2());
    }

    public double dot(Hep3Vector p) {
        return this.x * p.x() + this.y * p.y() + this.z * p.z();
    }

    public double perp2() {
        return this.x * this.x + this.y * this.y;
    }

    public double angle(Hep3Vector momentum) {
        if (this.abs() <= 0.0 || momentum.abs() <= 0.0) {
            return 0.0;
        }
        return (double)(this.y * momentum.z() - this.z * momentum.y() <= 0.0 ? -1 : 1) * Math.acos(this.skp(momentum) / this.abs() / momentum.abs());
    }

    public Hep3Vector(double[] d) {
        if (d.length != 3) {
            throw new IllegalArgumentException("Illegal array length");
        }
        this.x = d[0];
        this.y = d[1];
        this.z = d[2];
    }

    public Hep3Vector(float[] f) {
        if (f.length != 3) {
            throw new IllegalArgumentException("Illegal array length");
        }
        this.x = f[0];
        this.y = f[1];
        this.z = f[2];
    }

    public void setV(double dx, double dy, double dz) {
        this.x = dx;
        this.y = dy;
        this.z = dz;
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public void setX(double x) {
        this.x = x;
    }

    public HepLorentzVector boost(HepLorentzVector fourVector, Hep3Vector boostVector) {
        double beta = boostVector.mag();
        if (beta >= 1.0) {
            throw new RuntimeException("Boost beta >= 1.0 !");
        }
        double gamma = 1.0 / Math.sqrt(1.0 - beta * beta);
        double t = fourVector.t();
        Hep3Vector v = fourVector.v3();
        double tp = gamma * (t - this.dot(boostVector, v));
        Hep3Vector vp = this.add(v, this.add(this.mult((gamma - 1.0) / (beta * beta) * this.dot(boostVector, v), boostVector), this.mult(-gamma * t, boostVector)));
        return new HepLorentzVector(vp, tp);
    }

    public HepLorentzVector boost(HepLorentzVector fourVector, HepLorentzVector refFourVector) {
        Hep3Vector refVector = refFourVector.v3();
        Hep3Vector boostVector = new Hep3Vector(refVector.x(), refVector.y(), refVector.z());
        boostVector = this.mult(1.0 / refFourVector.t(), boostVector);
        return this.boost(fourVector, boostVector);
    }

    public Hep3Vector mult(Hep3Matrix m, Hep3Vector v) {
        double w1 = v.x() * m.e(0, 0) + v.y() * m.e(0, 1) + v.z() * m.e(0, 2);
        double w2 = v.x() * m.e(1, 0) + v.y() * m.e(1, 1) + v.z() * m.e(1, 2);
        double w3 = v.x() * m.e(2, 0) + v.y() * m.e(2, 1) + v.z() * m.e(2, 2);
        return new Hep3Vector(w1, w2, w3);
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public double mag2() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double theta() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0 ? 0.0 : Math.atan2(this.perp(), this.z);
    }

    public double cosTheta(Hep3Vector vector) {
        return vector.z() / vector.mag();
    }

    public void setPhi(double ph) {
        double xy = this.perp();
        this.setX(xy * Math.cos(ph));
        this.setY(xy * Math.sin(ph));
    }

    public double pseudoRapidity() {
        double cosTheta = this.cosTheta();
        if (cosTheta * cosTheta < 1.0) {
            return -0.5 * Math.log((1.0 - cosTheta) / (1.0 + cosTheta));
        }
        return -1.0E11;
    }

    public double rapidity() {
        double m = this.mag();
        if (this.mag() > this.z) {
            return 0.5 * Math.log((m + this.z) / (m - this.z));
        }
        return -1.0E11;
    }

    public double getEta() {
        return this.pseudoRapidity();
    }

    public double mag() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double magnitudeSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double[] v() {
        return new double[]{this.x, this.y, this.z};
    }

    public boolean equals(Object obj) {
        if (obj instanceof Hep3Vector) {
            Hep3Vector that = (Hep3Vector)obj;
            return this.x == that.x() && this.y == that.y() && this.z == that.z();
        }
        return false;
    }

    public String toString() {
        return VecOp.toString(this);
    }

    public int hashCode() {
        return (int)(Double.doubleToLongBits(this.x) + Double.doubleToLongBits(this.y) + Double.doubleToLongBits(this.z));
    }
}

