/*
 * Decompiled with CFR 0.152.
 */
package hephysics.jet;

import hephysics.jet.ParticleD;
import java.util.ArrayList;
import java.util.List;

class ClusterSequence {
    private static final double twopi = Math.PI * 2;
    private static final double max_rap = 100000.0;
    private byte alg;
    private double jetR2;
    private int num;
    private PseudoJet first;
    private TileGrid grid;
    private boolean use_grid;

    private static double sq(double x) {
        return x * x;
    }

    public ClusterSequence(String alg, double jetR) {
        if (alg.equalsIgnoreCase("kt")) {
            this.alg = 1;
        } else if (alg.equalsIgnoreCase("antikt")) {
            this.alg = (byte)-1;
        } else if (alg.equalsIgnoreCase("ca")) {
            this.alg = 0;
        } else if (alg.equalsIgnoreCase("cambridge")) {
            this.alg = 0;
        } else {
            System.out.println("Warning: Unrecognized clustering algorithm: " + alg + ".\nDefaulting to antikt.");
            this.alg = (byte)-1;
        }
        this.jetR2 = jetR * jetR;
        this.grid = new TileGrid(jetR, 5.0);
    }

    public ArrayList<ParticleD> cluster(List<ParticleD> particles, double min_jet_pt) {
        int n = particles.size();
        this.num = 0;
        this.use_grid = n > 50;
        ArrayList<ParticleD> jets = new ArrayList<ParticleD>();
        if (n == 0) {
            return jets;
        }
        PseudoJet p = this.first = new PseudoJet(particles.get(0).px(), particles.get(0).py(), particles.get(0).pz(), particles.get(0).e());
        if (this.use_grid) {
            this.grid.add(p);
        }
        for (int i = 1; i < n; ++i) {
            p.next = new PseudoJet(particles.get(i).px(), particles.get(i).py(), particles.get(i).pz(), particles.get(i).e());
            p.next.prev = p;
            p = p.next;
            if (!this.use_grid) continue;
            this.grid.add(p);
        }
        if (this.use_grid) {
            p = this.first;
            while (p != null) {
                this.grid.update_near(p, false);
                p = p.next;
            }
        } else {
            p = this.first.next;
            while (p != null) {
                PseudoJet q = this.first;
                while (q != p) {
                    p.update_near(q, true);
                    q = q.next;
                }
                p = p.next;
            }
        }
        p = this.first;
        while (p != null) {
            p.update_dij();
            p = p.next;
        }
        while (this.first != null) {
            PseudoJet p2;
            PseudoJet p1;
            if (n < 50) {
                this.use_grid = false;
                this.grid.clear();
            }
            p = this.first;
            double dist = p.diB;
            boolean merge = false;
            PseudoJet q = this.first;
            while (q != null) {
                if (q.dij < dist) {
                    p = q;
                    dist = q.dij;
                    merge = true;
                }
                q = q.next;
            }
            if (p.Rij > this.jetR2) {
                q = this.first.next;
                while (q != null) {
                    if (q.diB < dist) {
                        p = q;
                        dist = q.diB;
                        merge = false;
                    }
                    q = q.next;
                }
            }
            if (merge) {
                p.merge();
                if (this.use_grid) {
                    this.grid.add(this.first);
                }
                if (this.use_grid) {
                    this.grid.update_near(this.first, true);
                    this.first.update_dij();
                    p1 = this.first.next;
                    while (p1 != null) {
                        if (p1.near == p || p1.near == p.near) {
                            p1.rm_near();
                            this.grid.update_near(p1, false);
                            p1.update_dij();
                        }
                        p1 = p1.next;
                    }
                } else {
                    q = this.first.next;
                    while (q != null) {
                        if (this.first.update_near(q, true)) {
                            q.update_dij();
                        }
                        q = q.next;
                    }
                    this.first.update_dij();
                    p1 = this.first.next;
                    while (p1 != null) {
                        if (p1.near == p || p1.near == p.near) {
                            p1.rm_near();
                            p2 = this.first;
                            while (p2 != null) {
                                if (p1 != p2) {
                                    p1.update_near(p2, false);
                                }
                                p2 = p2.next;
                            }
                            p1.update_dij();
                        }
                        p1 = p1.next;
                    }
                }
            } else {
                if (Math.sqrt(ClusterSequence.sq(p.px) + ClusterSequence.sq(p.py)) >= min_jet_pt) {
                    ParticleD jet = new ParticleD(p.px, p.py, p.pz, p.E);
                    jets.add(jet);
                    if (p.consts == null) {
                        jet.addConstituent(p.id);
                    } else {
                        jet.setConstituents(p.consts);
                    }
                }
                p.remove();
                if (this.use_grid) {
                    p1 = this.first;
                    while (p1 != null) {
                        if (p1.near == p) {
                            p1.rm_near();
                            this.grid.update_near(p1, false);
                            p1.update_dij();
                        }
                        p1 = p1.next;
                    }
                } else {
                    p1 = this.first;
                    while (p1 != null) {
                        if (p1.near == p) {
                            p1.rm_near();
                            p2 = this.first;
                            while (p2 != null) {
                                if (p1 != p2) {
                                    p1.update_near(p2, false);
                                }
                                p2 = p2.next;
                            }
                            p1.update_dij();
                        }
                        p1 = p1.next;
                    }
                }
            }
            --n;
        }
        this.first = null;
        if (this.use_grid) {
            this.grid.clear();
        }
        return jets;
    }

    private class TileGrid {
        private final Tile[][] tiles;
        private final int nrap;
        private final int nphi;
        private final double d;
        private final double r;
        private final double max_rap;

        public TileGrid(double R, double max_rap) {
            this.nphi = (int)(Math.PI * 2 / R);
            this.d = Math.PI * 2 / (double)this.nphi;
            this.r = this.d / 2.0;
            this.nrap = 2 * ((int)(max_rap / this.r) + 1);
            this.max_rap = (double)this.nrap * this.r;
            this.tiles = new Tile[this.nphi][this.nrap];
            for (int irap = 0; irap < this.nrap; ++irap) {
                for (int iphi = 0; iphi < this.nphi; ++iphi) {
                    this.tiles[iphi][irap] = new Tile(irap, iphi, (double)(irap - this.nrap / 2) * this.d + this.r, (double)iphi * this.d + this.r);
                }
            }
        }

        public void clear() {
            for (int irap = 0; irap < this.nrap; ++irap) {
                for (int iphi = 0; iphi < this.nphi; ++iphi) {
                    this.tiles[iphi][irap].first = null;
                }
            }
        }

        public void add(PseudoJet p) {
            int irap = (int)((p.rap + this.max_rap) / this.d);
            if (irap < 0) {
                irap = 0;
            } else if (irap >= this.nrap) {
                irap = this.nrap - 1;
            }
            p.t = this.tiles[(int)(p.phi / this.d)][irap];
            if (p.t.first == null) {
                p.t.first = p;
            } else {
                p.tnext = p.t.first;
                p.t.first.tprev = p;
                p.t.first = p;
            }
        }

        private void within_tile(PseudoJet p, Tile t, boolean both) {
            PseudoJet q = t.first;
            while (q != null) {
                if (p.update_near(q, both)) {
                    q.update_dij();
                }
                q = q.tnext;
            }
        }

        public void update_near(PseudoJet p, boolean both) {
            boolean tr;
            PseudoJet q = p.t.first;
            while (q != null) {
                if (q != p && p.update_near(q, both)) {
                    q.update_dij();
                }
                q = q.tnext;
            }
            boolean td = ClusterSequence.sq(p.phi - p.t.phic + this.r) < p.Rij;
            boolean tu = ClusterSequence.sq(p.phi - p.t.phic - this.r) < p.Rij;
            boolean tl = ClusterSequence.sq(p.rap - p.t.rapc + this.r) < p.Rij;
            boolean bl = tr = ClusterSequence.sq(p.rap - p.t.rapc - this.r) < p.Rij;
            if (p.t.irap != 0 && tl) {
                this.within_tile(p, this.tiles[p.t.iphi][p.t.irap - 1], both);
                if (td) {
                    this.within_tile(p, this.tiles[p.t.iphi == 0 ? this.nphi - 1 : p.t.iphi - 1][p.t.irap - 1], both);
                }
                if (tu) {
                    this.within_tile(p, this.tiles[this.nphi - p.t.iphi == 1 ? 0 : p.t.iphi + 1][p.t.irap - 1], both);
                }
            }
            if (td) {
                this.within_tile(p, this.tiles[p.t.iphi == 0 ? this.nphi - 1 : p.t.iphi - 1][p.t.irap], both);
            }
            if (tu) {
                this.within_tile(p, this.tiles[this.nphi - p.t.iphi == 1 ? 0 : p.t.iphi + 1][p.t.irap], both);
            }
            if (this.nrap - p.t.irap != 1 && tr) {
                this.within_tile(p, this.tiles[p.t.iphi][p.t.irap + 1], both);
                if (td) {
                    this.within_tile(p, this.tiles[p.t.iphi == 0 ? this.nphi - 1 : p.t.iphi - 1][p.t.irap + 1], both);
                }
                if (tu) {
                    this.within_tile(p, this.tiles[this.nphi - p.t.iphi == 1 ? 0 : p.t.iphi + 1][p.t.irap + 1], both);
                }
            }
        }
    }

    class Tile {
        int irap;
        int iphi;
        double rapc;
        double phic;
        PseudoJet first;

        Tile(int irap, int iphi, double rapc, double phic) {
            this.irap = irap;
            this.iphi = iphi;
            this.rapc = rapc;
            this.phic = phic;
        }
    }

    private class PseudoJet {
        public double px;
        public double py;
        public double pz;
        public double E;
        public double rap;
        public double phi;
        public double Rij;
        public double diB;
        public double dij;
        public int id;
        public PseudoJet prev;
        public PseudoJet next;
        public PseudoJet near;
        public Tile t;
        public PseudoJet tprev;
        public PseudoJet tnext;
        public ArrayList<Integer> consts;

        public PseudoJet(double px, double py, double pz, double E) {
            this.px = px;
            this.py = py;
            this.pz = pz;
            this.E = E;
            this.id = ClusterSequence.this.num++;
            double pt2 = px * px + py * py;
            double abs_pz = pz < 0.0 ? -pz : pz;
            this.phi = (pt2 == 0.0 ? 0.0 : Math.atan2(py, px)) + Math.PI;
            if (this.phi >= Math.PI * 2) {
                this.phi -= Math.PI * 2;
            } else if (this.phi < 0.0) {
                this.phi += Math.PI * 2;
            }
            if (E == abs_pz && pt2 == 0.0) {
                this.rap = 100000.0 + abs_pz;
                if (pz < 0.0) {
                    this.rap = -this.rap;
                }
            } else {
                double m2_pt2 = (E + pz) * (E - pz);
                if (m2_pt2 < pt2) {
                    m2_pt2 = pt2;
                }
                this.rap = 0.5 * Math.log(m2_pt2 / ClusterSequence.sq(E + abs_pz));
                if (pz > 0.0) {
                    this.rap = -this.rap;
                }
            }
            switch (ClusterSequence.this.alg) {
                case -1: {
                    if (pt2 == 0.0) {
                        this.diB = Double.MAX_VALUE;
                        break;
                    }
                    this.diB = 1.0 / pt2;
                    break;
                }
                case 1: {
                    this.diB = pt2;
                    break;
                }
                case 0: {
                    this.diB = 1.0;
                }
            }
            this.Rij = Double.MAX_VALUE;
        }

        public void remove() {
            if (this.prev == null) {
                ClusterSequence.this.first = this.next;
            } else {
                this.prev.next = this.next;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            if (ClusterSequence.this.use_grid) {
                if (this.tprev == null) {
                    this.t.first = this.tnext;
                } else {
                    this.tprev.tnext = this.tnext;
                }
                if (this.tnext != null) {
                    this.tnext.tprev = this.tprev;
                }
            }
        }

        public void merge() {
            ((ClusterSequence)ClusterSequence.this).first.prev = new PseudoJet(this.px + this.near.px, this.py + this.near.py, this.pz + this.near.pz, this.E + this.near.E);
            ((ClusterSequence)ClusterSequence.this).first.prev.next = ClusterSequence.this.first;
            ClusterSequence.this.first = ((ClusterSequence)ClusterSequence.this).first.prev;
            if (this.consts != null || this.near.consts != null) {
                if (this.consts != null) {
                    ((ClusterSequence)ClusterSequence.this).first.consts = this.consts;
                    if (this.near.consts != null) {
                        ((ClusterSequence)ClusterSequence.this).first.consts.addAll(this.near.consts);
                    } else {
                        ((ClusterSequence)ClusterSequence.this).first.consts.add(this.near.id);
                    }
                } else {
                    ((ClusterSequence)ClusterSequence.this).first.consts = this.near.consts;
                    ((ClusterSequence)ClusterSequence.this).first.consts.add(this.id);
                }
            } else {
                ((ClusterSequence)ClusterSequence.this).first.consts = new ArrayList();
                ((ClusterSequence)ClusterSequence.this).first.consts.add(this.id);
                ((ClusterSequence)ClusterSequence.this).first.consts.add(this.near.id);
            }
            this.remove();
            this.near.remove();
        }

        public boolean update_near(PseudoJet p, boolean both) {
            double Ril;
            double deltaPhi = Math.abs(this.phi - p.phi);
            if (deltaPhi > Math.PI) {
                deltaPhi = Math.PI * 2 - deltaPhi;
            }
            if ((Ril = ClusterSequence.sq(this.rap - p.rap) + ClusterSequence.sq(deltaPhi)) < this.Rij) {
                this.Rij = Ril;
                this.near = p;
            }
            if (both) {
                if (Ril < p.Rij) {
                    p.Rij = Ril;
                    p.near = this;
                    return true;
                }
                return false;
            }
            return false;
        }

        public void update_dij() {
            this.dij = this.near == null ? Double.MAX_VALUE : Math.min(this.diB, this.near.diB) * this.Rij / ClusterSequence.this.jetR2;
        }

        public void rm_near() {
            this.near = null;
            this.Rij = Double.MAX_VALUE;
        }
    }
}

