/*
 * Decompiled with CFR 0.152.
 */
package hephysics.hepsim;

import hephysics.jet.ParticleD;
import hephysics.jet.ParticleF;
import hephysics.particle.HEParticle;
import hephysics.particle.LParticle;
import hephysics.vec.HepLorentzVector;
import java.util.ArrayList;
import java.util.List;
import promc.io.ProMC;
import promc.io.ProMCHeaderFile;
import pronlo.io.ProMC;
import pronlo.io.ProMCHeaderFile;

public class PromcUtil {
    public static HEParticle getParticle(ProMC.ProMCEvent.Particles pa, int energy_unit, int length_unit, int j) {
        HEParticle lp = new HEParticle((double)pa.getPx(j) / (double)energy_unit, (double)pa.getPy(j) / (double)energy_unit, (double)pa.getPz(j) / (double)energy_unit, (double)pa.getEnergy(j) / (double)energy_unit);
        lp.setMass((double)pa.getMass(j) / (double)energy_unit);
        lp.setPdgcode(pa.getPdgId(j));
        lp.setStatus(pa.getStatus(j));
        lp.setCharge(pa.getCharge(j));
        lp.setBarcode(pa.getBarcode(j));
        HepLorentzVector pos = new HepLorentzVector((double)pa.getX(j) / (double)length_unit, (double)pa.getY(j) / (double)length_unit, (double)pa.getZ(j) / (double)length_unit, (double)pa.getT(j) / (double)length_unit);
        lp.setPosition(pos);
        return lp;
    }

    public static LParticle getPosition(ProMC.ProMCEvent.Particles pa, int unit, int j) {
        LParticle lp = new LParticle();
        lp.setXYZT((double)pa.getX(j) / (double)unit, (double)pa.getY(j) / (double)unit, (double)pa.getZ(j) / (double)unit, (double)pa.getT(j) / (double)unit);
        return lp;
    }

    public static List<LParticle> getLParticleList(ProMCHeaderFile.ProMCHeader header, ProMC.ProMCEvent.Particles pa, int status, double pTmin, double etaMax) {
        int unit = header.getMomentumUnit();
        int lunit = header.getLengthUnit();
        ArrayList<LParticle> par = new ArrayList<LParticle>();
        if (pTmin <= 0.0 && etaMax >= 1000.0) {
            for (int j = 0; j < pa.getPxCount(); ++j) {
                if (pa.getStatus(j) != status) continue;
                LParticle lp = new LParticle((double)pa.getPx(j) / (double)unit, (double)pa.getPy(j) / (double)unit, (double)pa.getPz(j) / (double)unit, (double)pa.getEnergy(j) / (double)unit);
                par.add(lp);
            }
            return par;
        }
        if (pTmin > 0.0 || etaMax < 1000.0) {
            for (int j = 0; j < pa.getPxCount(); ++j) {
                LParticle lp;
                if (pa.getStatus(j) != status || !((lp = new LParticle((double)pa.getPx(j) / (double)unit, (double)pa.getPy(j) / (double)unit, (double)pa.getPz(j) / (double)unit, (double)pa.getEnergy(j) / (double)unit)).perp() > pTmin) || !(Math.abs(lp.pseudoRapidity()) < etaMax)) continue;
                par.add(lp);
            }
            return par;
        }
        return par;
    }

    public static LParticle[] getLParticleArray(ProMCHeaderFile.ProMCHeader header, ProMC.ProMCEvent.Particles pa, int status, double pTmin, double etaMax) {
        List<LParticle> list = PromcUtil.getLParticleList(header, pa, status, pTmin, etaMax);
        LParticle[] lp = new LParticle[list.size()];
        for (int j = 0; j < list.size(); ++j) {
            lp[j] = list.get(j);
        }
        return lp;
    }

    public static List<ParticleF> getParticleFList(ProMCHeaderFile.ProMCHeader header, ProMC.ProMCEvent.Particles pa, int status, double pTmin, double etaMax) {
        int unit = header.getMomentumUnit();
        int lunit = header.getLengthUnit();
        ArrayList<ParticleF> par = new ArrayList<ParticleF>();
        if (pTmin <= 0.0 && etaMax >= 1000.0) {
            for (int j = 0; j < pa.getPxCount(); ++j) {
                if (pa.getStatus(j) != status) continue;
                ParticleF lp = new ParticleF((float)((double)pa.getPx(j) / (double)unit), (float)((double)pa.getPy(j) / (double)unit), (float)((double)pa.getPz(j) / (double)unit), (float)((double)pa.getEnergy(j) / (double)unit));
                par.add(lp);
            }
            return par;
        }
        if (pTmin > 0.0 || etaMax < 1000.0) {
            for (int j = 0; j < pa.getPxCount(); ++j) {
                ParticleF lp;
                if (pa.getStatus(j) != status || !((double)(lp = new ParticleF((float)((double)pa.getPx(j) / (double)unit), (float)((double)pa.getPy(j) / (double)unit), (float)((double)pa.getPz(j) / (double)unit), (float)((double)pa.getEnergy(j) / (double)unit))).getEt() > pTmin) || !((double)Math.abs(lp.getEta()) < etaMax)) continue;
                par.add(lp);
            }
            return par;
        }
        return par;
    }

    public static List<ParticleF> getParticleFList(ProMCHeaderFile.ProMCHeader header, ProMC.ProMCEvent.Particles pa, double pTmin, double etaMax) {
        int unit = header.getMomentumUnit();
        int lunit = header.getLengthUnit();
        ArrayList<ParticleF> par = new ArrayList<ParticleF>();
        if (pTmin <= 0.0 && etaMax >= 1000.0) {
            for (int j = 0; j < pa.getPxCount(); ++j) {
                ParticleF lp = new ParticleF((float)((double)pa.getPx(j) / (double)unit), (float)((double)pa.getPy(j) / (double)unit), (float)((double)pa.getPz(j) / (double)unit), (float)((double)pa.getEnergy(j) / (double)unit));
                par.add(lp);
            }
            return par;
        }
        if (pTmin > 0.0 || etaMax < 1000.0) {
            for (int j = 0; j < pa.getPxCount(); ++j) {
                ParticleF lp = new ParticleF((float)((double)pa.getPx(j) / (double)unit), (float)((double)pa.getPy(j) / (double)unit), (float)((double)pa.getPz(j) / (double)unit), (float)((double)pa.getEnergy(j) / (double)unit));
                if (!((double)lp.getEt() > pTmin) || !((double)Math.abs(lp.getEta()) < etaMax)) continue;
                par.add(lp);
            }
            return par;
        }
        return par;
    }

    public static List<ParticleD> getParticleDList(ProMCHeaderFile.ProMCHeader header, ProMC.ProMCEvent.Particles pa, double pTmin, double etaMax) {
        int unit = header.getMomentumUnit();
        int lunit = header.getLengthUnit();
        ArrayList<ParticleD> par = new ArrayList<ParticleD>();
        if (pTmin <= 0.0 && etaMax >= 1000.0) {
            for (int j = 0; j < pa.getPxCount(); ++j) {
                ParticleD lp = new ParticleD((double)pa.getPx(j) / (double)unit, (double)pa.getPy(j) / (double)unit, (double)pa.getPz(j) / (double)unit, (double)pa.getEnergy(j) / (double)unit);
                par.add(lp);
            }
            return par;
        }
        if (pTmin > 0.0 || etaMax < 1000.0) {
            for (int j = 0; j < pa.getPxCount(); ++j) {
                ParticleD lp = new ParticleD((double)pa.getPx(j) / (double)unit, (double)pa.getPy(j) / (double)unit, (double)pa.getPz(j) / (double)unit, (double)pa.getEnergy(j) / (double)unit);
                if (!(lp.getPt() > pTmin) || !(Math.abs(lp.eta()) < etaMax)) continue;
                par.add(lp);
            }
            return par;
        }
        return par;
    }

    public static List<ParticleD> getParticleDList(ProMCHeaderFile.ProMCHeader header, ProMC.ProMCEvent.Particles pa, int status, double pTmin, double etaMax) {
        int unit = header.getMomentumUnit();
        int lunit = header.getLengthUnit();
        ArrayList<ParticleD> par = new ArrayList<ParticleD>();
        if (pTmin <= 0.0 && etaMax >= 1000.0) {
            for (int j = 0; j < pa.getPxCount(); ++j) {
                if (pa.getStatus(j) != status) continue;
                ParticleD lp = new ParticleD((float)((double)pa.getPx(j) / (double)unit), (float)((double)pa.getPy(j) / (double)unit), (float)((double)pa.getPz(j) / (double)unit), (float)((double)pa.getEnergy(j) / (double)unit));
                par.add(lp);
            }
            return par;
        }
        if (pTmin > 0.0 || etaMax < 1000.0) {
            for (int j = 0; j < pa.getPxCount(); ++j) {
                ParticleD lp;
                if (pa.getStatus(j) != status || !((lp = new ParticleD((float)((double)pa.getPx(j) / (double)unit), (float)((double)pa.getPy(j) / (double)unit), (float)((double)pa.getPz(j) / (double)unit), (float)((double)pa.getEnergy(j) / (double)unit))).getPt() > pTmin) || !(Math.abs(lp.eta()) < etaMax)) continue;
                par.add(lp);
            }
            return par;
        }
        return par;
    }
}

