/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.hipo.io;

import java.util.ArrayList;
import java.util.List;
import org.jlab.hipo.io.HipoReader;
import org.jlab.hipo.io.HipoRecordHeader;

public class HipoFileInfo {
    List<HipoRecordHeader> fileRecords = new ArrayList<HipoRecordHeader>();
    private int numberOfEvents = 0;
    private int currentRecord = 0;
    private int currentEvent = 0;
    private int currentRecordLastEvent = 0;
    private int currentRecordFirstEvent = 0;

    public void addRecord(HipoRecordHeader header) {
        this.fileRecords.add(header);
    }

    public void clear() {
        this.fileRecords.clear();
        this.currentEvent = 0;
        this.currentRecord = 0;
        this.currentRecordFirstEvent = 0;
        this.currentRecordLastEvent = 0;
    }

    public void reset() {
        this.currentEvent = 0;
        this.currentRecord = 0;
        this.currentRecordLastEvent = 0;
        this.currentRecordFirstEvent = 0;
        this.numberOfEvents = 0;
        if (this.fileRecords.size() > 0) {
            this.currentRecordLastEvent = this.fileRecords.get(0).getNumberOfEvents() - 1;
            for (int i = 0; i < this.fileRecords.size(); ++i) {
                this.numberOfEvents += this.fileRecords.get(i).getNumberOfEvents();
            }
        }
    }

    private void incrementRecord() {
        ++this.currentRecord;
        this.currentRecordFirstEvent = this.currentRecordLastEvent + 1;
        this.currentRecordLastEvent = this.currentRecordFirstEvent + this.fileRecords.get(this.currentRecord).getNumberOfEvents() - 1;
    }

    public void setEvent(int index) {
        if (index > this.currentEvent) {
            if (index <= this.currentRecordLastEvent) {
                this.currentEvent = index;
            } else {
                this.currentEvent = index;
                while (this.currentEvent > this.currentRecordLastEvent) {
                    this.incrementRecord();
                }
            }
        }
    }

    public int getRecord() {
        return this.currentRecord;
    }

    public int getEventOffset() {
        return this.currentEvent - this.currentRecordFirstEvent;
    }

    public static void main(String[] args) {
        String filename = "/Users/gavalian/Work/Software/Release-4a.0/COATJAVA/coatjava/clas12dst_000809.hipo";
        HipoReader reader = new HipoReader();
        reader.open(filename);
        int nevents = reader.getEventCount();
        System.out.println(" N# = " + nevents);
        for (int i = 42000000; i < nevents; ++i) {
            reader.getFileInfo().setEvent(i);
            System.out.println("  I =  " + i + "  RECORD = " + reader.getFileInfo().getRecord() + " OFFSET = " + reader.getFileInfo().getEventOffset());
        }
    }
}

