/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import org.jlab.groot.base.AxisAttributes;
import org.jlab.groot.base.DatasetAttributes;
import org.jlab.groot.base.FontProperties;
import org.jlab.groot.graphics.EmbeddedCanvas;
import org.jlab.groot.graphics.Histogram2DPlotter;
import org.jlab.groot.graphics.IDataSetPlotter;
import org.jlab.groot.ui.JComboCheckBox;

public class OptionsPanel
extends JPanel {
    int pad;
    EmbeddedCanvas can = null;
    JTabbedPane tabbedPane = null;
    JTabbedPane datasetPanes = null;

    public OptionsPanel(EmbeddedCanvas can, int pad) {
        this.can = can;
        this.pad = pad;
        this.tabbedPane = new JTabbedPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        this.initMain();
        this.initAxes();
        this.initDatasets();
    }

    private void initMain() {
        JPanel main = new JPanel();
        main.setLayout(new GridBagLayout());
        main.setMinimumSize(new Dimension(200, 300));
        GridBagConstraints c = new GridBagConstraints();
        int yGrid = 0;
        c.fill = 1;
        c.gridy = yGrid++;
        c.weightx = 1.0;
        c.weighty = 1.0;
        JPanel frameOptions = new JPanel();
        this.initFrameOptions(frameOptions);
        JPanel generalOptions = new JPanel();
        this.initAxisOptions(generalOptions);
        main.add((Component)generalOptions, c);
        c.gridy = yGrid++;
        c.weightx = 1.0;
        c.weighty = 1.0;
        main.add((Component)frameOptions, c);
        this.tabbedPane.add("Main", main);
    }

    private void initAxisOptions(JPanel axisOptions) {
        final String[] systemFonts = FontProperties.getSystemFontsArray();
        final String[] fontSize = FontProperties.getFontSizeArray();
        axisOptions.setLayout(new BorderLayout());
        JPanel optionsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        optionsPanel.setBorder(new TitledBorder("Options"));
        String[] lineThickness = new String[]{"1", "2", "3", "4", "5", "6", "7", "8"};
        String[] fillColor = new String[]{"34", "35", "36", "37", "38"};
        String[] colors = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9"};
        String[] colorNames = new String[]{"Black", "White", "Red", "Green", "Blue", "Yellow", "Magenta", "Cyan", "Dark Green", "Purple-ish"};
        String[] translucency = new String[]{"100%", "80%", "60%", "40%", "20%"};
        final JComboBox<String> fontsBox = new JComboBox<String>(systemFonts);
        fontsBox.setSelectedIndex(0);
        for (int i = 0; i < systemFonts.length; ++i) {
            if (!this.can.getPad(this.pad).getAxisX().getTitleFont().getFontName().contains(systemFonts[i])) continue;
            fontsBox.setSelectedIndex(i);
        }
        final JComboBox<String> axisFontSizeBox = new JComboBox<String>(fontSize);
        axisFontSizeBox.setSelectedItem("" + this.can.getPad(this.pad).getAxisX().getLabelFontSize());
        final JComboBox<String> axisTitleFontSizeBox = new JComboBox<String>(fontSize);
        axisTitleFontSizeBox.setSelectedItem("" + this.can.getPad(this.pad).getAxisX().getTitleFontSize());
        final JComboBox<String> titleFontSizeBox = new JComboBox<String>(fontSize);
        titleFontSizeBox.setSelectedItem("" + this.can.getPad(this.pad).getTitleFontSize());
        final JComboBox<String> statBoxFontSizeBox = new JComboBox<String>(fontSize);
        statBoxFontSizeBox.setSelectedItem("" + this.can.getPad(this.pad).getStatBoxFontSize());
        JLabel fontLabel = new JLabel("Font:");
        JLabel axisFontSizeLabel = new JLabel("Axis Label Font Size:");
        JLabel axisTitleFontSizeLabel = new JLabel("Axis Title Font Size:");
        JLabel titleFontSizeLabel = new JLabel("Title Font Size:");
        JLabel statBoxFontSizeLabel = new JLabel("Stat Box Font Size:");
        JLabel xAxisTitleLabel = new JLabel("X Axis Title:");
        JLabel yAxisTitleLabel = new JLabel("Y Axis Title:");
        JLabel titleLabel = new JLabel("Title:");
        final JTextField xAxisTextField = new JTextField(this.can.getPad(this.pad).getAxisX().getTitle());
        final JTextField yAxisTextField = new JTextField(this.can.getPad(this.pad).getAxisY().getTitle());
        final JTextField titleTextField = new JTextField(this.can.getPad(this.pad).getTitle());
        JPanel gridPanel = new JPanel(new GridLayout(1, 2));
        final JCheckBox xGridBox = new JCheckBox("Grid X");
        xGridBox.setSelected(this.can.getPad(this.pad).getAxisX().getGrid());
        final JCheckBox yGridBox = new JCheckBox("Grid Y");
        yGridBox.setSelected(this.can.getPad(this.pad).getAxisY().getGrid());
        gridPanel.add(xGridBox);
        gridPanel.add(yGridBox);
        JPanel applyToAllPanel = new JPanel(new BorderLayout());
        String[] applyToAllOptions = new String[]{"Font", "Title Font Size", "Axis Title Font Size", "Axis Label Font Size", "Stat Box Font Size", "Title", "X Axis Title", "Y Axis Title", "Grid X", "Grid Y"};
        boolean[] applyToAllDefaults = new boolean[]{true, true, true, true, true, false, false, false, true, true, false, false};
        final JCheckBox[] applyToAllCheckBoxes = new JCheckBox[applyToAllOptions.length];
        for (int i = 0; i < applyToAllOptions.length; ++i) {
            applyToAllCheckBoxes[i] = new JCheckBox(applyToAllOptions[i]);
            applyToAllCheckBoxes[i].setSelected(applyToAllDefaults[i]);
        }
        JComboCheckBox applyToAllComboCheckBox = new JComboCheckBox(applyToAllCheckBoxes);
        final JToggleButton applyToAllButton = new JToggleButton("Apply To All");
        final ActionListener applyToAllListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (applyToAllButton.isSelected()) {
                    if (applyToAllCheckBoxes[0].isSelected()) {
                        OptionsPanel.this.can.setFont(systemFonts[fontsBox.getSelectedIndex()]);
                    }
                    if (applyToAllCheckBoxes[1].isSelected()) {
                        OptionsPanel.this.can.setTitleSize(Integer.parseInt(fontSize[titleFontSizeBox.getSelectedIndex()]));
                    }
                    if (applyToAllCheckBoxes[2].isSelected()) {
                        OptionsPanel.this.can.setAxisLabelSize(Integer.parseInt(fontSize[axisFontSizeBox.getSelectedIndex()]));
                    }
                    if (applyToAllCheckBoxes[3].isSelected()) {
                        OptionsPanel.this.can.setAxisTitleSize(Integer.parseInt(fontSize[axisTitleFontSizeBox.getSelectedIndex()]));
                    }
                    if (applyToAllCheckBoxes[4].isSelected()) {
                        OptionsPanel.this.can.setStatBoxFontSize(Integer.parseInt(fontSize[statBoxFontSizeBox.getSelectedIndex()]));
                    }
                    if (applyToAllCheckBoxes[5].isSelected()) {
                        OptionsPanel.this.can.setPadTitles(titleTextField.getText());
                    }
                    if (applyToAllCheckBoxes[6].isSelected()) {
                        OptionsPanel.this.can.setPadTitlesX(xAxisTextField.getText());
                    }
                    if (applyToAllCheckBoxes[7].isSelected()) {
                        OptionsPanel.this.can.setPadTitlesY(yAxisTextField.getText());
                    }
                    if (applyToAllCheckBoxes[8].isSelected()) {
                        OptionsPanel.this.can.setGridX(xGridBox.isSelected());
                    }
                    if (applyToAllCheckBoxes[9].isSelected()) {
                        OptionsPanel.this.can.setGridY(yGridBox.isSelected());
                    }
                    OptionsPanel.this.can.update();
                }
            }
        };
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                applyToAllListener.actionPerformed(new ActionEvent("", 0, ""));
            }
        };
        for (int i = 0; i < applyToAllOptions.length; ++i) {
            applyToAllCheckBoxes[i].addItemListener(itemListener);
        }
        applyToAllComboCheckBox.addActionListener(applyToAllListener);
        applyToAllButton.addActionListener(applyToAllListener);
        applyToAllPanel.add((Component)applyToAllComboCheckBox, "West");
        applyToAllPanel.add((Component)applyToAllButton, "East");
        fontsBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsPanel.this.can.getPad(OptionsPanel.this.pad).setFontNameAll(systemFonts[fontsBox.getSelectedIndex()]);
                OptionsPanel.this.can.update();
                applyToAllListener.actionPerformed(new ActionEvent("", 0, ""));
            }
        });
        axisFontSizeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsPanel.this.can.getPad(OptionsPanel.this.pad).setAxisLabelFontSize(Integer.parseInt(fontSize[axisFontSizeBox.getSelectedIndex()]));
                OptionsPanel.this.can.update();
                applyToAllListener.actionPerformed(new ActionEvent("", 0, ""));
            }
        });
        axisTitleFontSizeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsPanel.this.can.getPad(OptionsPanel.this.pad).setAxisTitleFontSize(Integer.parseInt(fontSize[axisTitleFontSizeBox.getSelectedIndex()]));
                OptionsPanel.this.can.update();
                applyToAllListener.actionPerformed(new ActionEvent("", 0, ""));
            }
        });
        titleFontSizeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsPanel.this.can.getPad(OptionsPanel.this.pad).setTitleFontSize(Integer.parseInt(fontSize[titleFontSizeBox.getSelectedIndex()]));
                OptionsPanel.this.can.update();
                applyToAllListener.actionPerformed(new ActionEvent("", 0, ""));
            }
        });
        statBoxFontSizeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsPanel.this.can.getPad(OptionsPanel.this.pad).setStatBoxFontSize(Integer.parseInt(fontSize[statBoxFontSizeBox.getSelectedIndex()]));
                OptionsPanel.this.can.update();
                applyToAllListener.actionPerformed(new ActionEvent("", 0, ""));
            }
        });
        xAxisTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsPanel.this.can.getPad(OptionsPanel.this.pad).getAxisX().setTitle(xAxisTextField.getText());
                OptionsPanel.this.can.update();
                applyToAllListener.actionPerformed(new ActionEvent("", 0, ""));
            }
        });
        xAxisTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                OptionsPanel.this.can.getPad(OptionsPanel.this.pad).getAxisX().setTitle(xAxisTextField.getText());
                OptionsPanel.this.can.update();
                applyToAllListener.actionPerformed(new ActionEvent("", 0, ""));
            }
        });
        yAxisTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsPanel.this.can.getPad(OptionsPanel.this.pad).getAxisY().setTitle(yAxisTextField.getText());
                OptionsPanel.this.can.update();
                applyToAllListener.actionPerformed(new ActionEvent("", 0, ""));
            }
        });
        yAxisTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                OptionsPanel.this.can.getPad(OptionsPanel.this.pad).getAxisY().setTitle(yAxisTextField.getText());
                OptionsPanel.this.can.update();
                applyToAllListener.actionPerformed(new ActionEvent("", 0, ""));
            }
        });
        titleTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsPanel.this.can.getPad(OptionsPanel.this.pad).setTitle(titleTextField.getText());
                OptionsPanel.this.can.update();
                applyToAllListener.actionPerformed(new ActionEvent("", 0, ""));
            }
        });
        titleTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                OptionsPanel.this.can.getPad(OptionsPanel.this.pad).setTitle(titleTextField.getText());
                OptionsPanel.this.can.update();
                applyToAllListener.actionPerformed(new ActionEvent("", 0, ""));
            }
        });
        xGridBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsPanel.this.can.getPad(OptionsPanel.this.pad).getAxisX().setGrid(xGridBox.isSelected());
                OptionsPanel.this.can.update();
                applyToAllListener.actionPerformed(new ActionEvent("", 0, ""));
            }
        });
        yGridBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsPanel.this.can.getPad(OptionsPanel.this.pad).getAxisY().setGrid(yGridBox.isSelected());
                OptionsPanel.this.can.update();
                OptionsPanel.this.can.update();
                applyToAllListener.actionPerformed(new ActionEvent("", 0, ""));
            }
        });
        int yGrid = 0;
        c.gridy = yGrid++;
        optionsPanel.add((Component)fontLabel, c);
        optionsPanel.add(fontsBox, c);
        c.gridy = yGrid++;
        optionsPanel.add((Component)titleFontSizeLabel, c);
        optionsPanel.add(titleFontSizeBox, c);
        c.gridy = yGrid++;
        optionsPanel.add((Component)axisTitleFontSizeLabel, c);
        optionsPanel.add(axisTitleFontSizeBox, c);
        c.gridy = yGrid++;
        optionsPanel.add((Component)axisFontSizeLabel, c);
        optionsPanel.add(axisFontSizeBox, c);
        c.gridy = yGrid++;
        optionsPanel.add((Component)statBoxFontSizeLabel, c);
        optionsPanel.add(statBoxFontSizeBox, c);
        c.gridy = yGrid++;
        optionsPanel.add((Component)titleLabel, c);
        optionsPanel.add((Component)titleTextField, c);
        c.gridy = yGrid++;
        optionsPanel.add((Component)titleLabel, c);
        optionsPanel.add((Component)titleTextField, c);
        c.gridy = yGrid++;
        optionsPanel.add((Component)xAxisTitleLabel, c);
        optionsPanel.add((Component)xAxisTextField, c);
        c.gridy = yGrid++;
        optionsPanel.add((Component)yAxisTitleLabel, c);
        optionsPanel.add((Component)yAxisTextField, c);
        c.gridy = yGrid++;
        optionsPanel.add((Component)xGridBox, c);
        optionsPanel.add((Component)yGridBox, c);
        c.gridy = yGrid++;
        optionsPanel.add((Component)applyToAllComboCheckBox, c);
        optionsPanel.add((Component)applyToAllButton, c);
        axisOptions.add((Component)optionsPanel, "First");
    }

    protected void applyToAll() {
    }

    private void initFrameOptions(JPanel frameOptions) {
        frameOptions.setBorder(new TitledBorder("Frame Options"));
        frameOptions.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        final JTextField xPixels = new JTextField(4);
        final JTextField yPixels = new JTextField(4);
        final JTextField ratio = new JTextField(4);
        JCheckBox lockRatio = new JCheckBox("Lock Ratio");
        double width = this.can.getSize().getWidth();
        double height = this.can.getSize().getHeight();
        xPixels.setText(String.format("%d", (int)width));
        yPixels.setText(String.format("%d", (int)height));
        ratio.setText(String.format("%.02f", width / height));
        c.gridy = 0;
        c.weightx = 1.0;
        frameOptions.add((Component)new JLabel("Width:"), c);
        frameOptions.add((Component)xPixels, c);
        frameOptions.add((Component)new JLabel("Height:"), c);
        frameOptions.add((Component)yPixels, c);
        xPixels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsPanel.this.can.setPreferredSize(new Dimension(Integer.parseInt(xPixels.getText()), Integer.parseInt(yPixels.getText())));
                OptionsPanel.this.can.setSize(Integer.parseInt(xPixels.getText()), Integer.parseInt(yPixels.getText()));
                double width = OptionsPanel.this.can.getSize().getWidth();
                double height = OptionsPanel.this.can.getSize().getHeight();
                xPixels.setText(String.format("%d", (int)width));
                yPixels.setText(String.format("%d", (int)height));
                ratio.setText(String.format("%.02f", width / height));
                JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor(OptionsPanel.this.can);
                topFrame.pack();
                OptionsPanel.this.can.update();
            }
        });
        yPixels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsPanel.this.can.setPreferredSize(new Dimension(Integer.parseInt(xPixels.getText()), Integer.parseInt(yPixels.getText())));
                OptionsPanel.this.can.setSize(Integer.parseInt(xPixels.getText()), Integer.parseInt(yPixels.getText()));
                double width = OptionsPanel.this.can.getSize().getWidth();
                double height = OptionsPanel.this.can.getSize().getHeight();
                xPixels.setText(String.format("%d", (int)width));
                yPixels.setText(String.format("%d", (int)height));
                ratio.setText(String.format("%.02f", width / height));
                JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor(OptionsPanel.this.can);
                topFrame.pack();
                OptionsPanel.this.can.update();
            }
        });
        c.gridy = 1;
        frameOptions.add((Component)new JLabel("Aspect Ratio:"), c);
        frameOptions.add((Component)ratio, c);
        frameOptions.add((Component)lockRatio, c);
        this.can.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                double width = OptionsPanel.this.can.getSize().getWidth();
                double height = OptionsPanel.this.can.getSize().getHeight();
                xPixels.setText(String.format("%d", (int)width));
                yPixels.setText(String.format("%d", (int)height));
                ratio.setText(String.format("%.02f", width / height));
                OptionsPanel.this.can.update();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    private void initAxes() {
        JTabbedPane axes = new JTabbedPane();
        AxisAttributes.AxisAttributesPane panex = new AxisAttributes.AxisAttributesPane(this.can.getPad(this.pad).getAxisFrame().getAxisX().getAttributes());
        AxisAttributes.AxisAttributesPane paney = new AxisAttributes.AxisAttributesPane(this.can.getPad(this.pad).getAxisFrame().getAxisY().getAttributes());
        panex.addAttributeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsPanel.this.can.repaint();
            }
        });
        paney.addAttributeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsPanel.this.can.repaint();
            }
        });
        axes.add("X Axis", panex);
        axes.add("Y Axis", paney);
        if (this.can.getPad(this.pad).getDatasetPlotters().size() > 0 && this.can.getPad(this.pad).getDatasetPlotters().get(0) instanceof Histogram2DPlotter) {
            AxisAttributes.AxisAttributesPane panez = new AxisAttributes.AxisAttributesPane(this.can.getPad(this.pad).getAxisFrame().getAxisZ().getAttributes());
            panez.addAttributeListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OptionsPanel.this.can.repaint();
                }
            });
            axes.add("Z Axis", panez);
        }
        this.tabbedPane.add("Axes", axes);
    }

    private void initDatasets() {
        final List<IDataSetPlotter> datasets = this.can.getPad(this.pad).getDatasetPlotters();
        final ArrayList<DatasetAttributes.DatasetAttributesPane> datasetPaneList = new ArrayList<DatasetAttributes.DatasetAttributesPane>();
        this.datasetPanes = new JTabbedPane();
        for (IDataSetPlotter dataset : datasets) {
            DatasetAttributes.DatasetAttributesPane tempPane = new DatasetAttributes.DatasetAttributesPane(dataset.getDataSet().getAttributes());
            tempPane.addAttributeListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OptionsPanel.this.can.repaint();
                }
            });
            datasetPaneList.add(tempPane);
            this.datasetPanes.add(dataset.getName(), tempPane);
            final ActionListener removeButtonListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (int i = 0; i < datasetPaneList.size(); ++i) {
                        if (!e.getSource().equals(((DatasetAttributes.DatasetAttributesPane)datasetPaneList.get((int)i)).buttonRemove)) continue;
                        int tabSelectionIndex = OptionsPanel.this.datasetPanes.getSelectedIndex();
                        OptionsPanel.this.datasetPanes.setSelectedIndex(tabSelectionIndex >= 1 ? tabSelectionIndex - 1 : 0);
                        OptionsPanel.this.datasetPanes.remove(i);
                        datasetPaneList.remove(i);
                        OptionsPanel.this.datasetPanes.repaint();
                        OptionsPanel.this.can.getPad(OptionsPanel.this.pad).remove(((IDataSetPlotter)datasets.get(i)).getDataSet());
                        break;
                    }
                    OptionsPanel.this.can.update();
                }
            };
            ActionListener defaultButtonListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (int i = 0; i < datasetPaneList.size(); ++i) {
                        if (!e.getSource().equals(((DatasetAttributes.DatasetAttributesPane)datasetPaneList.get((int)i)).buttonDefault)) continue;
                        int tabSelectionIndex = OptionsPanel.this.datasetPanes.getSelectedIndex();
                        ((IDataSetPlotter)datasets.get(i)).getDataSet().getAttributes().setDefault();
                        DatasetAttributes.DatasetAttributesPane pane = new DatasetAttributes.DatasetAttributesPane(((IDataSetPlotter)datasets.get(i)).getDataSet().getAttributes());
                        pane.buttonRemove.addActionListener(removeButtonListener);
                        pane.buttonDefault.addActionListener(this);
                        pane.addAttributeListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                OptionsPanel.this.can.repaint();
                            }
                        });
                        datasetPaneList.remove(i);
                        OptionsPanel.this.datasetPanes.setComponentAt(i, pane);
                        datasetPaneList.add(i, pane);
                        OptionsPanel.this.datasetPanes.repaint();
                        break;
                    }
                    OptionsPanel.this.can.update();
                }
            };
            tempPane.buttonRemove.addActionListener(removeButtonListener);
            tempPane.buttonDefault.addActionListener(defaultButtonListener);
        }
        this.tabbedPane.add("Datasets", this.datasetPanes);
    }
}

