/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import org.jlab.groot.ui.LatexTextTools;

public class LatexText {
    public static int ALIGN_LEFT = 0;
    public static int ALIGN_CENTER = 1;
    public static int ALIGN_RIGTH = 2;
    public static int ALIGN_TOP = 3;
    public static int ALIGN_BOTTOM = 4;
    public static int ROTATE_NONE = 11;
    public static int ROTATE_LEFT = 12;
    public static int ROTATE_RIGHT = 13;
    private String textFamily = "Avenir";
    private int textFontSize = 12;
    private Double relativeX = 0.0;
    private Double relativeY = 0.0;
    private AttributedString latexString = null;
    private String asciiString = "";
    private Integer textColor = 1;

    public LatexText(String text, double xc, double yc) {
        this.setText(text);
        this.setLocation(xc, yc);
        this.setFont(this.textFamily);
        this.setFontSize(this.textFontSize);
    }

    public LatexText(String text) {
        this.setText(text);
        this.setLocation(0.0, 0.0);
        this.setFont(this.textFamily);
        this.setFontSize(this.textFontSize);
    }

    public final void setText(String text) {
        this.asciiString = text;
        String ltx = LatexTextTools.convertUnicode(text);
        this.latexString = LatexTextTools.converSuperScript(ltx);
        this.setFont(this.textFamily);
        this.setFontSize(this.textFontSize);
    }

    public final String getTextString() {
        return this.asciiString;
    }

    public final void setLocation(double xr, double yr) {
        this.relativeX = xr;
        this.relativeY = yr;
    }

    public int getColor() {
        return this.textColor;
    }

    public void setColor(int color) {
        this.textColor = color;
    }

    public double getX() {
        return this.relativeX;
    }

    public double getY() {
        return this.relativeY;
    }

    public AttributedString getText() {
        return this.latexString;
    }

    public final void setFont(String fontname) {
        this.textFamily = fontname;
        if (this.latexString.getIterator().getEndIndex() > 0) {
            this.latexString.addAttribute(TextAttribute.FAMILY, fontname);
        }
    }

    public final void setFontSize(int size) {
        this.textFontSize = size;
        if (this.latexString.getIterator().getEndIndex() > 0) {
            this.latexString.addAttribute(TextAttribute.SIZE, Float.valueOf(size));
        }
    }

    public void drawString(Graphics2D g2d, int x, int y, int alignX, int alignY, int rotate) {
        if (rotate == ROTATE_NONE) {
            this.drawString(g2d, x, y, alignX, alignY);
            return;
        }
        FontMetrics fmg = g2d.getFontMetrics(new Font(this.textFamily, 0, this.textFontSize));
        Rectangle2D rect = fmg.getStringBounds(this.latexString.getIterator(), 0, this.latexString.getIterator().getEndIndex(), (Graphics)g2d);
        int posX = y;
        int posY = x;
        if (alignX == ALIGN_CENTER) {
            posX += (int)(0.5 * rect.getWidth());
        }
        if (alignY == ALIGN_TOP) {
            posY += (int)rect.getHeight();
        }
        AffineTransform orig = g2d.getTransform();
        g2d.rotate(-1.5707963267948966);
        g2d.setColor(Color.BLACK);
        g2d.drawString(this.latexString.getIterator(), -posX, posY);
        g2d.setTransform(orig);
    }

    public void drawString(Graphics2D g2d, int x, int y, int alignX, int alignY) {
        FontMetrics fmg = g2d.getFontMetrics(new Font(this.textFamily, 0, this.textFontSize));
        Rectangle2D rect = fmg.getStringBounds(this.latexString.getIterator(), 0, this.latexString.getIterator().getEndIndex(), (Graphics)g2d);
        int ascend = fmg.getAscent();
        int leading = fmg.getLeading();
        int xp = x;
        int yp = y + ascend;
        if (alignX == 1) {
            xp = (int)((double)xp - 0.5 * rect.getWidth());
        }
        if (alignX == 2) {
            xp = (int)((double)xp - rect.getWidth());
        }
        if (alignY == 1) {
            yp = (int)((double)y + 0.5 * (double)ascend);
        }
        if (alignY == 2) {
            yp = y;
        }
        g2d.drawString(this.latexString.getIterator(), xp, yp);
    }

    public Rectangle2D getBoundsNumber(Graphics2D g2d) {
        FontMetrics fmg = g2d.getFontMetrics(new Font(this.textFamily, 0, this.textFontSize));
        Rectangle2D rect = fmg.getStringBounds(this.latexString.getIterator(), 0, this.latexString.getIterator().getEndIndex(), (Graphics)g2d);
        return new Rectangle2D.Double(0.0, 0.0, rect.getWidth(), fmg.getAscent());
    }

    public Rectangle2D getBounds(Graphics2D g2d) {
        FontMetrics fmg = g2d.getFontMetrics(new Font(this.textFamily, 0, this.textFontSize));
        Rectangle2D rect = fmg.getStringBounds(this.latexString.getIterator(), 0, this.latexString.getIterator().getEndIndex(), (Graphics)g2d);
        return rect;
    }

    public Rectangle2D getBounds(FontMetrics fm, Graphics2D g2d) {
        FontMetrics fmg = g2d.getFontMetrics(new Font(this.textFamily, 0, this.textFontSize));
        Rectangle2D rect = fmg.getStringBounds(this.latexString.getIterator(), 0, this.latexString.getIterator().getEndIndex(), (Graphics)g2d);
        return rect;
    }

    public static LatexText createFromDouble(double number, int order) {
        String format = "%." + String.format("%df", order);
        String numString = String.format(format, number);
        return new LatexText(numString);
    }

    public static void main(String[] args) {
        LatexText lt = LatexText.createFromDouble(0.56789, 2);
    }
}

