/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jlab.groot.data.DataVector;
import org.jlab.groot.tree.Branch;
import org.jlab.groot.tree.DynamicTree;
import org.jlab.groot.tree.ITree;
import org.jlab.groot.tree.TreeCut;
import org.jlab.groot.tree.TreeExpression;
import org.jlab.groot.tree.TreeSelector;

public class Tree
implements ITree {
    private static Map<String, ImageIcon> treeNodeIcons = Tree.initTreeIcons();
    private String treeName = "tree";
    private final Map<String, Branch> treeBranches = new LinkedHashMap<String, Branch>();
    private final TreeSelector defaultSelector = new TreeSelector();
    private final List<DataVector> scanResults = new ArrayList<DataVector>();

    public Tree(String name) {
        this.treeName = name;
    }

    @Override
    public String getName() {
        return this.treeName;
    }

    public void addBranch(Branch br) {
        this.treeBranches.put(br.getName(), br);
    }

    public void addBranch(String name, String desc, String unit) {
        this.addBranch(new Branch(name, desc, unit));
    }

    @Override
    public List<String> getListOfBranches() {
        ArrayList<String> listOfBranches = new ArrayList<String>();
        for (Map.Entry<String, Branch> entry : this.treeBranches.entrySet()) {
            listOfBranches.add(entry.getKey());
        }
        return listOfBranches;
    }

    public static Map<String, ImageIcon> getTreeIcons() {
        return treeNodeIcons;
    }

    public static Map<String, ImageIcon> initTreeIcons() {
        HashMap<String, ImageIcon> iconMap = new HashMap<String, ImageIcon>();
        try {
            ImageIcon leafIcon = new ImageIcon(Tree.class.getClassLoader().getResource("icons/tree/leaf_t.png"));
            ImageIcon dirIcon = new ImageIcon(Tree.class.getClassLoader().getResource("icons/tree/tree_t.png"));
            UIManager.put("Tree.closedIcon", dirIcon);
            UIManager.put("Tree.openIcon", dirIcon);
            UIManager.put("Tree.leafIcon", leafIcon);
            UIManager.put("Tree.paintLines", Boolean.TRUE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return iconMap;
    }

    public void resetBranches(double number) {
        for (Map.Entry<String, Branch> entry : this.treeBranches.entrySet()) {
            entry.getValue().setValue(number);
        }
    }

    public float[] getBranchData() {
        float[] data = new float[this.treeBranches.size()];
        int icounter = 0;
        for (Map.Entry<String, Branch> entry : this.treeBranches.entrySet()) {
            data[icounter] = entry.getValue().getValue().floatValue();
            ++icounter;
        }
        return data;
    }

    public void setBranchData(float[] data) {
        if (data.length != this.treeBranches.size()) {
            System.out.println("[setBranchData] error. array size = " + data.length + " number of branches = " + this.treeBranches.size());
            return;
        }
        int icounter = 0;
        for (Map.Entry<String, Branch> entry : this.treeBranches.entrySet()) {
            Double value = data[icounter];
            entry.getValue().setValue(value);
            ++icounter;
        }
    }

    @Override
    public Branch getBranch(String name) {
        return this.treeBranches.get(name);
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean readNext() {
        return false;
    }

    public Map<String, Branch> getBranches() {
        return this.treeBranches;
    }

    public void print() {
        StringBuilder str = new StringBuilder();
        for (Map.Entry<String, Branch> entry : this.treeBranches.entrySet()) {
            str.append(entry.getValue().toString());
            str.append("  ");
            str.append(entry.getValue().getValue());
            str.append("\n");
        }
        System.out.println(str.toString());
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (Map.Entry<String, Branch> entry : this.treeBranches.entrySet()) {
            str.append(entry.getValue().toString());
            str.append("\n");
        }
        return str.toString();
    }

    public void show() {
        System.out.println(this.toString());
    }

    @Override
    public void configure() {
        System.out.println("[Tree] --> generic tree class does not require configuring.");
    }

    public TreeSelector getSelector() {
        return this.defaultSelector;
    }

    public DataVector getDataVector(String expression, String tcut) {
        return this.getDataVector(expression, tcut, -1);
    }

    public DataVector getDataVector(String expression, String tcut, int limit) {
        DataVector vec = new DataVector();
        int nentries = this.getEntries();
        TreeExpression exp = new TreeExpression("oper", expression, this.getListOfBranches());
        TreeCut cut = new TreeCut("cut", tcut, this.getListOfBranches());
        for (int i = 0; i < nentries; ++i) {
            this.readEntry(i);
            if (cut.isValid(this) > 0.5) {
                double result = exp.getValue(this);
                vec.add(result);
            }
            if (limit <= 0 || i <= limit) continue;
            return vec;
        }
        return vec;
    }

    public void scanTree(String expression, String tcut, int limit, boolean bothSides) {
        String[] tokens = expression.split(":");
        ArrayList<TreeExpression> texp = new ArrayList<TreeExpression>();
        this.scanResults.clear();
        for (String token : tokens) {
            TreeExpression exp = new TreeExpression(token, this.getListOfBranches());
            texp.add(exp);
            this.scanResults.add(new DataVector());
        }
        this.scanResults.add(new DataVector());
        int eventsLimit = limit;
        if (limit >= this.getEntries() || limit < 0) {
            eventsLimit = this.getEntries();
        }
        TreeCut cut = new TreeCut("cut", tcut, this.getListOfBranches());
        if (eventsLimit > 0 && bothSides) {
            double result;
            int i;
            int eventsLimitHalf = eventsLimit / 2;
            for (i = 0; i < eventsLimitHalf; ++i) {
                this.readEntry(i);
                for (int k = 0; k < texp.size(); ++k) {
                    result = ((TreeExpression)texp.get(k)).getValue(this);
                    this.scanResults.get(k).add(result);
                }
                this.scanResults.get(texp.size()).add(cut.isValid(this));
            }
            for (i = this.getEntries() - 1; i > this.getEntries() - eventsLimitHalf; --i) {
                this.readEntry(i);
                for (int k = 0; k < texp.size(); ++k) {
                    result = ((TreeExpression)texp.get(k)).getValue(this);
                    this.scanResults.get(k).add(result);
                }
                this.scanResults.get(texp.size()).add(cut.isValid(this));
            }
        } else {
            for (int i = 0; i < this.getEntries(); ++i) {
                this.readEntry(i);
                for (int k = 0; k < texp.size(); ++k) {
                    double result = ((TreeExpression)texp.get(k)).getValue(this);
                    this.scanResults.get(k).add(result);
                }
                this.scanResults.get(texp.size()).add(cut.isValid(this));
                if (i <= eventsLimit) continue;
                return;
            }
        }
    }

    public List<DataVector> getScanResults() {
        return this.scanResults;
    }

    public boolean hasBranch(String name) {
        return this.treeBranches.containsKey(name);
    }

    public DefaultMutableTreeNode getRootNode() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.getName());
        List<String> branches = this.getListOfBranches();
        for (String item : branches) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(item);
            root.add(node);
        }
        return root;
    }

    @Override
    public int getEntries() {
        return 0;
    }

    @Override
    public int readEntry(int entry) {
        return 0;
    }

    public DynamicTree getDynamicTree() {
        DynamicTree tree = new DynamicTree(this.getName());
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.getName());
        List<String> branches = this.getListOfBranches();
        for (String item : branches) {
            tree.addObject(item);
        }
        return tree;
    }
}

