/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.tree;

import java.awt.GridLayout;
import java.awt.Toolkit;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class DynamicTree
extends JPanel {
    protected DefaultMutableTreeNode rootNode;
    protected DefaultTreeModel treeModel;
    protected JTree tree;
    private Toolkit toolkit = Toolkit.getDefaultToolkit();

    public JTree getTree() {
        return this.tree;
    }

    public static void main(String[] args) {
        JFrame testFrame = new JFrame();
        DynamicTree blah = new DynamicTree("Blah");
        DefaultMutableTreeNode blah1 = blah.addObject("blah1");
        blah.addObject(blah1, "blah2");
        testFrame.add(blah);
        testFrame.pack();
        testFrame.setVisible(true);
    }

    public void setTree(JTree tree) {
        this.tree = tree;
    }

    public DynamicTree(String name) {
        super(new GridLayout(1, 0));
        this.rootNode = new DefaultMutableTreeNode(name);
        this.treeModel = new DefaultTreeModel(this.rootNode, false);
        this.treeModel.addTreeModelListener(new MyTreeModelListener());
        this.tree = new JTree(this.treeModel);
        this.tree.setEditable(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setShowsRootHandles(true);
        JScrollPane scrollPane = new JScrollPane(this.tree);
        this.add(scrollPane);
    }

    public void clear() {
        this.rootNode.removeAllChildren();
        this.treeModel.reload();
    }

    public void removeCurrentNode() {
        DefaultMutableTreeNode currentNode;
        MutableTreeNode parent;
        TreePath currentSelection = this.tree.getSelectionPath();
        if (currentSelection != null && (parent = (MutableTreeNode)(currentNode = (DefaultMutableTreeNode)currentSelection.getLastPathComponent()).getParent()) != null) {
            this.treeModel.removeNodeFromParent(currentNode);
            return;
        }
        this.toolkit.beep();
    }

    public DefaultMutableTreeNode addObject(Object child) {
        DefaultMutableTreeNode parentNode = this.rootNode;
        return this.addObject(parentNode, child, true);
    }

    public DefaultMutableTreeNode addObject(DefaultMutableTreeNode parent, Object child) {
        return this.addObject(parent, child, false);
    }

    public DefaultMutableTreeNode addObject(DefaultMutableTreeNode parent, Object child, boolean shouldBeVisible) {
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(child);
        if (parent == null) {
            parent = this.rootNode;
        }
        this.treeModel.insertNodeInto(childNode, parent, parent.getChildCount());
        if (shouldBeVisible) {
            // empty if block
        }
        this.tree.setSelectionPath(new TreePath(childNode.getPath()));
        return childNode;
    }

    class MyTreeModelListener
    implements TreeModelListener {
        MyTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getTreePath().getLastPathComponent();
            int index = e.getChildIndices()[0];
            node = (DefaultMutableTreeNode)node.getChildAt(index);
            System.out.println("The user has finished editing the node.");
            System.out.println("New value: " + node.getUserObject());
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
        }
    }
}

