/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.math;

public class StatNumber {
    private double number;
    private double error;

    public StatNumber() {
        this.number = 0.0;
        this.error = 0.0;
    }

    public StatNumber(double num, double err) {
        this.number = num;
        this.error = err;
    }

    public StatNumber(double num) {
        this.number = num;
        this.error = Math.sqrt(Math.abs(num));
    }

    public void set(double num, double err) {
        this.number = num;
        this.error = err;
    }

    public double number() {
        return this.number;
    }

    public double error() {
        return this.error;
    }

    public void add(StatNumber num) {
        this.number += num.number();
        this.error = Math.sqrt(this.error * this.error + num.error() * num.error());
    }

    public void divide(StatNumber num) {
        double _fnum = 0.0;
        if (num.number() != 0.0) {
            _fnum = this.number() / num.number();
        }
        double _n1 = this.number();
        double _n2 = num.number();
        double _e1 = this.error();
        double _e2 = num.error();
        double _r12 = 0.0;
        double _r22 = 0.0;
        if (_n1 != 0.0) {
            _r12 = _e1 / _n1 * (_e1 / _n1);
        }
        if (_n2 != 0.0) {
            _r22 = _e2 / _n2 * (_e2 / _n2);
        }
        this.number = _fnum;
        this.error = _fnum * Math.sqrt(_r12 + _r22);
    }

    public void multiply(StatNumber num) {
        double _fnum = this.number() * num.number();
        double _n1 = this.number();
        double _n2 = num.number();
        double _e1 = this.error();
        double _e2 = num.error();
        double _r12 = 0.0;
        double _r22 = 0.0;
        if (_n1 != 0.0) {
            _r12 = _e1 / _n1 * (_e1 / _n1);
        }
        if (_n2 != 0.0) {
            _r22 = _e2 / _n2 * (_e2 / _n2);
        }
        this.number = _fnum;
        this.error = _fnum * Math.sqrt(_r12 + _r22);
    }

    public void subtract(StatNumber num) {
        this.number -= num.number();
        this.error = Math.sqrt(this.error * this.error + num.error() * num.error());
    }
}

