/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.graphics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import org.jlab.groot.base.GStyle;
import org.jlab.groot.base.PadMargins;
import org.jlab.groot.graphics.GraphicsAxis;
import org.jlab.groot.math.Dimension2D;

public class GraphicsAxisFrame {
    private Dimension2D axisFrameDimension = new Dimension2D();
    private PadMargins axisFrameMargins = new PadMargins();
    private List<GraphicsAxis> axisFrameAxis = new ArrayList<GraphicsAxis>();
    private boolean drawAxisZ = false;
    private boolean drawFrame = true;
    private int colorAxisOffset = 4;
    private int colorAxisSize = 8;

    public GraphicsAxisFrame() {
        this.axisFrameAxis.add(new GraphicsAxis(GraphicsAxis.AXISTYPE_HORIZONTAL));
        this.axisFrameAxis.add(new GraphicsAxis(GraphicsAxis.AXISTYPE_VERTICAL));
        this.axisFrameAxis.add(new GraphicsAxis(GraphicsAxis.AXISTYPE_COLOR));
    }

    public Dimension2D getFrameDimensions() {
        return this.axisFrameDimension;
    }

    public void setFrameDimensions(double xmin, double xmax, double ymin, double ymax) {
        this.axisFrameDimension.getDimension(0).setMinMax(xmin, xmax);
        this.axisFrameDimension.getDimension(1).setMinMax(ymin, ymax);
        this.axisFrameAxis.get(0).setDimension((int)xmin, (int)xmax);
        this.axisFrameAxis.get(1).setDimension((int)ymax, (int)ymin);
    }

    public void updateMargins(Graphics2D g2d) {
        double xoffset = this.axisFrameAxis.get(1).getAxisBounds(g2d);
        double yoffset = this.axisFrameAxis.get(0).getAxisBounds(g2d);
        this.axisFrameMargins.setLeftMargin((int)xoffset);
        this.axisFrameMargins.setBottomMargin((int)yoffset);
        this.axisFrameMargins.setTopMargin(10);
        this.axisFrameMargins.setRightMargin(15);
        if (this.drawAxisZ) {
            double zoffset = this.axisFrameAxis.get(2).getAxisBounds(g2d);
            double length = 15.0 + zoffset + (double)this.colorAxisOffset + (double)this.colorAxisSize;
            this.axisFrameMargins.setRightMargin((int)length);
        }
    }

    public PadMargins getFrameMargins() {
        return this.axisFrameMargins;
    }

    public void setAxisMargins(PadMargins margins) {
        double xcorner = this.axisFrameDimension.getDimension(0).getMin() + (double)margins.getLeftMargin();
        double ycorner = this.axisFrameDimension.getDimension(1).getMax() - (double)margins.getBottomMargin();
        this.axisFrameAxis.get(0).setDimension((int)xcorner, (int)(this.axisFrameDimension.getDimension(0).getMax() - (double)margins.getRightMargin()));
        this.axisFrameAxis.get(1).setDimension((int)ycorner, (int)(this.axisFrameDimension.getDimension(1).getMin() + (double)margins.getTopMargin()));
        this.axisFrameAxis.get(2).setDimension((int)ycorner, (int)(this.axisFrameDimension.getDimension(1).getMin() + (double)margins.getTopMargin()));
    }

    public void drawAxis(Graphics2D g2d, PadMargins margins) {
        double xcorner = this.axisFrameDimension.getDimension(0).getMin() + (double)margins.getLeftMargin();
        double ycorner = this.axisFrameDimension.getDimension(1).getMax() - (double)margins.getBottomMargin();
        g2d.setColor(Color.BLACK);
        g2d.setStroke(new BasicStroke(1.0f));
        if (this.drawFrame) {
            g2d.drawRect((int)this.getAxisX().getDimension().getMin(), (int)this.getAxisY().getDimension().getMax(), (int)this.getAxisX().getDimension().getLength(), (int)Math.abs(this.getAxisY().getDimension().getLength()));
        }
        if (this.axisFrameAxis.get(0).getAttributes().showAxis()) {
            this.axisFrameAxis.get(0).drawAxis(g2d, (int)xcorner, (int)ycorner, (int)Math.abs(this.getAxisY().getDimension().getLength()));
        }
        if (this.axisFrameAxis.get(1).getAttributes().showAxis()) {
            this.axisFrameAxis.get(1).drawAxis(g2d, (int)xcorner, (int)ycorner, (int)this.getAxisX().getDimension().getLength());
        }
        if (this.axisFrameAxis.get(2).getAttributes().showAxis()) {
            int xc = (int)this.axisFrameDimension.getDimension(0).getMax() - this.axisFrameMargins.getRightMargin();
            this.axisFrameAxis.get(2).drawAxis(g2d, xc, (int)ycorner);
        }
        g2d.setColor(Color.BLACK);
        int lineWidth = GStyle.getGraphicsFrameLineWidth();
        g2d.setStroke(new BasicStroke(lineWidth));
        if (this.drawFrame) {
            g2d.drawRect((int)this.getAxisX().getDimension().getMin(), (int)this.getAxisY().getDimension().getMax(), (int)this.getAxisX().getDimension().getLength(), (int)Math.abs(this.getAxisY().getDimension().getLength()));
        }
    }

    public void setDrawAxisZ(boolean flag) {
        this.drawAxisZ = flag;
    }

    public boolean isDrawFrame() {
        return this.drawFrame;
    }

    public void setDrawFrame(boolean drawFrame) {
        this.drawFrame = drawFrame;
    }

    public GraphicsAxis getAxisX() {
        return this.axisFrameAxis.get(0);
    }

    public GraphicsAxis getAxisY() {
        return this.axisFrameAxis.get(1);
    }

    public GraphicsAxis getAxisZ() {
        return this.axisFrameAxis.get(2);
    }

    public int getAxisPointX(double value) {
        return (int)this.axisFrameAxis.get(0).getAxisPosition(value);
    }

    public int getAxisPointY(double value) {
        return (int)this.axisFrameAxis.get(1).getAxisPosition(value);
    }

    public int getAxisPointZ(double value) {
        return (int)this.axisFrameAxis.get(2).getAxisPosition(value);
    }
}

