/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.fitter;

import org.freehep.math.minuit.FCNBase;
import org.jlab.groot.data.GraphErrors;
import org.jlab.groot.data.H1F;
import org.jlab.groot.data.IDataSet;
import org.jlab.groot.math.Func1D;

public class FitterFunction
implements FCNBase {
    private Func1D function = null;
    private IDataSet dataset = null;
    private String fitOptions = "";
    private int numberOfCalls = 0;
    private long startTime = 0L;
    private long endTime = 0L;

    public FitterFunction(Func1D func, IDataSet data) {
        this.dataset = data;
        this.function = func;
        if (data instanceof H1F) {
            H1F h = (H1F)data;
            h.setFunction(func);
        }
        this.startTime = System.currentTimeMillis();
    }

    public FitterFunction(Func1D func, IDataSet data, String options) {
        this.dataset = data;
        this.function = func;
        this.fitOptions = options;
        if (data instanceof H1F) {
            H1F h = (H1F)data;
            h.setFunction(func);
        }
        if (data instanceof GraphErrors) {
            GraphErrors graph = (GraphErrors)data;
            graph.setFunction(func);
        }
        this.startTime = System.currentTimeMillis();
    }

    public Func1D getFunction() {
        return this.function;
    }

    public double valueOf(double[] pars) {
        double chi2 = 0.0;
        this.function.setParameters(pars);
        chi2 = this.getChi2(pars, this.fitOptions);
        ++this.numberOfCalls;
        this.function.setChiSquare(chi2);
        this.endTime = System.currentTimeMillis();
        return chi2;
    }

    public double getChi2(double[] pars, String options) {
        double chi2 = 0.0;
        int npoints = this.dataset.getDataSize(0);
        this.function.setParameters(pars);
        int ndf = 0;
        for (int np = 0; np < npoints; ++np) {
            double x = this.dataset.getDataX(np);
            double y = this.dataset.getDataY(np);
            double yerr = this.dataset.getDataEY(np);
            boolean usePoint = true;
            if (this.dataset instanceof H1F && y == 0.0) {
                usePoint = false;
            }
            if (!(x >= this.function.getMin()) || !(x <= this.function.getMax()) || !usePoint) continue;
            double yv = this.function.evaluate(x);
            double normalization = yerr * yerr;
            if (options.contains("N")) {
                normalization = Math.abs(y);
            }
            if (options.contains("W")) {
                normalization = 1.0;
            }
            if (!(Math.abs(normalization) > 1.0E-12)) continue;
            chi2 += (yv - y) * (yv - y) / normalization;
            ++ndf;
        }
        int npars = this.function.getNPars();
        this.function.setNDF(ndf - npars);
        return chi2;
    }

    public String getBenchmarkString() {
        StringBuilder str = new StringBuilder();
        double time = this.endTime - this.startTime;
        str.append(String.format("[fit-benchmark] Time = %.3f , Iterrations = %d", time / 1000.0, this.numberOfCalls));
        return str.toString();
    }
}

