/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.data;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jlab.groot.data.DataSetSerializer;
import org.jlab.groot.data.Directory;
import org.jlab.groot.data.H1F;
import org.jlab.groot.data.IDataSet;
import org.jlab.groot.group.DataGroup;
import org.jlab.groot.group.DataGroupDescriptor;
import org.jlab.hipo.data.HipoEvent;
import org.jlab.hipo.data.HipoNode;
import org.jlab.hipo.io.HipoReader;
import org.jlab.hipo.io.HipoWriter;

public class TDirectory
extends Directory<IDataSet> {
    Map<String, DataGroupDescriptor> groupDescriptors = new LinkedHashMap<String, DataGroupDescriptor>();

    public void addGroupDescriptor(String name, int cols, int rows) {
        this.groupDescriptors.put(name, new DataGroupDescriptor(name, cols, rows));
    }

    public void addGroup(String name, int order, String dataset) {
        if (this.groupDescriptors.containsKey(name)) {
            this.groupDescriptors.get(name).add(order, dataset);
        } else {
            System.out.println("[TDirectory] --> error : data group descriptos does not exist [" + name + "]");
        }
    }

    public DataGroup getDataGroup(String name) {
        DataGroupDescriptor desc = this.groupDescriptors.get(name);
        DataGroup group = new DataGroup(name, desc.getCols(), desc.getRows());
        int groupSize = desc.getCols() * desc.getRows();
        for (int i = 0; i < groupSize; ++i) {
            List<String> items = desc.getList(i);
            String encoded = desc.getEncodedString(i);
            for (String item : items) {
                IDataSet ds = (IDataSet)this.getObject(item);
                if (ds == null) continue;
                group.addDataSet(ds, i);
            }
        }
        return group;
    }

    public void addDataSet(IDataSet ... dataSets) {
        for (IDataSet ds : dataSets) {
            this.add(ds.getName(), ds);
        }
    }

    public void writeFile(String filename) {
        HipoWriter writer = new HipoWriter();
        writer.setCompressionType(1);
        writer.open(filename);
        List<String> objectList = this.getCompositeObjectList(this);
        for (String string : objectList) {
            IDataSet ds = (IDataSet)this.getObject(string);
            if (ds != null) {
                ds.setName(string);
                List<HipoNode> nodes = DataSetSerializer.serializeDataSet(ds);
                HipoEvent event = new HipoEvent();
                event.addNodes(nodes);
                writer.writeEvent(event.getDataBuffer());
                continue;
            }
            System.out.println("[TDirectory::writeFile] error getting object : " + string);
        }
        System.out.println("---> writing data group descriptors, size = " + this.groupDescriptors.size());
        for (Map.Entry entry : this.groupDescriptors.entrySet()) {
            List<HipoNode> nodes = DataSetSerializer.serializeDataGroupDescriptor((DataGroupDescriptor)entry.getValue());
            HipoEvent event = new HipoEvent();
            event.addNodes(nodes);
            event.updateNodeIndex();
            System.out.println(event);
            writer.writeEvent(event.getDataBuffer());
        }
        writer.close();
    }

    public static void addFiles(String outputFile, List<String> inputFiles) {
        TDirectory dir = new TDirectory();
        dir.readFile(inputFiles.get(0));
        List<String> objectList = dir.getCompositeObjectList(dir);
        System.out.println("********* OBJECT LIST ***********");
        for (String object : objectList) {
            System.out.println("-> " + object);
        }
        System.out.println("******* END OBJECT LIST *********");
        for (int loop = 1; loop < inputFiles.size(); ++loop) {
            TDirectory inDir = new TDirectory();
            inDir.readFile(inputFiles.get(loop));
            for (String object : objectList) {
                try {
                    IDataSet dataset = (IDataSet)dir.getObject(object);
                    if (!(dataset instanceof H1F)) continue;
                    H1F h1 = (H1F)dataset;
                    H1F h2 = (H1F)inDir.getObject(object);
                    if (h2 == null) continue;
                    h1.add(h2);
                }
                catch (Exception e) {
                    System.out.println("--> error with dataset : " + object);
                }
            }
        }
        dir.writeFile(outputFile);
    }

    public void readFile(String filename) {
        HipoReader reader = new HipoReader();
        reader.open(filename);
        this.clear();
        this.groupDescriptors.clear();
        int nevents = reader.getEventCount();
        for (int i = 0; i < nevents; ++i) {
            byte[] eventBuffer = reader.readEvent(i);
            HipoEvent event = new HipoEvent(eventBuffer);
            if (event.hasGroup(1200)) {
                System.out.println("--> reading data group descriptor");
                System.out.println(event);
                DataGroupDescriptor desc = DataSetSerializer.deserializeDataGroupDescriptor(event);
                this.groupDescriptors.put(desc.getName(), desc);
                continue;
            }
            IDataSet h1 = DataSetSerializer.deserializeDataSet(event);
            String h1name = h1.getName();
            String dirname = this.stringDirectoryFromPath(h1name);
            this.mkdir(dirname);
            this.cd(dirname);
            h1.setName(this.stringObjectFromPath(h1name));
            this.addDataSet(h1);
            this.ls();
        }
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("error: \n\n Usage : hadd [outputfile] [input1] [input2] ....\n\n");
            System.exit(0);
        }
        String outputFile = args[0];
        ArrayList<String> inputFiles = new ArrayList<String>();
        for (int i = 1; i < args.length; ++i) {
            inputFiles.add(args[i]);
        }
        TDirectory.addFiles(outputFile, inputFiles);
    }
}

