/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.base;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.jlab.groot.ui.GraphicsAxis;
import org.jlab.groot.ui.LatexText;

public class ColorPalette {
    double[] red = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.17, 0.33, 0.5, 0.67, 0.83, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    double[] green = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.08, 0.15, 0.23, 0.31, 0.38, 0.46, 0.53, 0.59, 0.66, 0.73, 0.8, 0.87, 0.72, 0.58, 0.43, 0.29, 0.14, 0.0, 0.08, 0.17, 0.25, 0.33, 0.42, 0.5, 0.58, 0.67, 0.75, 0.83, 0.92, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    double[] blue = new double[]{0.3, 0.33, 0.36, 0.39, 0.42, 0.45, 0.48, 0.52, 0.56, 0.6, 0.64, 0.68, 0.68, 0.7, 0.7, 0.7, 0.7, 0.64, 0.56, 0.48, 0.4, 0.33, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.17, 0.33, 0.5, 0.67, 0.83, 1.0};
    public static double[] red3D = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.17, 0.33, 0.5, 0.67, 0.83, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    public static double[] green3D = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.08, 0.15, 0.23, 0.31, 0.38, 0.46, 0.53, 0.59, 0.66, 0.73, 0.8, 0.87, 0.72, 0.58, 0.43, 0.29, 0.14, 0.0, 0.08, 0.17, 0.25, 0.33, 0.42, 0.5, 0.58, 0.67, 0.75, 0.83, 0.92, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    public static double[] blue3D = new double[]{0.3, 0.33, 0.36, 0.39, 0.42, 0.45, 0.48, 0.52, 0.56, 0.6, 0.64, 0.68, 0.68, 0.7, 0.7, 0.7, 0.7, 0.64, 0.56, 0.48, 0.4, 0.33, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.17, 0.33, 0.5, 0.67, 0.83, 1.0};
    private final ArrayList<Color> palette = new ArrayList();
    private static TreeMap<Integer, Color> colorPalette = ColorPalette.initColorMap();
    private int axisTickSize = 4;
    private int axisStringOffset = 8;
    private static List<Color> colorPalette3D = ColorPalette.generateColorPalette3D();

    public ColorPalette() {
        this.set(3);
    }

    public void ColorPalette(int mode) {
        this.set(mode);
    }

    public final void set(int mode) {
        if (mode == 1) {
            this.palette.clear();
            this.palette.add(new Color(0, 0, 144));
            this.palette.add(new Color(0, 15, 255));
            this.palette.add(new Color(0, 144, 255));
            this.palette.add(new Color(15, 255, 238));
            this.palette.add(new Color(144, 255, 112));
            this.palette.add(new Color(255, 238, 0));
            this.palette.add(new Color(255, 112, 0));
            this.palette.add(new Color(238, 0, 0));
            this.palette.add(new Color(127, 0, 0));
        }
        if (mode == 2) {
            this.palette.clear();
            this.palette.add(new Color(255, 0, 0));
            this.palette.add(new Color(255, 15, 0));
            this.palette.add(new Color(255, 67, 0));
            this.palette.add(new Color(255, 110, 0));
            this.palette.add(new Color(255, 132, 0));
            this.palette.add(new Color(255, 160, 0));
            this.palette.add(new Color(255, 187, 0));
            this.palette.add(new Color(255, 215, 0));
            this.palette.add(new Color(255, 240, 0));
            this.palette.add(new Color(250, 255, 0));
            this.palette.add(new Color(250, 255, 85));
            this.palette.add(new Color(250, 255, 155));
            this.palette.add(new Color(250, 255, 224));
        }
        if (mode == 3) {
            this.palette.clear();
            for (int loop = 0; loop < this.red.length; ++loop) {
                int pred = (int)(255.0 * this.red[loop]);
                int pgreen = (int)(255.0 * this.green[loop]);
                int pblue = (int)(255.0 * this.blue[loop]);
                this.palette.add(new Color(pred, pgreen, pblue));
            }
        }
    }

    public static int getColorPallete3DSize() {
        return colorPalette3D.size();
    }

    public static Color getColorPalette3D(int index) {
        return colorPalette3D.get(index);
    }

    public static List<Color> generateColorPalette3D() {
        ArrayList<Color> palette = new ArrayList<Color>();
        palette.clear();
        for (int loop = 0; loop < red3D.length; ++loop) {
            int pred = (int)(255.0 * red3D[loop]);
            int pgreen = (int)(255.0 * green3D[loop]);
            int pblue = (int)(255.0 * blue3D[loop]);
            palette.add(new Color(pred, pgreen, pblue));
        }
        return palette;
    }

    public Color getColor3D(int bin) {
        return this.palette.get(bin);
    }

    public int getColor3DSize() {
        return this.palette.size();
    }

    public Color getColor3D(double value, double max, boolean islog) {
        double fraction = 0.0;
        if (max != 0.0) {
            fraction = islog ? Math.log(value + 1.0) / Math.log(max) : value / max;
        }
        if (fraction > 1.0) {
            fraction = 1.0;
        }
        if (fraction <= 0.0) {
            return new Color(200, 200, 200);
        }
        double binC = fraction * (double)this.palette.size();
        int bin = (int)binC;
        if (bin >= this.palette.size()) {
            bin = this.palette.size() - 1;
        }
        return this.palette.get(bin);
    }

    public Color getRange(double fraction) {
        if (fraction > 1.0) {
            fraction = 1.0;
        }
        if (fraction < 0.0) {
            return new Color(0, 0, 0);
        }
        double binC = fraction * (double)this.palette.size();
        int bin = (int)binC;
        if (bin >= this.palette.size()) {
            bin = this.palette.size() - 1;
        }
        return this.palette.get(bin);
    }

    public static void setColor(int color, int red, int green, int blue, int alpha) {
        colorPalette.put(color, new Color(red, green, blue, alpha));
    }

    public static void setColor(int color, int red, int green, int blue) {
        colorPalette.put(color, new Color(red, green, blue));
    }

    public static Color getColor(int color) {
        return colorPalette.get(color);
    }

    public static TreeMap<Integer, Color> initColorMap() {
        TreeMap<Integer, Color> colors = new TreeMap<Integer, Color>();
        colors.put(0, Color.white);
        colors.put(1, Color.BLACK);
        colors.put(2, new Color(210, 79, 68));
        colors.put(3, new Color(137, 216, 68));
        colors.put(4, new Color(77, 176, 221));
        colors.put(5, new Color(246, 188, 47));
        colors.put(6, new Color(222, 82, 111));
        colors.put(7, new Color(230, 130, 58));
        colors.put(8, new Color(90, 207, 161));
        colors.put(9, new Color(106, 120, 203));
        for (int loop = 0; loop < 10; ++loop) {
            colors.put(20 + loop, ColorPalette.getTranslucent(colors.get(loop), 200));
            colors.put(30 + loop, ColorPalette.getTranslucent(colors.get(loop), 160));
            colors.put(40 + loop, ColorPalette.getTranslucent(colors.get(loop), 120));
            colors.put(50 + loop, ColorPalette.getTranslucent(colors.get(loop), 50));
        }
        return colors;
    }

    private static Color getTranslucent(Color col, int alpha) {
        return new Color(col.getRed(), col.getGreen(), col.getBlue(), alpha);
    }

    public int getAxisWidth(Graphics2D g2d, int x, int y, int width, int height, double axismin, double axismax, Boolean logFlag) {
        GraphicsAxis zAxis = new GraphicsAxis();
        zAxis.setLog(logFlag);
        zAxis.setDimension(y, y + height);
        zAxis.setRange(axismin, axismax);
        int axisLength = zAxis.getSize(g2d, true);
        return width + this.axisStringOffset + axisLength + this.axisTickSize;
    }

    public void draw(Graphics2D g2d, int x, int y, int width, int height, double axismin, double axismax, Boolean logFlag) {
        GraphicsAxis zAxis = new GraphicsAxis();
        zAxis.setLog(logFlag);
        zAxis.setDimension(y, y + height);
        zAxis.setRange(axismin, axismax);
        int ncolors = this.getColor3DSize();
        for (int i = 0; i < ncolors; ++i) {
            g2d.setColor(this.getColor3D(i));
            int yp = (int)((double)i * (double)height / (double)ncolors);
            int offset = (int)((double)(i + 1) * (double)height / (double)ncolors);
            int length = offset - yp;
            g2d.fillRect(x, y + height - yp - length, width, offset - yp + 1);
        }
        g2d.setColor(Color.BLACK);
        g2d.drawRect(x, y, width, height);
        List<Double> axisTicks = zAxis.getAxisTicks();
        List<LatexText> axisTexts = zAxis.getAxisLabels();
        for (int i = 0; i < axisTicks.size(); ++i) {
            int xc = x + width;
            int yc = (int)(zAxis.getDimension().getMin() + zAxis.getDimension().getMax() - zAxis.getAxisPosition(axisTicks.get(i)));
            g2d.drawLine(xc, yc, xc + 4, yc);
            axisTexts.get(i).drawString(g2d, xc + 8, yc, 0, 1);
        }
    }
}

