/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.LegacyQTTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;

public class LegacyPictReader
extends FormatReader {
    private static LegacyQTTools qtTools = new LegacyQTTools();

    public LegacyPictReader() {
        super("PICT", "pict");
    }

    public boolean isThisType(byte[] block) {
        return false;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        buf = ImageTools.getBytes(this.openImage(no), false, 3);
        return buf;
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        int r;
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        RandomAccessStream fin = new RandomAccessStream(this.currentId);
        int len = (int)(fin.length() - 512L);
        byte[] bytes = new byte[len];
        fin.skip(512L);
        int read = 0;
        for (int left = len; left > 0; left -= r) {
            r = fin.read(bytes, read, left);
            read += r;
        }
        fin.close();
        return ImageTools.makeBuffered(qtTools.pictToImage(bytes));
    }

    public void close(boolean fileOnly) throws IOException {
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("LegacyPictReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.status("Populating metadata");
        BufferedImage img = this.openImage(0);
        this.core.sizeX[0] = img.getWidth();
        this.core.sizeY[0] = img.getHeight();
        this.core.sizeZ[0] = 1;
        this.core.sizeC[0] = img.getRaster().getNumBands();
        this.core.sizeT[0] = 1;
        this.core.pixelType[0] = 0;
        this.core.currentOrder[0] = "XYCZT";
        this.core.rgb[0] = this.core.sizeC[0] > 1;
        this.core.interleaved[0] = false;
        this.core.imageCount[0] = 1;
        this.core.littleEndian[0] = false;
        this.core.indexed[0] = false;
        this.core.falseColor[0] = false;
        MetadataStore store = this.getMetadataStore();
        store.setImage(this.currentId, null, null, null);
        FormatTools.populatePixels(store, this);
        for (int i = 0; i < this.core.sizeC[0]; ++i) {
            store.setLogicalChannel(i, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }
    }
}

