/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.BaseType;
import dods.dap.BaseTypePrimitiveVector;
import dods.dap.ClientIO;
import dods.dap.DataReadException;
import dods.dap.PrimitiveVector;
import dods.dap.ServerVersion;
import dods.dap.StatusUI;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;

public abstract class DVector
extends BaseType
implements ClientIO {
    private PrimitiveVector vals;

    public DVector() {
    }

    public String getTypeName() {
        return "Vector";
    }

    public DVector(String n) {
        super(n);
    }

    public Object clone() {
        DVector v = (DVector)super.clone();
        v.vals = (PrimitiveVector)this.vals.clone();
        return v;
    }

    public int getLength() {
        if (this.vals == null) {
            return 0;
        }
        return this.vals.getLength();
    }

    public void setLength(int len) {
        this.vals.setLength(len);
    }

    public void addVariable(BaseType v) {
        this.vals = v.newPrimitiveVector();
        this.setName(v.getName());
    }

    public PrimitiveVector getPrimitiveVector() {
        return this.vals;
    }

    public void printDecl(PrintWriter os, String space, boolean print_semi, boolean constrained) {
        os.print(space + this.getTypeName());
        this.vals.printDecl(os, " ", print_semi, constrained);
    }

    public void printVal(PrintWriter os, String space, boolean print_decl_p) {
        if (print_decl_p) {
            this.printDecl(os, space, false);
            os.print(" = ");
        }
        os.print("{ ");
        this.vals.printVal(os, "");
        if (print_decl_p) {
            os.println("};");
        } else {
            os.print("}");
        }
    }

    public synchronized void deserialize(DataInputStream source, ServerVersion sv, StatusUI statusUI) throws IOException, EOFException, DataReadException {
        int length2;
        int length = source.readInt();
        if (!(this.vals instanceof BaseTypePrimitiveVector) && length != (length2 = source.readInt())) {
            throw new DataReadException("Inconsistent array length read: " + length + " != " + length2);
        }
        if (length < 0) {
            throw new DataReadException("Negative array length read.");
        }
        if (statusUI != null) {
            statusUI.incrementByteCount(8);
        }
        this.vals.setLength(length);
        this.vals.deserialize(source, sv, statusUI);
    }

    public void externalize(DataOutputStream sink) throws IOException {
        int length = this.vals.getLength();
        sink.writeInt(length);
        if (!(this.vals instanceof BaseTypePrimitiveVector)) {
            sink.writeInt(length);
        }
        this.vals.externalize(sink);
    }
}

