/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.util;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class WindowIterator<T>
implements Iterator<List<T>> {
    private final Iterator<T> iterator;
    private final Deque<T> window;

    public WindowIterator(Iterator<T> iterator, int windowSize) {
        this.iterator = iterator;
        this.window = new LinkedList<T>();
        this.window.add(null);
        for (int windowIndex = 0; windowIndex < windowSize - 1; ++windowIndex) {
            this.window.add(iterator.next());
        }
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public List<T> next() {
        this.window.removeFirst();
        this.window.add(this.iterator.next());
        return new LinkedList<T>(this.window);
    }

    @Override
    public void remove() {
    }
}

