/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class StatefulTokenizer {
    protected static final String INITIAL_STATE = "";
    private final Set<Object> joinedTypes = new HashSet<Object>();
    private final Set<Object> ignoredTypes = new HashSet<Object>();
    private final Map<String, Rule[]> grammar = new HashMap<String, Rule[]>();

    protected StatefulTokenizer() {
    }

    protected void addJoinedType(Object tokenType) {
        this.joinedTypes.add(tokenType);
    }

    protected void addIgnoredType(Object tokenType) {
        this.ignoredTypes.add(tokenType);
    }

    protected void putRules(Rule ... rules) {
        this.putRules(INITIAL_STATE, rules);
    }

    protected void putRules(String name, Rule ... rules) {
        this.grammar.put(name, rules);
    }

    public List<Token> tokenize(String data) {
        LinkedList<Token> tokens = new LinkedList<Token>();
        Stack<String> states = new Stack<String>();
        states.push(INITIAL_STATE);
        int pos = 0;
        Token tokenCur = null;
        block0: while (pos < data.length() && !states.isEmpty()) {
            Rule[] rules;
            String state = (String)states.peek();
            for (Rule rule : rules = this.grammar.get(state)) {
                Token token = rule.getToken(data, pos);
                if (token == null) continue;
                if (tokenCur != null && tokenCur.type.equals(token.type) && this.joinedTypes.contains(tokenCur.type)) {
                    tokenCur.append(token);
                } else {
                    if (tokenCur != null && !this.ignoredTypes.contains(tokenCur.type)) {
                        tokens.add(tokenCur);
                    }
                    tokenCur = token;
                }
                pos = token.end;
                if ("#pop".equals(rule.nextState)) {
                    states.pop();
                    continue block0;
                }
                if (rule.nextState == null) continue block0;
                states.push(rule.nextState);
                continue block0;
            }
        }
        if (tokenCur != null && !this.ignoredTypes.contains(tokenCur.type)) {
            tokens.add(tokenCur);
        }
        return tokens;
    }

    protected static class Rule {
        private final Pattern pattern;
        private final Object tokenType;
        private final String nextState;

        public Rule(String pattern, Object tokenType, String nextState) {
            this.pattern = Pattern.compile(pattern);
            this.tokenType = tokenType;
            this.nextState = nextState;
        }

        public Rule(String pattern, Object tokenType) {
            this(pattern, tokenType, null);
        }

        public Token getToken(String data, int pos) {
            Matcher m = this.pattern.matcher(data);
            m.region(pos, data.length());
            if (!m.lookingAt()) {
                return null;
            }
            String content = m.groupCount() > 0 ? m.group(1) : m.group();
            Token token = new Token(m.start(), m.end(), this.tokenType, content);
            return token;
        }
    }

    public static class Token {
        private final int start;
        private int end;
        private final Object type;
        private final StringBuilder content = new StringBuilder();

        public Token(int start, int end, Object type, String content) {
            this.start = start;
            this.end = end;
            this.type = type;
            this.content.append(content);
        }

        public void append(Token t) {
            this.content.append((CharSequence)t.content);
            this.end = t.end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public Object getType() {
            return this.type;
        }

        public String getContent() {
            return this.content.toString();
        }

        public String toString() {
            return String.format("%s[start=%d, end=%d, type=%s, content=\"%s\"]", this.getClass().getSimpleName(), this.getStart(), this.getEnd(), this.getType(), this.getContent());
        }
    }
}

