/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.lines;

import de.erichseifert.gral.graphics.AbstractDrawable;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.DrawingContext;
import de.erichseifert.gral.plots.DataPoint;
import de.erichseifert.gral.plots.lines.AbstractLineRenderer2D;
import de.erichseifert.gral.util.GraphicsUtils;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.List;

public class SmoothLineRenderer2D
extends AbstractLineRenderer2D {
    private static final long serialVersionUID = -6390029474886495264L;
    private Number smoothness = 1.0;

    @Override
    public Drawable getLine(List<DataPoint> points, final Shape shape) {
        AbstractDrawable d = new AbstractDrawable(){
            private static final long serialVersionUID = 3641589240264518755L;

            @Override
            public void draw(DrawingContext context) {
                Paint paint = SmoothLineRenderer2D.this.getColor();
                GraphicsUtils.fillPaintedShape(context.getGraphics(), shape, paint, null);
            }
        };
        return d;
    }

    @Override
    public Shape getLineShape(List<DataPoint> points) {
        double smoothness = this.getSmoothness().doubleValue();
        Path2D.Double shape = new Path2D.Double();
        Point2D p0 = null;
        Point2D p1 = null;
        Point2D p2 = null;
        Point2D p3 = null;
        Point2D.Double ctrl1 = new Point2D.Double();
        Point2D.Double ctrl2 = new Point2D.Double();
        for (DataPoint point : points) {
            if (point == null) continue;
            p3 = point.position.getPoint2D();
            SmoothLineRenderer2D.addCurve(shape, p0, p1, p2, p3, ctrl1, ctrl2, smoothness);
            p0 = p1;
            p1 = p2;
            p2 = p3;
        }
        SmoothLineRenderer2D.addCurve(shape, p0, p1, p2, p3, ctrl1, ctrl2, smoothness);
        return this.stroke(shape);
    }

    private static void addCurve(Path2D line, Point2D p0, Point2D p1, Point2D p2, Point2D p3, Point2D ctrl1, Point2D ctrl2, double smoothness) {
        if (p1 == null) {
            return;
        }
        if (line.getCurrentPoint() == null) {
            line.moveTo(p1.getX(), p1.getY());
        }
        if (p2 == null) {
            return;
        }
        SmoothLineRenderer2D.getControlsPoints(p0, p1, p2, p3, ctrl1, ctrl2, smoothness);
        line.curveTo(ctrl1.getX(), ctrl1.getY(), ctrl2.getX(), ctrl2.getY(), p2.getX(), p2.getY());
    }

    private static void getControlsPoints(Point2D p0, Point2D p1, Point2D p2, Point2D p3, Point2D ctrl1, Point2D ctrl2, double smoothness) {
        if (p0 == null) {
            p0 = p1;
        }
        if (p3 == null) {
            p3 = p2;
        }
        Point2D.Double c1 = new Point2D.Double((p0.getX() + p1.getX()) / 2.0, (p0.getY() + p1.getY()) / 2.0);
        Point2D.Double c2 = new Point2D.Double((p1.getX() + p2.getX()) / 2.0, (p1.getY() + p2.getY()) / 2.0);
        Point2D.Double c3 = new Point2D.Double((p2.getX() + p3.getX()) / 2.0, (p2.getY() + p3.getY()) / 2.0);
        double len1 = p1.distance(p0);
        double len2 = p2.distance(p1);
        double len3 = p3.distance(p2);
        double k1 = len1 / (len1 + len2);
        double k2 = len2 / (len2 + len3);
        Point2D.Double m1 = new Point2D.Double(((Point2D)c1).getX() + (((Point2D)c2).getX() - ((Point2D)c1).getX()) * k1, ((Point2D)c1).getY() + (((Point2D)c2).getY() - ((Point2D)c1).getY()) * k1);
        Point2D.Double m2 = new Point2D.Double(((Point2D)c2).getX() + (((Point2D)c3).getX() - ((Point2D)c2).getX()) * k2, ((Point2D)c2).getY() + (((Point2D)c3).getY() - ((Point2D)c2).getY()) * k2);
        ctrl1.setLocation(((Point2D)m1).getX() + (((Point2D)c2).getX() - ((Point2D)m1).getX()) * smoothness + p1.getX() - ((Point2D)m1).getX(), ((Point2D)m1).getY() + (((Point2D)c2).getY() - ((Point2D)m1).getY()) * smoothness + p1.getY() - ((Point2D)m1).getY());
        ctrl2.setLocation(((Point2D)m2).getX() + (((Point2D)c2).getX() - ((Point2D)m2).getX()) * smoothness + p2.getX() - ((Point2D)m2).getX(), ((Point2D)m2).getY() + (((Point2D)c2).getY() - ((Point2D)m2).getY()) * smoothness + p2.getY() - ((Point2D)m2).getY());
    }

    public Number getSmoothness() {
        return this.smoothness;
    }

    public void setSmoothness(Number smoothness) {
        this.smoothness = smoothness;
    }
}

