/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.colors;

import de.erichseifert.gral.plots.colors.AbstractColorMapper;
import de.erichseifert.gral.plots.colors.ColorMapper;
import de.erichseifert.gral.util.MathUtils;
import java.awt.Paint;

public abstract class ContinuousColorMapper
extends AbstractColorMapper<Double> {
    private static final long serialVersionUID = 4616781244057993699L;

    public abstract Paint get(double var1);

    @Override
    public Paint get(Number value) {
        return this.get(value.doubleValue());
    }

    @Override
    protected Double applyMode(Double value, Double rangeMin, Double rangeMax) {
        if (value >= rangeMin && value <= rangeMax) {
            return value;
        }
        ColorMapper.Mode mode = this.getMode();
        if (mode == ColorMapper.Mode.REPEAT) {
            return MathUtils.limit(value, rangeMin, rangeMax);
        }
        if (mode == ColorMapper.Mode.CIRCULAR) {
            double range = rangeMax - rangeMin;
            double i = value % range;
            if (i < 0.0) {
                i += range;
            }
            return i + rangeMin;
        }
        return null;
    }
}

