/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.navigation;

import de.erichseifert.gral.navigation.NavigationDirection;
import de.erichseifert.gral.navigation.NavigationEvent;
import de.erichseifert.gral.navigation.NavigationListener;
import de.erichseifert.gral.navigation.Navigator;
import de.erichseifert.gral.util.PointND;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractNavigator
implements Navigator {
    public static final double DEFAULT_ZOOM_FACTOR = 1.25;
    public static final double DEFAULT_ZOOM_MIN = 0.01;
    public static final double DEFAULT_ZOOM_MAX = 100.0;
    private final Set<NavigationListener> navigationListeners = new HashSet<NavigationListener>();
    private double zoomFactor = 1.25;
    private double zoomMin = 0.01;
    private double zoomMax = 100.0;
    private boolean zoomable = true;
    private boolean pannable = true;
    private NavigationDirection direction;

    @Override
    public boolean isZoomable() {
        return this.zoomable;
    }

    @Override
    public void setZoomable(boolean zoomable) {
        this.zoomable = zoomable;
    }

    @Override
    public void zoomIn() {
        this.zoomInAt(null);
    }

    @Override
    public void zoomOut() {
        this.zoomOutAt(null);
    }

    @Override
    public void zoomAt(double zoom, PointND<? extends Number> zoomPoint) {
        if (!this.isZoomable()) {
            return;
        }
        boolean pan = this.isPannable() && zoomPoint != null;
        PointND<? extends Number> center = null;
        if (pan) {
            center = this.getCenter();
            this.setCenter(zoomPoint);
        }
        this.setZoom(zoom);
        if (pan) {
            this.setCenter(center);
        }
    }

    @Override
    public void zoomInAt(PointND<? extends Number> zoomPoint) {
        double zoom = this.getZoom();
        this.zoomAt(zoom * this.getZoomFactor(), zoomPoint);
    }

    @Override
    public void zoomOutAt(PointND<? extends Number> zoomPoint) {
        double zoom = this.getZoom();
        this.zoomAt(zoom / this.getZoomFactor(), zoomPoint);
    }

    @Override
    public boolean isPannable() {
        return this.pannable;
    }

    @Override
    public void setPannable(boolean pannable) {
        this.pannable = pannable;
    }

    @Override
    public double getZoomFactor() {
        return this.zoomFactor;
    }

    @Override
    public void setZoomFactor(double factor) {
        this.zoomFactor = factor;
    }

    @Override
    public double getZoomMin() {
        return this.zoomMin;
    }

    @Override
    public void setZoomMin(double min) {
        this.zoomMin = min;
    }

    @Override
    public double getZoomMax() {
        return this.zoomMax;
    }

    @Override
    public void setZoomMax(double max) {
        this.zoomMax = max;
    }

    @Override
    public void addNavigationListener(NavigationListener l) {
        this.navigationListeners.add(l);
    }

    @Override
    public void removeNavigationListener(NavigationListener l) {
        this.navigationListeners.remove(l);
    }

    @Override
    public NavigationDirection getDirection() {
        return this.direction;
    }

    @Override
    public void setDirection(NavigationDirection direction) {
        this.direction = direction;
    }

    @Override
    public void connect(Navigator navigator) {
        if (navigator != null && navigator != this) {
            this.addNavigationListener(navigator);
            navigator.addNavigationListener(this);
        }
    }

    @Override
    public void disconnect(Navigator navigator) {
        if (navigator != null && navigator != this) {
            this.removeNavigationListener(navigator);
            navigator.removeNavigationListener(this);
        }
    }

    @Override
    public void centerChanged(NavigationEvent<PointND<? extends Number>> event) {
        if (event.getSource() != this) {
            this.setCenter(event.getValueNew());
        }
    }

    @Override
    public void zoomChanged(NavigationEvent<Double> event) {
        if (event.getSource() != this) {
            this.setZoom(event.getValueNew());
        }
    }

    protected void fireCenterChanged(NavigationEvent<PointND<? extends Number>> event) {
        for (NavigationListener l : this.navigationListeners) {
            l.centerChanged(event);
        }
    }

    protected void fireZoomChanged(NavigationEvent<Double> event) {
        for (NavigationListener l : this.navigationListeners) {
            l.zoomChanged(event);
        }
    }
}

