/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.io.data;

import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.DataTable;
import de.erichseifert.gral.io.IOCapabilities;
import de.erichseifert.gral.io.data.AbstractDataReader;
import de.erichseifert.gral.util.Messages;
import de.erichseifert.gral.util.StatefulTokenizer;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;

public class CSVReader
extends AbstractDataReader {
    public static final String SEPARATOR_CHAR = "separator";

    public CSVReader(String mimeType) {
        super(mimeType);
        if ("text/tab-separated-values".equals(mimeType)) {
            this.setDefault(SEPARATOR_CHAR, Character.valueOf('\t'));
        } else {
            this.setDefault(SEPARATOR_CHAR, Character.valueOf(','));
        }
    }

    @Override
    public DataSource read(InputStream input, Class<? extends Comparable<?>> ... types) throws IOException {
        Scanner scanner = new Scanner(input).useDelimiter("\\Z");
        String content = scanner.next();
        Character separator = (Character)this.getSetting(SEPARATOR_CHAR);
        CSVTokenizer tokenizer = new CSVTokenizer(separator.charValue());
        List<StatefulTokenizer.Token> tokens = tokenizer.tokenize(content);
        StatefulTokenizer.Token lastToken = tokens.get(tokens.size() - 1);
        if (lastToken.getType() != CSVTokenType.ROW_SEPARATOR) {
            StatefulTokenizer.Token eof = new StatefulTokenizer.Token(lastToken.getEnd(), lastToken.getEnd(), (Object)CSVTokenType.ROW_SEPARATOR, "");
            tokens.add(eof);
        }
        HashMap parseMethods = new HashMap();
        for (Class<Comparable<?>> clazz : types) {
            Method parseMethod;
            if (parseMethods.containsKey(clazz) || (parseMethod = CSVReader.getParseMethod(clazz)) == null) continue;
            parseMethods.put(clazz, parseMethod);
        }
        DataTable data = new DataTable(types);
        LinkedList<Comparable> row = new LinkedList<Comparable>();
        int rowIndex = 0;
        boolean bl = false;
        String cellContent = "";
        for (StatefulTokenizer.Token token : tokens) {
            Comparable cell;
            int n;
            block11: {
                if (token.getType() == CSVTokenType.TEXT || token.getType() == CSVTokenType.EMPTY_SPACE) {
                    cellContent = cellContent + token.getContent();
                    continue;
                }
                if (token.getType() != CSVTokenType.COLUMN_SEPARATOR && token.getType() != CSVTokenType.ROW_SEPARATOR) continue;
                if (n >= types.length) {
                    throw new IllegalArgumentException(MessageFormat.format("Too many columns in line {0,number,integer}: got {1,number,integer}, but expected {2,number,integer}.", rowIndex + 1, (int)(n + true), types.length));
                }
                Class<Comparable<?>> colType = types[n];
                Method parseMethod = (Method)parseMethods.get(colType);
                cell = null;
                try {
                    cell = (Comparable)parseMethod.invoke(null, cellContent.trim());
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(MessageFormat.format("Could not invoke method for parsing data type {0} in column {1,number,integer}.", types[n].getSimpleName(), n));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(MessageFormat.format("Could not access method for parsing data type {0} in column {1,number,integer}.", types[n].getSimpleName(), n));
                }
                catch (InvocationTargetException e) {
                    if (cellContent.isEmpty()) break block11;
                    throw new IOException(MessageFormat.format("Type mismatch in line {0,number,integer}, column {1,number,integer}: got \"{2}\", but expected {3} value.", rowIndex + 1, (int)(n + true), cellContent, colType.getSimpleName()));
                }
            }
            row.add(cell);
            n += 1;
            if (token.getType() == CSVTokenType.ROW_SEPARATOR) {
                if (row.size() < types.length) {
                    throw new IllegalArgumentException(MessageFormat.format("Not enough columns in line {0,number,integer}: got {1,number,integer}, but expected {2,number,integer}.", rowIndex + 1, row.size(), types.length));
                }
                data.add(row);
                ++rowIndex;
                row.clear();
                n = 0;
            }
            cellContent = "";
        }
        return data;
    }

    private static Method getParseMethod(Class<?> c) {
        Method parse = null;
        if (String.class.isAssignableFrom(c)) {
            try {
                parse = String.class.getMethod("valueOf", Object.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        } else {
            for (Method m : c.getMethods()) {
                boolean hasStringParameter;
                boolean isStatic = m.toString().contains("static");
                if (!isStatic) continue;
                Class<?>[] types = m.getParameterTypes();
                boolean bl = hasStringParameter = types.length == 1 && String.class.equals(types[0]);
                if (!hasStringParameter || !m.getName().startsWith("parse" + c.getSimpleName().substring(0, 3))) continue;
                parse = m;
            }
        }
        return parse;
    }

    static {
        CSVReader.addCapabilities(new IOCapabilities("CSV", Messages.getString("DataIO.csvDescription"), "text/csv", new String[]{"csv", "txt"}));
        CSVReader.addCapabilities(new IOCapabilities("TSV", Messages.getString("DataIO.tsvDescription"), "text/tab-separated-values", new String[]{"tsv", "tab", "txt"}));
    }

    private static final class CSVTokenizer
    extends StatefulTokenizer {
        public CSVTokenizer(char separator) {
            this.addJoinedType((Object)CSVTokenType.TEXT);
            this.addIgnoredType((Object)CSVTokenType.QUOTE);
            this.putRules(new StatefulTokenizer.Rule("\n|\r\n|\r", (Object)CSVTokenType.ROW_SEPARATOR), new StatefulTokenizer.Rule(Pattern.quote(String.valueOf(separator)), (Object)CSVTokenType.COLUMN_SEPARATOR), new StatefulTokenizer.Rule("\"", (Object)CSVTokenType.QUOTE, "quoted"), new StatefulTokenizer.Rule("[ \t]+", (Object)CSVTokenType.EMPTY_SPACE), new StatefulTokenizer.Rule(".", (Object)CSVTokenType.TEXT));
            this.putRules("quoted", new StatefulTokenizer.Rule("(\")\"", (Object)CSVTokenType.TEXT), new StatefulTokenizer.Rule("\"", (Object)CSVTokenType.QUOTE, "#pop"), new StatefulTokenizer.Rule(".", (Object)CSVTokenType.TEXT));
        }
    }

    private static enum CSVTokenType {
        EMPTY_SPACE,
        TEXT,
        QUOTE,
        ROW_SEPARATOR,
        COLUMN_SEPARATOR;

    }
}

