/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.examples.xyplot;

import de.erichseifert.gral.data.DataSeries;
import de.erichseifert.gral.data.DataTable;
import de.erichseifert.gral.examples.ExamplePanel;
import de.erichseifert.gral.examples.xyplot.UpdateTask;
import de.erichseifert.gral.graphics.Insets2D;
import de.erichseifert.gral.graphics.Orientation;
import de.erichseifert.gral.plots.XYPlot;
import de.erichseifert.gral.plots.areas.AreaRenderer;
import de.erichseifert.gral.plots.areas.DefaultAreaRenderer2D;
import de.erichseifert.gral.plots.axes.AxisRenderer;
import de.erichseifert.gral.plots.lines.DefaultLineRenderer2D;
import de.erichseifert.gral.plots.lines.LineRenderer;
import de.erichseifert.gral.ui.InteractivePanel;
import de.erichseifert.gral.util.GraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.LinearGradientPaint;
import java.text.DateFormat;
import java.text.DecimalFormat;
import javax.swing.Timer;

public class MemoryUsage
extends ExamplePanel {
    private static final long serialVersionUID = 5914124874301980251L;
    private static final int BUFFER_SIZE = 400;
    private static final int INTERVAL = 100;

    public MemoryUsage() {
        DataTable data = new DataTable(Double.class, Long.class, Long.class, Long.class);
        double time = System.currentTimeMillis();
        for (int i = 399; i >= 0; --i) {
            data.add(Double.valueOf(time - (double)(i * 100)), null, null, null);
        }
        DataSeries memSysUsage = new DataSeries("Used by system", data, 0, 1);
        DataSeries memVm = new DataSeries("Allocated by Java VM", data, 0, 2);
        DataSeries memVmUsage = new DataSeries("Used by Java VM", data, 0, 3);
        XYPlot plot = new XYPlot(memSysUsage, memVm, memVmUsage);
        plot.setInsets(new Insets2D.Double(20.0, 90.0, 40.0, 20.0));
        plot.getTitle().setText("Memory Usage");
        plot.setLegendVisible(true);
        plot.getLegend().setOrientation(Orientation.HORIZONTAL);
        ((XYPlot.XYPlotArea2D)plot.getPlotArea()).setMajorGridX(false);
        ((XYPlot.XYPlotArea2D)plot.getPlotArea()).setMinorGridY(true);
        plot.getAxis("y").setRange(0.0, 1.0);
        AxisRenderer axisRendererX = plot.getAxisRenderer("x");
        axisRendererX.setTickSpacing(4000.0);
        axisRendererX.setTickLabelFormat(DateFormat.getTimeInstance());
        AxisRenderer axisRendererY = plot.getAxisRenderer("y");
        axisRendererY.setMinorTicksCount(4);
        axisRendererY.setTickLabelFormat(new DecimalFormat("0 MiB"));
        Color color1Dark = GraphicsUtils.deriveDarker(COLOR1);
        plot.setPointRenderers(memSysUsage, null);
        DefaultAreaRenderer2D area1 = new DefaultAreaRenderer2D();
        area1.setColor(new LinearGradientPaint(0.0f, 0.0f, 0.0f, 1.0f, new float[]{0.0f, 1.0f}, new Color[]{GraphicsUtils.deriveWithAlpha(COLOR1, 128), GraphicsUtils.deriveWithAlpha(COLOR1, 24)}));
        plot.setAreaRenderers(memSysUsage, area1, new AreaRenderer[0]);
        plot.setPointRenderers(memVm, null);
        DefaultLineRenderer2D line2 = new DefaultLineRenderer2D();
        line2.setColor(GraphicsUtils.deriveWithAlpha(color1Dark, 128));
        plot.setLineRenderers(memVm, line2, new LineRenderer[0]);
        plot.setPointRenderers(memVmUsage, null);
        DefaultAreaRenderer2D area3 = new DefaultAreaRenderer2D();
        area3.setColor(new LinearGradientPaint(0.0f, 0.0f, 0.0f, 1.0f, new float[]{0.0f, 1.0f}, new Color[]{GraphicsUtils.deriveWithAlpha(COLOR2, 128), GraphicsUtils.deriveWithAlpha(COLOR2, 24)}));
        plot.setAreaRenderers(memVmUsage, area3, new AreaRenderer[0]);
        InteractivePanel plotPanel = new InteractivePanel(plot);
        plotPanel.setPannable(false);
        plotPanel.setZoomable(false);
        this.add((Component)plotPanel, "Center");
        UpdateTask updateTask = new UpdateTask(data, plot, plotPanel);
        Timer updateTimer = new Timer(100, updateTask);
        updateTimer.setCoalesce(false);
        updateTimer.start();
    }

    @Override
    public String getTitle() {
        return "Memory usage";
    }

    @Override
    public String getDescription() {
        return "Area plot of the system's current memory usage. This example works best with Oracle VM, but it can show VM memory usage on other VMs too.";
    }

    public static void main(String[] args) {
        new MemoryUsage().showInFrame();
    }
}

