/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.examples.xyplot;

import de.erichseifert.gral.data.DataSeries;
import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.DataTable;
import de.erichseifert.gral.data.filters.Convolution;
import de.erichseifert.gral.data.filters.Filter2D;
import de.erichseifert.gral.data.filters.Kernel;
import de.erichseifert.gral.data.filters.Median;
import de.erichseifert.gral.examples.ExamplePanel;
import de.erichseifert.gral.graphics.Insets2D;
import de.erichseifert.gral.graphics.Orientation;
import de.erichseifert.gral.plots.XYPlot;
import de.erichseifert.gral.plots.lines.DefaultLineRenderer2D;
import de.erichseifert.gral.plots.lines.LineRenderer;
import de.erichseifert.gral.ui.InteractivePanel;
import de.erichseifert.gral.util.GraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.util.Random;

public class ConvolutionExample
extends ExamplePanel {
    private static final long serialVersionUID = 5084898568751883516L;
    private static final int SAMPLE_COUNT = 200;

    public ConvolutionExample() {
        DataTable data = new DataTable(Double.class, Double.class);
        Random r = new Random();
        for (int i = 0; i < 200; ++i) {
            double x = (double)i / 2.0 / Math.PI;
            double yError = Math.sqrt(0.30000000000000004) * r.nextGaussian();
            double y = 10.0 * Math.sin(x / 5.0) + yError * yError * yError;
            data.add(Double.valueOf(x), Double.valueOf(y));
        }
        DataSeries ds = new DataSeries("Data", data, 0, 1);
        double KERNEL_VARIANCE = 5.0;
        Kernel kernelLowpass = Kernel.getBinomial(5.0).normalize();
        Convolution dataLowpass = new Convolution((DataSource)data, kernelLowpass, Filter2D.Mode.REPEAT, 1);
        DataSeries dsLowpass = new DataSeries("Lowpass", dataLowpass, 0, 1);
        Kernel kernelHighpass = Kernel.getBinomial(5.0).normalize().negate().add(new Kernel(1.0));
        Convolution dataHighpass = new Convolution((DataSource)data, kernelHighpass, Filter2D.Mode.REPEAT, 1);
        DataSeries dsHighpass = new DataSeries("Highpass", dataHighpass, 0, 1);
        int kernelMovingAverageSize = (int)Math.round(20.0);
        Kernel kernelMovingAverage = Kernel.getUniform(kernelMovingAverageSize, kernelMovingAverageSize - 1, 1.0).normalize();
        Convolution dataMovingAverage = new Convolution((DataSource)data, kernelMovingAverage, Filter2D.Mode.OMIT, 1);
        DataSeries dsMovingAverage = new DataSeries("Moving Average", dataMovingAverage, 0, 1);
        int kernelMovingMedianSize = (int)Math.round(20.0);
        Median dataMovingMedian = new Median((DataSource)data, kernelMovingMedianSize, kernelMovingMedianSize - 1, Filter2D.Mode.OMIT, 1);
        DataSeries dsMovingMedian = new DataSeries("Moving Median", dataMovingMedian, 0, 1);
        XYPlot plot = new XYPlot(ds, dsLowpass, dsHighpass, dsMovingAverage, dsMovingMedian);
        plot.setInsets(new Insets2D.Double(20.0, 40.0, 40.0, 40.0));
        plot.setLegendVisible(true);
        plot.getLegend().setOrientation(Orientation.HORIZONTAL);
        plot.getLegend().setAlignmentY(1.0);
        ConvolutionExample.formatLine(plot, ds, Color.BLACK);
        ConvolutionExample.formatLine(plot, dsLowpass, COLOR1);
        ConvolutionExample.formatLine(plot, dsHighpass, GraphicsUtils.deriveDarker(COLOR1));
        ConvolutionExample.formatLine(plot, dsMovingAverage, COLOR2);
        ConvolutionExample.formatLine(plot, dsMovingMedian, GraphicsUtils.deriveDarker(COLOR2));
        this.add((Component)new InteractivePanel(plot), "Center");
    }

    private static void formatLine(XYPlot plot, DataSeries series, Color color) {
        plot.setPointRenderers(series, null);
        DefaultLineRenderer2D line = new DefaultLineRenderer2D();
        line.setColor(color);
        plot.setLineRenderers(series, line, new LineRenderer[0]);
    }

    @Override
    public String getTitle() {
        return "Convolution filtering";
    }

    @Override
    public String getDescription() {
        return "Line plot showing various ways of filtering data with convolution";
    }

    public static void main(String[] args) {
        new ConvolutionExample().showInFrame();
    }
}

