/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.examples.barplot;

import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.DataTable;
import de.erichseifert.gral.data.EnumeratedData;
import de.erichseifert.gral.data.statistics.Histogram2D;
import de.erichseifert.gral.examples.ExamplePanel;
import de.erichseifert.gral.graphics.Insets2D;
import de.erichseifert.gral.graphics.Orientation;
import de.erichseifert.gral.plots.BarPlot;
import de.erichseifert.gral.plots.points.PointRenderer;
import de.erichseifert.gral.ui.InteractivePanel;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.MathUtils;
import java.util.Random;

public class HistogramPlot
extends ExamplePanel {
    private static final long serialVersionUID = 4458280577519421950L;
    private static final int SAMPLE_COUNT = 1000;

    public HistogramPlot() {
        Random random = new Random();
        DataTable data = new DataTable(Double.class);
        for (int i = 0; i < 1000; ++i) {
            data.add(Double.valueOf(random.nextGaussian()));
        }
        Histogram2D histogram = new Histogram2D((DataSource)data, Orientation.VERTICAL, new Number[][]{{-4.0, -3.2, -2.4, -1.6, -0.8, 0.0, 0.8, 1.6, 2.4, 3.6, 4.0}});
        EnumeratedData histogram2d = new EnumeratedData(histogram, -3.6, 0.8);
        BarPlot plot = new BarPlot(histogram2d);
        plot.setInsets(new Insets2D.Double(20.0, 65.0, 50.0, 40.0));
        plot.getTitle().setText(String.format("Distribution of %d random samples", data.getRowCount()));
        plot.setBarWidth(0.78);
        plot.getAxisRenderer("x").setTickAlignment(0.0);
        plot.getAxisRenderer("x").setTickSpacing(0.8);
        plot.getAxisRenderer("x").setMinorTicksVisible(false);
        plot.getAxis("y").setRange(0.0, MathUtils.ceil(histogram.getStatistics().get("max") * 1.1, 25.0));
        plot.getAxisRenderer("y").setTickAlignment(0.0);
        plot.getAxisRenderer("y").setMinorTicksVisible(false);
        plot.getAxisRenderer("y").setIntersection(-4.4);
        PointRenderer barRenderer = plot.getPointRenderers(histogram2d).get(0);
        barRenderer.setColor(GraphicsUtils.deriveWithAlpha(COLOR1, 128));
        barRenderer.setValueVisible(true);
        InteractivePanel panel = new InteractivePanel(plot);
        panel.setPannable(false);
        panel.setZoomable(false);
        this.add(panel);
    }

    @Override
    public String getTitle() {
        return "AbstractHistogram2D plot";
    }

    @Override
    public String getDescription() {
        return String.format("AbstractHistogram2D of %d samples", 1000);
    }

    public static void main(String[] args) {
        new HistogramPlot().showInFrame();
    }
}

