/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.examples;

import de.erichseifert.gral.examples.ExamplePanel;
import de.erichseifert.gral.examples.barplot.HistogramPlot;
import de.erichseifert.gral.examples.barplot.SimpleBarPlot;
import de.erichseifert.gral.examples.boxplot.SimpleBoxPlot;
import de.erichseifert.gral.examples.pieplot.DynamicPiePlot;
import de.erichseifert.gral.examples.pieplot.SimplePiePlot;
import de.erichseifert.gral.examples.rasterplot.SimpleRasterPlot;
import de.erichseifert.gral.examples.xyplot.AreaPlot;
import de.erichseifert.gral.examples.xyplot.ConvolutionExample;
import de.erichseifert.gral.examples.xyplot.MemoryUsage;
import de.erichseifert.gral.examples.xyplot.MultiplePointRenderers;
import de.erichseifert.gral.examples.xyplot.ScatterPlot;
import de.erichseifert.gral.examples.xyplot.SimpleXYPlot;
import de.erichseifert.gral.examples.xyplot.SpiralPlot;
import de.erichseifert.gral.examples.xyplot.StackedPlots;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Browser
extends JFrame
implements ListSelectionListener {
    private static final long serialVersionUID = -3734045121668893200L;
    private static final ExamplePanel[] examples = new ExamplePanel[]{new HistogramPlot(), new SimpleBarPlot(), new SimpleBoxPlot(), new DynamicPiePlot(), new SimplePiePlot(), new SimpleRasterPlot(), new AreaPlot(), new ConvolutionExample(), new MemoryUsage(), new ScatterPlot(), new SimpleXYPlot(), new SpiralPlot(), new StackedPlots(), new MultiplePointRenderers()};
    private final JList examplesList;
    private final JScrollPane exampleScrollPane;

    public Browser() {
        super("GRAL examples");
        this.setDefaultCloseOperation(3);
        this.examplesList = new ExamplesList(examples);
        this.examplesList.addListSelectionListener(this);
        this.exampleScrollPane = new JScrollPane();
        this.setExample(examples[0]);
        JSplitPane listExamplesSplitter = new JSplitPane(1);
        listExamplesSplitter.setLeftComponent(this.examplesList);
        listExamplesSplitter.setRightComponent(this.exampleScrollPane);
        listExamplesSplitter.setOneTouchExpandable(true);
        listExamplesSplitter.setContinuousLayout(true);
        this.getContentPane().add(listExamplesSplitter);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void setExample(ExamplePanel example) {
        if (example == this.exampleScrollPane.getViewport().getView()) {
            return;
        }
        this.exampleScrollPane.getViewport().setView(example);
        this.examplesList.setSelectedValue(example, true);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object source = e.getSource();
        if (source == this.examplesList) {
            this.setExample((ExamplePanel)this.examplesList.getSelectedValue());
        }
    }

    public static void main(String[] args) {
        Browser frame = new Browser();
        frame.setVisible(true);
    }

    private static class ExamplesList
    extends JList {
        private static final long serialVersionUID = -5904920699472899791L;

        public ExamplesList(ExamplePanel[] examples) {
            super(examples);
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            int index = this.locationToIndex(event.getPoint());
            ExamplePanel item = (ExamplePanel)this.getModel().getElementAt(index);
            return item.getDescription();
        }
    }
}

