/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.data.filters;

import de.erichseifert.gral.data.Column;
import de.erichseifert.gral.data.DataChangeEvent;
import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.DataTable;
import de.erichseifert.gral.data.Record;
import de.erichseifert.gral.data.filters.Filter2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Iterator;

public class Resize
extends Filter2D {
    private static final long serialVersionUID = -5601162872352170735L;
    private final int cols;
    private final int rows;

    public Resize(DataSource data, int cols, int rows) {
        super(data, Filter2D.Mode.ZERO, new int[0]);
        this.cols = cols;
        this.rows = rows;
        this.filter();
    }

    @Override
    public int getColumnCount() {
        if (this.cols <= 0) {
            return super.getColumnCount();
        }
        return this.cols;
    }

    @Override
    public int getRowCount() {
        if (this.rows <= 0) {
            return super.getRowCount();
        }
        return this.rows;
    }

    @Override
    public Comparable<?> get(int col, int row) {
        if (!(this.cols > 0 && this.cols != this.getOriginal().getColumnCount() || this.rows > 0 && this.rows != this.getOriginal().getRowCount())) {
            return this.getOriginal(col, row);
        }
        return super.get(col, row);
    }

    @Override
    protected void filter() {
        double end;
        double start;
        double step;
        Object[] dataTypes;
        this.clear();
        DataSource original = this.getOriginal();
        if (this.getRowCount() == original.getRowCount() && this.getColumnCount() == original.getColumnCount()) {
            return;
        }
        DataSource data = original;
        if (this.getRowCount() != original.getRowCount()) {
            dataTypes = new Class[original.getColumnCount()];
            Arrays.fill(dataTypes, Double.class);
            DataTable avgRows = new DataTable((Class<? extends Comparable<?>>[])dataTypes);
            Resize.fillWithEmptyRows(avgRows, this.getRowCount());
            step = (double)original.getRowCount() / (double)this.getRowCount();
            for (int colIndex = 0; colIndex < original.getColumnCount(); ++colIndex) {
                Column<?> colData = original.getColumn(colIndex);
                for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
                    start = (double)rowIndex * step;
                    end = (double)(rowIndex + 1) * step;
                    avgRows.set(colIndex, rowIndex, Double.valueOf(Resize.average(colData, start, end)));
                }
            }
            data = avgRows;
        }
        if (this.getColumnCount() != original.getColumnCount()) {
            dataTypes = new Class[this.getColumnCount()];
            Arrays.fill(dataTypes, Double.class);
            DataTable avgCols = new DataTable((Class<? extends Comparable<?>>[])dataTypes);
            Resize.fillWithEmptyRows(avgCols, data.getRowCount());
            step = (double)original.getColumnCount() / (double)this.getColumnCount();
            for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
                Record rowData = data.getRecord(rowIndex);
                for (int colIndex = 0; colIndex < this.getColumnCount(); ++colIndex) {
                    start = (double)colIndex * step;
                    end = (double)(colIndex + 1) * step;
                    avgCols.set(colIndex, rowIndex, Double.valueOf(Resize.average(rowData, start, end)));
                }
            }
            data = avgCols;
        }
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            Record row = data.getRecord(rowIndex);
            Double[] rowValues = new Double[row.size()];
            for (int columnIndex = 0; columnIndex < rowValues.length; ++columnIndex) {
                rowValues[columnIndex] = (Double)row.get(columnIndex);
            }
            this.add(rowValues);
        }
    }

    private static void fillWithEmptyRows(DataTable data, int count) {
        while (data.getRowCount() < count) {
            Object[] emptyRow = new Double[data.getColumnCount()];
            Arrays.fill(emptyRow, (Object)0.0);
            data.add((Comparable<?>[])emptyRow);
        }
    }

    private static <T> Iterator<T> advance(Iterator<T> iterator, int elementCount) {
        for (int elementIndex = 0; elementIndex < elementCount; ++elementIndex) {
            iterator.next();
        }
        return iterator;
    }

    private static double average(Iterable<? extends Comparable<?>> data, double start, double end) {
        int startFloor = (int)Math.floor(start);
        int startCeil = (int)Math.ceil(start);
        int endFloor = (int)Math.floor(end);
        int endCeil = (int)Math.ceil(end);
        double sum = 0.0;
        Iterator<Comparable<?>> dataIterator = data.iterator();
        Resize.advance(dataIterator, startFloor);
        for (int i = startFloor; i < endCeil; ++i) {
            Number number = (Number)((Object)dataIterator.next());
            double val = number.doubleValue();
            if (i == startFloor && (double)startCeil != start) {
                sum += ((double)startCeil - start) * val;
                continue;
            }
            if (i == endCeil - 1 && (double)endFloor != end) {
                sum += (end - (double)endFloor) * val;
                continue;
            }
            sum += val;
        }
        return sum / (end - start);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.dataUpdated(this, new DataChangeEvent[0]);
    }
}

