/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.data.filters;

import de.erichseifert.gral.data.filters.Filter;
import de.erichseifert.gral.data.statistics.Statistics;
import de.erichseifert.gral.util.WindowIterator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class MedianFilter<T extends Number>
implements Filter<T> {
    private final List<Double> filtered = new LinkedList<Double>();
    private final Iterator<List<T>> windowIterator;

    public MedianFilter(Iterable<T> data, int windowSize) {
        this.windowIterator = new WindowIterator<T>(data.iterator(), windowSize);
        while (this.windowIterator.hasNext()) {
            List<T> window = this.windowIterator.next();
            Statistics windowStatistics = new Statistics(window);
            double median = windowStatistics.get("quantile50");
            this.filtered.add(median);
        }
    }

    @Override
    public Iterator<Double> iterator() {
        return this.filtered.iterator();
    }
}

