/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.data;

import de.erichseifert.gral.data.AbstractDataSource;
import de.erichseifert.gral.data.DataChangeEvent;
import de.erichseifert.gral.data.DataListener;
import de.erichseifert.gral.data.DataSource;

public class EnumeratedData
extends AbstractDataSource
implements DataListener {
    private static final long serialVersionUID = -4952487410608980063L;
    private final DataSource original;
    private final double offset;
    private final double steps;

    public EnumeratedData(DataSource original, double offset, double steps) {
        this.original = original;
        this.offset = offset;
        this.steps = steps;
        Class<? extends Comparable<?>>[] typesOrig = original.getColumnTypes();
        Class[] types = new Class[typesOrig.length + 1];
        System.arraycopy(typesOrig, 0, types, 1, typesOrig.length);
        types[0] = Double.class;
        this.setColumnTypes(types);
        original.addDataListener(this);
    }

    public EnumeratedData(DataSource original) {
        this(original, 0.0, 1.0);
    }

    @Override
    public Comparable<?> get(int col, int row) {
        if (col < 1) {
            return (double)row * this.steps + this.offset;
        }
        return this.original.get(col - 1, row);
    }

    @Override
    public int getRowCount() {
        return this.original.getRowCount();
    }

    @Override
    public void dataAdded(DataSource source, DataChangeEvent ... events) {
        this.notifyDataAdded(this.takeEvents(events));
    }

    @Override
    public void dataUpdated(DataSource source, DataChangeEvent ... events) {
        this.notifyDataUpdated(this.takeEvents(events));
    }

    @Override
    public void dataRemoved(DataSource source, DataChangeEvent ... events) {
        this.notifyDataRemoved(this.takeEvents(events));
    }

    private DataChangeEvent[] takeEvents(DataChangeEvent[] events) {
        if (events == null || events.length == 0) {
            return new DataChangeEvent[]{new DataChangeEvent(this, 0, 0, null, null)};
        }
        DataChangeEvent[] eventsTx = new DataChangeEvent[events.length + 1];
        for (int i = 0; i < eventsTx.length; ++i) {
            int row;
            int col;
            DataChangeEvent event;
            if (i == 0) {
                event = events[0];
                col = 0;
                row = event.getRow();
            } else {
                event = events[i - 1];
                col = event.getCol() + 1;
                row = event.getRow();
            }
            Comparable<?> valOld = event.getOld();
            Comparable<?> valNew = event.getNew();
            eventsTx[i] = new DataChangeEvent(this, col, row, valOld, valNew);
        }
        return eventsTx;
    }
}

