/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.calibration;

import boofcv.abst.geo.calibration.ImageResults;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.alg.geo.calibration.Zhang99ParamAll;
import boofcv.gui.StandardAlgConfigPanel;
import boofcv.gui.calibration.CalibratedImageGridPanel;
import boofcv.struct.calib.IntrinsicParameters;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MonoPlanarPanel
extends JPanel
implements ItemListener,
ListSelectionListener,
ChangeListener {
    CalibratedImageGridPanel mainView = new CalibratedImageGridPanel();
    JCheckBox checkPoints;
    JCheckBox checkErrors;
    JCheckBox checkUndistorted;
    JCheckBox checkAll;
    JCheckBox checkNumbers;
    JSpinner selectErrorScale;
    JList imageList;
    JTextArea meanError;
    JTextArea maxError;
    JTextArea paramCenterX;
    JTextArea paramCenterY;
    JTextArea paramA;
    JTextArea paramB;
    JTextArea paramC;
    boolean showPoints = true;
    boolean showErrors = true;
    boolean showUndistorted = false;
    boolean showAll = false;
    boolean showNumbers = true;
    int selectedImage = 0;
    List<String> names = new ArrayList<String>();
    List<BufferedImage> images = new ArrayList<BufferedImage>();
    List<CalibrationObservation> features = new ArrayList<CalibrationObservation>();
    List<ImageResults> results = new ArrayList<ImageResults>();
    int errorScale = 20;

    public MonoPlanarPanel() {
        super(new BorderLayout());
        JToolBar toolBar = this.createToolBar();
        this.imageList = new JList();
        this.imageList.setSelectionMode(0);
        this.imageList.addListSelectionListener(this);
        this.meanError = this.createErrorComponent();
        this.maxError = this.createErrorComponent();
        this.paramCenterX = this.createErrorComponent();
        this.paramCenterY = this.createErrorComponent();
        this.paramA = this.createErrorComponent();
        this.paramB = this.createErrorComponent();
        this.paramC = this.createErrorComponent();
        this.mainView.setImages(this.images);
        this.mainView.setResults(this.features, this.results);
        this.mainView.setDisplay(this.showPoints, this.showErrors, this.showUndistorted, this.showAll, this.showNumbers, this.errorScale);
        this.add((Component)toolBar, "First");
        this.add((Component)this.mainView, "Center");
        this.add((Component)new SideBar(), "West");
    }

    private JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar("Controls");
        this.checkPoints = new JCheckBox("Show Points");
        this.checkPoints.setSelected(this.showPoints);
        this.checkPoints.addItemListener(this);
        this.checkErrors = new JCheckBox("Show Errors");
        this.checkErrors.setSelected(this.showErrors);
        this.checkErrors.addItemListener(this);
        this.checkAll = new JCheckBox("All Points");
        this.checkAll.setSelected(this.showAll);
        this.checkAll.addItemListener(this);
        this.checkUndistorted = new JCheckBox("Undistort");
        this.checkUndistorted.setSelected(this.showUndistorted);
        this.checkUndistorted.addItemListener(this);
        this.checkUndistorted.setEnabled(false);
        this.checkNumbers = new JCheckBox("Numbers");
        this.checkNumbers.setSelected(this.showNumbers);
        this.checkNumbers.addItemListener(this);
        this.selectErrorScale = new JSpinner(new SpinnerNumberModel(this.errorScale, 1, 100, 5));
        this.selectErrorScale.addChangeListener(this);
        this.selectErrorScale.setMaximumSize(this.selectErrorScale.getPreferredSize());
        toolBar.add(this.checkPoints);
        toolBar.add(this.checkErrors);
        toolBar.add(this.checkAll);
        toolBar.add(this.checkUndistorted);
        toolBar.add(this.checkNumbers);
        toolBar.add(new JLabel("| Error Scale"));
        toolBar.add(this.selectErrorScale);
        return toolBar;
    }

    private JTextArea createErrorComponent() {
        JTextArea comp = new JTextArea(1, 6);
        comp.setMaximumSize(comp.getPreferredSize());
        comp.setEditable(false);
        return comp;
    }

    public void addImage(String name, BufferedImage image) {
        this.names.add(name);
        this.images.add(image);
        this.imageList.removeListSelectionListener(this);
        this.imageList.setListData(new Vector<String>(this.names));
        if (this.names.size() == 1) {
            this.imageList.addListSelectionListener(this);
            this.mainView.setPreferredSize(new Dimension(image.getWidth(), image.getHeight()));
            this.imageList.setSelectedIndex(0);
            this.validate();
        } else {
            this.imageList.setSelectedIndex(this.selectedImage);
            this.imageList.addListSelectionListener(this);
        }
    }

    public void setObservations(List<CalibrationObservation> features) {
        this.features = features;
    }

    public void setResults(List<ImageResults> results) {
        this.mainView.setResults(this.features, results);
        this.results = results;
        this.updateResultsGUI();
    }

    public void setCalibration(Zhang99ParamAll found) {
        String textX = String.format("%5.1f", found.x0);
        String textY = String.format("%5.1f", found.y0);
        this.paramCenterX.setText(textX);
        this.paramCenterY.setText(textY);
        String textA = String.format("%5.1f", found.a);
        String textB = String.format("%5.1f", found.b);
        this.paramA.setText(textA);
        this.paramB.setText(textB);
        String textC = String.format("%5.1e", found.c);
        this.paramC.setText(textC);
    }

    public void setCorrection(IntrinsicParameters param) {
        this.checkUndistorted.setEnabled(true);
        this.mainView.setDistorted(param, null);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.checkPoints) {
            this.showPoints = this.checkPoints.isSelected();
        } else if (e.getSource() == this.checkErrors) {
            this.showErrors = this.checkErrors.isSelected();
        } else if (e.getSource() == this.checkAll) {
            this.showAll = this.checkAll.isSelected();
        } else if (e.getSource() == this.checkUndistorted) {
            this.showUndistorted = this.checkUndistorted.isSelected();
        } else if (e.getSource() == this.checkNumbers) {
            this.showNumbers = this.checkNumbers.isSelected();
        }
        this.mainView.setDisplay(this.showPoints, this.showErrors, this.showUndistorted, this.showAll, this.showNumbers, this.errorScale);
        this.mainView.repaint();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting() || e.getFirstIndex() == -1) {
            return;
        }
        if (this.imageList.getSelectedIndex() >= 0) {
            this.setSelected(this.imageList.getSelectedIndex());
            this.mainView.repaint();
        }
    }

    private void setSelected(int selected) {
        this.mainView.setSelected(selected);
        this.selectedImage = selected;
        if (this.results != null) {
            this.updateResultsGUI();
        }
    }

    private void updateResultsGUI() {
        if (this.selectedImage < this.results.size()) {
            ImageResults r = this.results.get(this.selectedImage);
            String textMean = String.format("%5.1e", r.meanError);
            String textMax = String.format("%5.1e", r.maxError);
            this.meanError.setText(textMean);
            this.maxError.setText(textMax);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.selectErrorScale) {
            this.errorScale = ((Number)this.selectErrorScale.getValue()).intValue();
        }
        this.mainView.setDisplay(this.showPoints, this.showErrors, this.showUndistorted, this.showAll, this.showNumbers, this.errorScale);
        this.mainView.repaint();
    }

    private class SideBar
    extends StandardAlgConfigPanel {
        public SideBar() {
            JScrollPane scroll = new JScrollPane(MonoPlanarPanel.this.imageList);
            this.addLabeled(MonoPlanarPanel.this.meanError, "Mean Error", this);
            this.addLabeled(MonoPlanarPanel.this.maxError, "Max Error", this);
            this.addSeparator(200);
            this.addLabeled(MonoPlanarPanel.this.paramCenterX, "Xc", this);
            this.addLabeled(MonoPlanarPanel.this.paramCenterY, "Yc", this);
            this.addLabeled(MonoPlanarPanel.this.paramA, "fx", this);
            this.addLabeled(MonoPlanarPanel.this.paramB, "fy", this);
            this.addLabeled(MonoPlanarPanel.this.paramC, "skew", this);
            this.addSeparator(200);
            this.add(scroll);
        }
    }
}

