/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.fiducial;

import boofcv.factory.shape.ConfigPolygonDetector;
import boofcv.factory.shape.ConfigRefinePolygonLineToImage;
import boofcv.struct.Configuration;

public class ConfigFiducialImage
implements Configuration {
    public double maxErrorFraction = 0.2;
    public double borderWidthFraction = 0.25;
    public double minimumBlackBorderFraction = 0.65;
    public ConfigPolygonDetector squareDetector = new ConfigPolygonDetector(4, 4);

    public ConfigFiducialImage() {
        this.squareDetector.contour2Poly_splitFraction = 0.1;
        this.squareDetector.contour2Poly_minimumSideFraction = 0.05;
        ConfigRefinePolygonLineToImage refineLine = new ConfigRefinePolygonLineToImage();
        refineLine.cornerOffset = 0.0;
        this.squareDetector.refine = refineLine;
    }

    @Override
    public void checkValidity() {
        if (this.borderWidthFraction <= 0.0 || this.borderWidthFraction >= 0.5) {
            throw new IllegalArgumentException("Border width fraction must be 0 < fraction < 0.5");
        }
    }

    public double getMaxErrorFraction() {
        return this.maxErrorFraction;
    }

    public void setMaxErrorFraction(double maxErrorFraction) {
        this.maxErrorFraction = maxErrorFraction;
    }

    public ConfigPolygonDetector getSquareDetector() {
        return this.squareDetector;
    }

    public void setSquareDetector(ConfigPolygonDetector squareDetector) {
        this.squareDetector = squareDetector;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{ maxErrorFraction=" + this.maxErrorFraction + " borderWidthFraction=" + this.borderWidthFraction + " squareDetector=" + this.squareDetector + " }";
    }
}

