/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.stereo;

import boofcv.abst.feature.disparity.StereoDisparity;
import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.LensDistortionOps;
import boofcv.alg.filter.derivative.LaplacianEdge;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.RectifyImageOps;
import boofcv.alg.geo.rectify.RectifyCalibrated;
import boofcv.core.image.border.BorderType;
import boofcv.examples.stereo.ExampleFundamentalMatrix;
import boofcv.factory.feature.disparity.DisparityAlgorithms;
import boofcv.factory.feature.disparity.FactoryStereoDisparity;
import boofcv.factory.geo.ConfigEssential;
import boofcv.factory.geo.ConfigRansac;
import boofcv.factory.geo.FactoryMultiViewRobust;
import boofcv.gui.d3.PointCloudTiltPanel;
import boofcv.gui.feature.AssociationPanel;
import boofcv.gui.image.ShowImages;
import boofcv.gui.image.VisualizeImageData;
import boofcv.gui.stereo.RectifiedPairPanel;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.distort.DoNothingTransform_F64;
import boofcv.struct.distort.PointTransform_F64;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import georegression.struct.se.Se3_F64;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.fitting.modelset.ransac.Ransac;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;

public class ExampleStereoTwoViewsOneCamera {
    private static final int minDisparity = 15;
    private static final int maxDisparity = 100;

    public static void main(String[] args) {
        String calibDir = UtilIO.pathExample("calibration/mono/Sony_DSC-HX5V_Chess/");
        String imageDir = UtilIO.pathExample("stereo/");
        IntrinsicParameters intrinsic = (IntrinsicParameters)UtilIO.loadXML(calibDir, "intrinsic.xml");
        BufferedImage origLeft = UtilImageIO.loadImage(imageDir, "mono_wall_01.jpg");
        BufferedImage origRight = UtilImageIO.loadImage(imageDir, "mono_wall_02.jpg");
        GrayU8 distortedLeft = ConvertBufferedImage.convertFrom(origLeft, (GrayU8)null);
        GrayU8 distortedRight = ConvertBufferedImage.convertFrom(origRight, (GrayU8)null);
        List<AssociatedPair> matchedFeatures = ExampleFundamentalMatrix.computeMatches(origLeft, origRight);
        List<AssociatedPair> matchedCalibrated = ExampleStereoTwoViewsOneCamera.convertToNormalizedCoordinates(matchedFeatures, intrinsic);
        ArrayList<AssociatedPair> inliers = new ArrayList<AssociatedPair>();
        Se3_F64 leftToRight = ExampleStereoTwoViewsOneCamera.estimateCameraMotion(intrinsic, matchedCalibrated, inliers);
        ExampleStereoTwoViewsOneCamera.drawInliers(origLeft, origRight, intrinsic, inliers);
        DenseMatrix64F rectifiedK = new DenseMatrix64F(3, 3);
        GrayU8 rectifiedLeft = (GrayU8)distortedLeft.createSameShape();
        GrayU8 rectifiedRight = (GrayU8)distortedRight.createSameShape();
        ExampleStereoTwoViewsOneCamera.rectifyImages(distortedLeft, distortedRight, leftToRight, intrinsic, rectifiedLeft, rectifiedRight, rectifiedK);
        StereoDisparity<GrayS16, GrayF32> disparityAlg = FactoryStereoDisparity.regionSubpixelWta(DisparityAlgorithms.RECT_FIVE, 15, 100, 5, 5, 20.0, 1, 0.1, GrayS16.class);
        GrayS16 derivLeft = new GrayS16(rectifiedLeft.width, rectifiedLeft.height);
        GrayS16 derivRight = new GrayS16(rectifiedLeft.width, rectifiedLeft.height);
        LaplacianEdge.process(rectifiedLeft, derivLeft);
        LaplacianEdge.process(rectifiedRight, derivRight);
        disparityAlg.process(derivLeft, derivRight);
        GrayF32 disparity = disparityAlg.getDisparity();
        BufferedImage visualized = VisualizeImageData.disparity((ImageGray)disparity, null, 15, 100, 0);
        BufferedImage outLeft = ConvertBufferedImage.convertTo(rectifiedLeft, null);
        BufferedImage outRight = ConvertBufferedImage.convertTo(rectifiedRight, null);
        ShowImages.showWindow(new RectifiedPairPanel(true, outLeft, outRight), "Rectification");
        ShowImages.showWindow(visualized, "Disparity");
        ExampleStereoTwoViewsOneCamera.showPointCloud(disparity, outLeft, leftToRight, rectifiedK, 15, 100);
        System.out.println("Total found " + matchedCalibrated.size());
        System.out.println("Total Inliers " + inliers.size());
    }

    public static Se3_F64 estimateCameraMotion(IntrinsicParameters intrinsic, List<AssociatedPair> matchedNorm, List<AssociatedPair> inliers) {
        Ransac<Se3_F64, AssociatedPair> epipolarMotion = FactoryMultiViewRobust.essentialRansac(new ConfigEssential(intrinsic), new ConfigRansac(200, 0.5));
        if (!epipolarMotion.process(matchedNorm)) {
            throw new RuntimeException("Motion estimation failed");
        }
        inliers.addAll(epipolarMotion.getMatchSet());
        return (Se3_F64)epipolarMotion.getModelParameters();
    }

    public static List<AssociatedPair> convertToNormalizedCoordinates(List<AssociatedPair> matchedFeatures, IntrinsicParameters intrinsic) {
        PointTransform_F64 p_to_n = LensDistortionOps.transformPoint(intrinsic).undistort_F64(true, false);
        ArrayList<AssociatedPair> calibratedFeatures = new ArrayList<AssociatedPair>();
        for (AssociatedPair p : matchedFeatures) {
            AssociatedPair c = new AssociatedPair();
            p_to_n.compute(p.p1.x, p.p1.y, c.p1);
            p_to_n.compute(p.p2.x, p.p2.y, c.p2);
            calibratedFeatures.add(c);
        }
        return calibratedFeatures;
    }

    public static void rectifyImages(GrayU8 distortedLeft, GrayU8 distortedRight, Se3_F64 leftToRight, IntrinsicParameters intrinsic, GrayU8 rectifiedLeft, GrayU8 rectifiedRight, DenseMatrix64F rectifiedK) {
        RectifyCalibrated rectifyAlg = RectifyImageOps.createCalibrated();
        DenseMatrix64F K = PerspectiveOps.calibrationMatrix(intrinsic, null);
        rectifyAlg.process(K, new Se3_F64(), K, leftToRight);
        DenseMatrix64F rect1 = rectifyAlg.getRect1();
        DenseMatrix64F rect2 = rectifyAlg.getRect2();
        rectifiedK.set((D1Matrix64F)rectifyAlg.getCalibrationMatrix());
        RectifyImageOps.allInsideLeft(intrinsic, rect1, rect2, rectifiedK);
        ImageDistort distortLeft = RectifyImageOps.rectifyImage(intrinsic, rect1, BorderType.SKIP, distortedLeft.getImageType());
        ImageDistort distortRight = RectifyImageOps.rectifyImage(intrinsic, rect2, BorderType.SKIP, distortedRight.getImageType());
        distortLeft.apply(distortedLeft, rectifiedLeft);
        distortRight.apply(distortedRight, rectifiedRight);
    }

    public static void drawInliers(BufferedImage left, BufferedImage right, IntrinsicParameters intrinsic, List<AssociatedPair> normalized) {
        PointTransform_F64 n_to_p = LensDistortionOps.transformPoint(intrinsic).distort_F64(false, true);
        ArrayList<AssociatedPair> pixels = new ArrayList<AssociatedPair>();
        for (AssociatedPair n : normalized) {
            AssociatedPair p = new AssociatedPair();
            n_to_p.compute(n.p1.x, n.p1.y, p.p1);
            n_to_p.compute(n.p2.x, n.p2.y, p.p2);
            pixels.add(p);
        }
        AssociationPanel panel = new AssociationPanel(20);
        panel.setAssociation(pixels);
        panel.setImages(left, right);
        ShowImages.showWindow(panel, "Inlier Features");
    }

    public static void showPointCloud(ImageGray disparity, BufferedImage left, Se3_F64 motion, DenseMatrix64F rectifiedK, int minDisparity, int maxDisparity) {
        PointCloudTiltPanel gui = new PointCloudTiltPanel();
        double baseline = motion.getT().norm();
        gui.configure(baseline, rectifiedK, new DoNothingTransform_F64(), minDisparity, maxDisparity);
        gui.process(disparity, left);
        gui.setPreferredSize(new Dimension(left.getWidth(), left.getHeight()));
        ShowImages.showWindow(gui, "Point Cloud");
    }
}

