/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.stereo;

import boofcv.abst.feature.disparity.StereoDisparity;
import boofcv.alg.distort.ImageDistort;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.RectifyImageOps;
import boofcv.alg.geo.rectify.RectifyCalibrated;
import boofcv.core.image.border.BorderType;
import boofcv.factory.feature.disparity.DisparityAlgorithms;
import boofcv.factory.feature.disparity.FactoryStereoDisparity;
import boofcv.gui.ListDisplayPanel;
import boofcv.gui.image.ShowImages;
import boofcv.gui.image.VisualizeImageData;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import georegression.struct.se.Se3_F64;
import java.awt.image.BufferedImage;
import org.ejml.data.DenseMatrix64F;

public class ExampleStereoDisparity {
    public static GrayU8 denseDisparity(GrayU8 rectLeft, GrayU8 rectRight, int regionSize, int minDisparity, int maxDisparity) {
        StereoDisparity<GrayU8, GrayU8> disparityAlg = FactoryStereoDisparity.regionWta(DisparityAlgorithms.RECT_FIVE, minDisparity, maxDisparity, regionSize, regionSize, 25.0, 1, 0.2, GrayU8.class);
        disparityAlg.process(rectLeft, rectRight);
        return disparityAlg.getDisparity();
    }

    public static GrayF32 denseDisparitySubpixel(GrayU8 rectLeft, GrayU8 rectRight, int regionSize, int minDisparity, int maxDisparity) {
        StereoDisparity<GrayU8, GrayF32> disparityAlg = FactoryStereoDisparity.regionSubpixelWta(DisparityAlgorithms.RECT_FIVE, minDisparity, maxDisparity, regionSize, regionSize, 25.0, 1, 0.2, GrayU8.class);
        disparityAlg.process(rectLeft, rectRight);
        return disparityAlg.getDisparity();
    }

    public static RectifyCalibrated rectify(GrayU8 origLeft, GrayU8 origRight, StereoParameters param, GrayU8 rectLeft, GrayU8 rectRight) {
        RectifyCalibrated rectifyAlg = RectifyImageOps.createCalibrated();
        Se3_F64 leftToRight = param.getRightToLeft().invert(null);
        DenseMatrix64F K1 = PerspectiveOps.calibrationMatrix(param.getLeft(), null);
        DenseMatrix64F K2 = PerspectiveOps.calibrationMatrix(param.getRight(), null);
        rectifyAlg.process(K1, new Se3_F64(), K2, leftToRight);
        DenseMatrix64F rect1 = rectifyAlg.getRect1();
        DenseMatrix64F rect2 = rectifyAlg.getRect2();
        DenseMatrix64F rectK = rectifyAlg.getCalibrationMatrix();
        RectifyImageOps.allInsideLeft(param.left, rect1, rect2, rectK);
        ImageDistort imageDistortLeft = RectifyImageOps.rectifyImage(param.getLeft(), rect1, BorderType.SKIP, origLeft.getImageType());
        ImageDistort imageDistortRight = RectifyImageOps.rectifyImage(param.getRight(), rect2, BorderType.SKIP, origRight.getImageType());
        imageDistortLeft.apply(origLeft, rectLeft);
        imageDistortRight.apply(origRight, rectRight);
        return rectifyAlg;
    }

    public static void main(String[] args) {
        String calibDir = UtilIO.pathExample("calibration/stereo/Bumblebee2_Chess/");
        String imageDir = UtilIO.pathExample("stereo/");
        StereoParameters param = (StereoParameters)UtilIO.loadXML(calibDir, "stereo.xml");
        BufferedImage origLeft = UtilImageIO.loadImage(imageDir, "chair01_left.jpg");
        BufferedImage origRight = UtilImageIO.loadImage(imageDir, "chair01_right.jpg");
        GrayU8 distLeft = ConvertBufferedImage.convertFrom(origLeft, (GrayU8)null);
        GrayU8 distRight = ConvertBufferedImage.convertFrom(origRight, (GrayU8)null);
        GrayU8 rectLeft = (GrayU8)distLeft.createSameShape();
        GrayU8 rectRight = (GrayU8)distRight.createSameShape();
        ExampleStereoDisparity.rectify(distLeft, distRight, param, rectLeft, rectRight);
        GrayU8 disparity = ExampleStereoDisparity.denseDisparity(rectLeft, rectRight, 5, 10, 60);
        BufferedImage visualized = VisualizeImageData.disparity((ImageGray)disparity, null, 10, 60, 0);
        ListDisplayPanel gui = new ListDisplayPanel();
        gui.addImage(rectLeft, "Rectified");
        gui.addImage(visualized, "Disparity");
        ShowImages.showWindow(gui, "Stereo Disparity", true);
    }
}

