/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.sfm;

import boofcv.abst.feature.detect.interest.ConfigGeneralDetector;
import boofcv.abst.feature.tracker.PointTracker;
import boofcv.abst.sfm.AccessPointTracks3D;
import boofcv.abst.sfm.d3.MonocularPlaneVisualOdometry;
import boofcv.abst.sfm.d3.VisualOdometry;
import boofcv.alg.tracker.klt.PkltConfig;
import boofcv.factory.feature.tracker.FactoryPointTracker;
import boofcv.factory.sfm.FactoryVisualOdometry;
import boofcv.io.UtilIO;
import boofcv.io.image.SimpleImageSequence;
import boofcv.io.wrapper.DefaultMediaManager;
import boofcv.struct.calib.MonoPlaneParameters;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;

public class ExampleVisualOdometryMonocularPlane {
    public static void main(String[] args) {
        DefaultMediaManager media = DefaultMediaManager.INSTANCE;
        String directory = UtilIO.pathExample("vo/drc/");
        MonoPlaneParameters calibration = (MonoPlaneParameters)UtilIO.loadXML(media.openFile(directory + "mono_plane.xml"));
        SimpleImageSequence<GrayU8> video = media.openVideo(directory + "left.mjpeg", ImageType.single(GrayU8.class));
        PkltConfig configKlt = new PkltConfig();
        configKlt.pyramidScaling = new int[]{1, 2, 4, 8};
        configKlt.templateRadius = 3;
        ConfigGeneralDetector configDetector = new ConfigGeneralDetector(600, 3, 1.0f);
        PointTracker<GrayU8> tracker = FactoryPointTracker.klt(configKlt, configDetector, GrayU8.class, null);
        MonocularPlaneVisualOdometry<GrayU8> visualOdometry = FactoryVisualOdometry.monoPlaneInfinity(75, 2, 1.5, 200, tracker, ImageType.single(GrayU8.class));
        visualOdometry.setCalibration(calibration);
        while (video.hasNext()) {
            GrayU8 image = video.next();
            if (!visualOdometry.process(image)) {
                System.out.println("Fault!");
                visualOdometry.reset();
            }
            Se3_F64 leftToWorld = (Se3_F64)visualOdometry.getCameraToWorld();
            Vector3D_F64 T = leftToWorld.getT();
            System.out.printf("Location %8.2f %8.2f %8.2f      inliers %s\n", T.x, T.y, T.z, ExampleVisualOdometryMonocularPlane.inlierPercent(visualOdometry));
        }
    }

    public static String inlierPercent(VisualOdometry<?> alg) {
        if (!(alg instanceof AccessPointTracks3D)) {
            return "";
        }
        AccessPointTracks3D access = (AccessPointTracks3D)((Object)alg);
        int count = 0;
        int N = access.getAllTracks().size();
        for (int i = 0; i < N; ++i) {
            if (!access.isInlier(i)) continue;
            ++count;
        }
        return String.format("%%%5.3f", 100.0 * (double)count / (double)N);
    }
}

